<?php

/* Remove unused params */

remove_action( 'customize_register', 'boldthemes_customize_blog_side_info' );
remove_action( 'boldthemes_customize_register', 'boldthemes_customize_blog_side_info' );


// HEADING WEIGHT

BoldThemes_Customize_Default::$data['default_heading_weight'] = 'default';

if ( ! function_exists( 'boldthemes_customize_default_heading_weight' ) ) {
	function boldthemes_customize_default_heading_weight( $wp_customize ) {

		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[default_heading_weight]', array(
			'default'           => BoldThemes_Customize_Default::$data['default_heading_weight'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select'
		));
		$wp_customize->add_control( 'default_heading_weight', array(
			'label'     => esc_html__( 'Heading Weight', 'pawsitive' ),
			'section'   => BoldThemesFramework::$pfx . '_typo_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[default_heading_weight]',
			'priority'  => 100,
			'type'      => 'select',
			'choices'   => array(
				'default'	=> esc_html__( 'Default', 'pawsitive' ),
				'thin' 		=> esc_html__( 'Thin', 'pawsitive' ),
				'lighter' 	=> esc_html__( 'Lighter', 'pawsitive' ),
				'light' 	=> esc_html__( 'Light', 'pawsitive' ),
				'normal' 	=> esc_html__( 'Normal', 'pawsitive' ),
				'medium' 	=> esc_html__( 'Medium', 'pawsitive' ),
				'semi-bold' => esc_html__( 'Semi bold', 'pawsitive' ),
				'bold' 		=> esc_html__( 'Bold', 'pawsitive' ),
				'bolder' 	=> esc_html__( 'Bolder', 'pawsitive' ),
				'black' 	=> esc_html__( 'Black', 'pawsitive' )
			)
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_default_heading_weight' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_default_heading_weight' );


// MENU WEIGHT

BoldThemes_Customize_Default::$data['default_menu_weight'] = 'default';

if ( ! function_exists( 'boldthemes_customize_default_menu_weight' ) ) {
	function boldthemes_customize_default_menu_weight( $wp_customize ) {

		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[default_menu_weight]', array(
			'default'           => BoldThemes_Customize_Default::$data['default_menu_weight'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select'
		));
		$wp_customize->add_control( 'default_menu_weight', array(
			'label'     => esc_html__( 'Menu Font Weight', 'pawsitive' ),
			'section'   => BoldThemesFramework::$pfx . '_typo_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[default_menu_weight]',
			'priority'  => 102,
			'type'      => 'select',
			'choices'   => array(
				'default'	=> esc_html__( 'Default', 'pawsitive' ),
				'thin' 		=> esc_html__( 'Thin', 'pawsitive' ),
				'lighter' 	=> esc_html__( 'Lighter', 'pawsitive' ),
				'light' 	=> esc_html__( 'Light', 'pawsitive' ),
				'normal' 	=> esc_html__( 'Normal', 'pawsitive' ),
				'medium' 	=> esc_html__( 'Medium', 'pawsitive' ),
				'semi-bold' => esc_html__( 'Semi bold', 'pawsitive' ),
				'bold' 		=> esc_html__( 'Bold', 'pawsitive' ),
				'bolder' 	=> esc_html__( 'Bolder', 'pawsitive' ),
				'black' 	=> esc_html__( 'Black', 'pawsitive' )
			)
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_default_menu_weight' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_default_menu_weight' );


// CAPITALIZE MAIN MENU

BoldThemes_Customize_Default::$data['capitalize_main_menu'] = false;
if ( ! function_exists( 'boldthemes_customize_capitalize_main_menu' ) ) {
	function boldthemes_customize_capitalize_main_menu( $wp_customize ) {
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[capitalize_main_menu]', array(
			'default'           => BoldThemes_Customize_Default::$data['capitalize_main_menu'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_checkbox'
		));
		$wp_customize->add_control( 'capitalize_main_menu', array(
			'label'     => esc_html__( 'Capitalize Menu Items', 'pawsitive' ),
			'section'   => BoldThemesFramework::$pfx . '_typo_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[capitalize_main_menu]',
			'priority'  => 103,
			'type'      => 'checkbox'
		));
	}
}

add_action( 'customize_register', 'boldthemes_customize_capitalize_main_menu' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_capitalize_main_menu' );


// BUTTON FONT

BoldThemes_Customize_Default::$data['button_font'] = 'Nunito Sans';
if ( ! function_exists( 'boldthemes_customize_button_font' ) ) {
	function boldthemes_customize_button_font( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[button_font]', array(
			'default'           => urlencode( BoldThemes_Customize_Default::$data['button_font'] ),
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select'
		));
		$wp_customize->add_control( 'button_font', array(
			'label'     => esc_html__( 'Button Font', 'pawsitive' ),
			'section'   => BoldThemesFramework::$pfx . '_typo_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[button_font]',
			'priority'  => 101,
			'type'      => 'select',
			'choices'   => BoldThemesFramework::$customize_fonts
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_button_font' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_button_font' );



// BUTTON FONT WEIGHT

BoldThemes_Customize_Default::$data['default_button_weight'] = 'default';

if ( ! function_exists( 'boldthemes_customize_default_button_weight' ) ) {
	function boldthemes_customize_default_button_weight( $wp_customize ) {

		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[default_button_weight]', array(
			'default'           => BoldThemes_Customize_Default::$data['default_button_weight'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select'
		));
		$wp_customize->add_control( 'default_button_weight', array(
			'label'     => esc_html__( 'Button Font Weight', 'pawsitive' ),
			'section'   => BoldThemesFramework::$pfx . '_typo_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[default_button_weight]',
			'priority'  => 101,
			'type'      => 'select',
			'choices'   => array(
				'default'	=> esc_html__( 'Default', 'pawsitive' ),
				'thin' 		=> esc_html__( 'Thin', 'pawsitive' ),
				'lighter' 	=> esc_html__( 'Lighter', 'pawsitive' ),
				'light' 	=> esc_html__( 'Light', 'pawsitive' ),
				'normal' 	=> esc_html__( 'Normal', 'pawsitive' ),
				'medium' 	=> esc_html__( 'Medium', 'pawsitive' ),
				'semi-bold' => esc_html__( 'Semi bold', 'pawsitive' ),
				'bold' 		=> esc_html__( 'Bold', 'pawsitive' ),
				'bolder' 	=> esc_html__( 'Bolder', 'pawsitive' ),
				'black' 	=> esc_html__( 'Black', 'pawsitive' )
			)
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_default_button_weight' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_default_button_weight' );


// HIGHLIGHT CURRENT PAGE

BoldThemes_Customize_Default::$data['highlight_current_page'] = 'default';

if ( ! function_exists( 'boldthemes_customize_highlight_current_page' ) ) {
	function boldthemes_customize_highlight_current_page( $wp_customize ) {

		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[highlight_current_page]', array(
			'default'           => BoldThemes_Customize_Default::$data['highlight_current_page'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select'
		));
		$wp_customize->add_control( 'highlight_current_page', array(
			'label'     => esc_html__( 'Highlight Current Page', 'pawsitive' ),
			'section'  => BoldThemesFramework::$pfx . '_header_footer_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[highlight_current_page]',
			'priority'  => 100,
			'type'      => 'select',
			'choices'   => array(
				'default'	=> esc_html__( 'Underline', 'pawsitive' ),
				'dot' 		=> esc_html__( 'Dot', 'pawsitive' )
			)
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_highlight_current_page' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_highlight_current_page' );


// THIRD COLOR

if ( ! function_exists( 'boldthemes_customize_third_color' ) ) {
	function boldthemes_customize_third_color( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[third_color]', array(
			'default'        	   => BoldThemes_Customize_Default::$data['third_color'],
			'type'           	   => 'option',
			'capability'     	   => 'edit_theme_options',
			'sanitize_callback'    => 'sanitize_hex_color'
		));
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'third_color', array(
			'label'    => esc_html__( 'Third Color', 'pawsitive' ),
			'section'  => BoldThemesFramework::$pfx . '_general_section',
			'settings' => BoldThemesFramework::$pfx . '_theme_options[third_color]',
			'priority' => 26,
			'context'  => BoldThemesFramework::$pfx . '_third_color'
		)));
	}
}
add_action( 'customize_register', 'boldthemes_customize_third_color' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_third_color' );


// FOURTH COLOR
if ( ! function_exists( 'boldthemes_customize_fourth_color' ) ) {
	function boldthemes_customize_fourth_color( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[fourth_color]', array(
			'default'        	   => BoldThemes_Customize_Default::$data['fourth_color'],
			'type'           	   => 'option',
			'capability'     	   => 'edit_theme_options',
			'sanitize_callback'    => 'sanitize_hex_color'
		));
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fourth_color', array(
			'label'    => esc_html__( 'Fourth Color', 'pawsitive' ),
			'section'  => BoldThemesFramework::$pfx . '_general_section',
			'settings' => BoldThemesFramework::$pfx . '_theme_options[fourth_color]',
			'priority' => 26,
			'context'  => BoldThemesFramework::$pfx . '_fourth_color'
		)));
	}
}
add_action( 'customize_register', 'boldthemes_customize_fourth_color' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_fourth_color' );



/* Helper function */

if ( ! function_exists( 'pawsitive_body_class' ) ) {
	function pawsitive_body_class( $extra_class ) {
		if ( boldthemes_get_option( 'default_heading_weight' ) ) {
			$extra_class[] =  'btHeadingWeight' . boldthemes_convert_param_to_camel_case ( boldthemes_get_option( 'default_heading_weight' ) );
		}
		if ( boldthemes_get_option( 'highlight_current_page' ) ) {
			$extra_class[] =  'btHighlightCurrentPage' . boldthemes_convert_param_to_camel_case ( boldthemes_get_option( 'highlight_current_page' ) );
		}
		if ( boldthemes_get_option( 'default_button_weight' ) ) {
			$extra_class[] =  'btButtonWeight' . boldthemes_convert_param_to_camel_case ( boldthemes_get_option( 'default_button_weight' ) );
		}
		return $extra_class;
	}
}