<?php

// Register action/filter callbacks

add_action( 'after_setup_theme', 'pawsitive_register_menus' );
add_action( 'wp_enqueue_scripts', 'pawsitive_enqueue_scripts_styles' );
add_action( 'tgmpa_register', 'pawsitive_register_plugins' );
add_action( 'wp_enqueue_scripts', 'pawsitive_load_fonts' );
add_action( 'admin_init', 'pawsitive_theme_add_editor_styles' );
add_action( 'admin_enqueue_scripts', 'pawsitive_load_fonts' );
add_action( 'admin_enqueue_scripts', 'pawsitive_load_admin_style' );

add_action( 'widgets_init', 'pawsitive_widget_area' );

add_filter( 'bt_bb_color_scheme_arr', 'pawsitive_color_schemes' );

add_filter( 'body_class', 'pawsitive_body_class' );

add_filter( 'tiny_mce_before_init', 'pawsitive_editor_dynamic_styles' );

add_theme_support( 'customize-selective-refresh-widgets' );

// callbacks

/**
 * Register navigation menus
 */
if ( ! function_exists( 'pawsitive_register_menus' ) ) {
	function pawsitive_register_menus() {
		register_nav_menus( array (
			'primary' => esc_html__( 'Primary Menu', 'pawsitive' ),
			'footer'  => esc_html__( 'Footer Menu', 'pawsitive' )
		));
	}
}

/**
 * Enqueue scripts and styles
 */
if ( ! function_exists( 'pawsitive_enqueue_scripts_styles' ) ) {
	function pawsitive_enqueue_scripts_styles() {
		
		BoldThemesFramework::$crush_vars_def = array( 'accentColor', 'alternateColor', 'thirdColor', 'fourthColor', 'bodyFont', 'menuFont', 'headingFont', 'headingSuperTitleFont', 'headingSubTitleFont', 'buttonFont', 'logoHeight' );
		
		// Custom accent color and font style
		$boldthemes_add_override_css = false;		
		
		$accent_color = boldthemes_get_option( 'accent_color' );
		$alternate_color = boldthemes_get_option( 'alternate_color' );

		$third_color = boldthemes_get_option( 'third_color' );
		$fourth_color = boldthemes_get_option( 'fourth_color' );

		$body_font = urldecode( boldthemes_get_option( 'body_font' ) );
		$menu_font = urldecode( boldthemes_get_option( 'menu_font' ) );
		$heading_font = urldecode( boldthemes_get_option( 'heading_font' ) );
		$heading_supertitle_font = urldecode( boldthemes_get_option( 'heading_supertitle_font' ) );
		$heading_subtitle_font = urldecode( boldthemes_get_option( 'heading_subtitle_font' ) );
		$button_font = urldecode( boldthemes_get_option( 'button_font' ) );
		$logo_height = urldecode( boldthemes_get_option( 'logo_height' ) );

		if ( $accent_color != '' ) {
			BoldThemesFramework::$crush_vars['accentColor'] = $accent_color;
			if ( $accent_color != BoldThemes_Customize_Default::$data['accent_color'] ) {
				$boldthemes_add_override_css = true;
			}
		}

		if ( $alternate_color != '' ) {
			BoldThemesFramework::$crush_vars['alternateColor'] = $alternate_color;
			if ( $alternate_color != BoldThemes_Customize_Default::$data['alternate_color'] ) {
				$boldthemes_add_override_css = true;
			}
		}

		if ( $third_color != '' ) {
			BoldThemesFramework::$crush_vars['thirdColor'] = $third_color;
			if ( $third_color != BoldThemes_Customize_Default::$data['third_color'] ) {
				$boldthemes_add_override_css = true;
			}
		}

		if ( $fourth_color != '' ) {
			BoldThemesFramework::$crush_vars['fourthColor'] = $fourth_color;
			if ( $fourth_color != BoldThemes_Customize_Default::$data['fourth_color'] ) {
				$boldthemes_add_override_css = true;
			}
		}


		if ( $body_font != '' ) {
			if ( $body_font == 'no_change' ) {
				$body_font = BoldThemes_Customize_Default::$data['body_font'];
			}
			BoldThemesFramework::$crush_vars['bodyFont'] = $body_font;
			if ( $body_font != BoldThemes_Customize_Default::$data['body_font'] ) {
				$boldthemes_add_override_css = true;
			}
		}

		if ( $menu_font != '' ) {
			if ( $menu_font == 'no_change' ) {
				$menu_font = BoldThemes_Customize_Default::$data['menu_font'];
			}
			BoldThemesFramework::$crush_vars['menuFont'] = $menu_font;
			if ( $menu_font != BoldThemes_Customize_Default::$data['menu_font'] ) {
				$boldthemes_add_override_css = true;
			}
		}

		if ( $heading_font != '' ) {
			if ( $heading_font == 'no_change' ) {
				$heading_font = BoldThemes_Customize_Default::$data['heading_font'];
			}
			BoldThemesFramework::$crush_vars['headingFont'] = $heading_font;
			if ( $heading_font != BoldThemes_Customize_Default::$data['heading_font'] ) {
				$boldthemes_add_override_css = true;
			}
		}

		if ( $heading_supertitle_font != '' ) {
			if ( $heading_supertitle_font == 'no_change' ) {
				$heading_supertitle_font = BoldThemes_Customize_Default::$data['heading_supertitle_font'];
			}
			BoldThemesFramework::$crush_vars['headingSuperTitleFont'] = $heading_supertitle_font;
			if ( $heading_supertitle_font != BoldThemes_Customize_Default::$data['heading_supertitle_font'] ) {
				$boldthemes_add_override_css = true;
			}
		}

		if ( $heading_subtitle_font != '' ) {
			if ( $heading_subtitle_font == 'no_change' ) {
				$heading_subtitle_font = BoldThemes_Customize_Default::$data['heading_subtitle_font'];
			}
			BoldThemesFramework::$crush_vars['headingSubTitleFont'] = $heading_subtitle_font;
			if ( $heading_subtitle_font != BoldThemes_Customize_Default::$data['heading_subtitle_font'] ) {
				$boldthemes_add_override_css = true;
			}
		}

		if ( $button_font != '' ) {
			if ( $button_font == 'no_change' ) {
				$button_font = BoldThemes_Customize_Default::$data['button_font'];
			}
			BoldThemesFramework::$crush_vars['buttonFont'] = $button_font;
			if ( $button_font != BoldThemes_Customize_Default::$data['button_font'] ) {
				$boldthemes_add_override_css = true;
			}
		}
		
		if ( $logo_height != '' ) {
			BoldThemesFramework::$crush_vars['logoHeight'] = $logo_height;
			if ( $logo_height != BoldThemes_Customize_Default::$data['logo_height'] ) {
				$boldthemes_add_override_css = true;
			}
		}

		// Create override file without local settings

		if ( function_exists( 'boldthemes_csscrush_file' ) ) {
			boldthemes_csscrush_file( get_theme_file_path( 'style.crush.css' ), array( 'source_map' => true, 'minify' => false, 'output_file' => 'style', 'formatter' => 'block', 'boilerplate' => false, 'vars' => BoldThemesFramework::$crush_vars, 'plugins' => array( 'loop', 'ease' ) ) );
		}

		// custom theme css
		wp_enqueue_style( 'pawsitive-style', get_parent_theme_file_uri( 'style.css' ), array(), false, 'screen' );
		wp_enqueue_style( 'pawsitive-print', get_parent_theme_file_uri( 'print.css' ), array(), false, 'print' );

		// external js
		wp_enqueue_script( 'fancySelect', get_parent_theme_file_uri( 'framework/js/fancySelect.js' ), array( 'jquery' ), '', true );

		// custom theme js
		wp_enqueue_script( 'pawsitive-header-misc', get_parent_theme_file_uri( 'framework/js/header.misc.js' ), array( 'jquery' ), '', true );
		wp_enqueue_script( 'pawsitive-misc', get_parent_theme_file_uri( 'framework/js/misc.js' ), array( 'jquery' ), '', true );
		
		wp_add_inline_script( 'pawsitive-header-misc', boldthemes_set_global_uri(), 'before' );
		
		if ( file_exists( get_parent_theme_file_path( 'css-override.php' ) ) && $boldthemes_add_override_css ) {
			require_once( get_parent_theme_file_path( 'css-override.php' ) );
			wp_add_inline_style( 'pawsitive-style', $css_override );
		}
		
		if ( file_exists( get_parent_theme_file_path( 'icons.php' ) ) ) {
			require_once( get_parent_theme_file_path( 'icons.php' ) );
			wp_add_inline_style( 'pawsitive-style', $icons );
		}

		if ( boldthemes_get_option( 'custom_js' ) != '' ) {
			wp_add_inline_script( 'pawsitive-misc', boldthemes_get_option( 'custom_js' ) );
		}	
		
	}
}

/**
 * Register the required plugins for this theme
 */
if ( ! function_exists( 'pawsitive_register_plugins' ) ) {
	function pawsitive_register_plugins() {

		$plugins = array(
	 
			array(
				'name'               => esc_html__( 'Pawsitive', 'pawsitive' ), // The plugin name.
				'slug'               => 'pawsitive', // The plugin slug (typically the folder name).
				'source'             => get_parent_theme_file_path( 'plugins/pawsitive.zip' ), // The plugin source.
				'required'           => true, // If false, the plugin is only 'recommended' instead of required.
				'version'            => '1.2.2', ///!do not change this comment! E.g. 1.0.0. If set, the active plugin must be this version or higher.
				'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
				'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
				'external_url'       => '', // If set, overrides default API URL and points to an external URL.
			),
			array(
				'name'               => esc_html__( 'Cost Calculator', 'pawsitive' ), // The plugin name.
				'slug'               => 'bt' . '_cost_calculator', // The plugin slug (typically the folder name).
				'source'             => get_parent_theme_file_path( 'plugins/' . 'bt' . '_cost_calculator.zip' ), // The plugin source.
				'required'           => true, // If false, the plugin is only 'recommended' instead of required.
				'version'            => '2.2.3', // E.g. 1.0.0. If set, the active plugin must be this version or higher.
				'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
				'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
				'external_url'       => '', // If set, overrides default API URL and points to an external URL.
			),
			array(
				'name'               => esc_html__( 'Bold Timeline', 'pawsitive' ), // The plugin name.
				'slug'               => 'bold-timeline', // The plugin slug (typically the folder name).
				'source'             => get_parent_theme_file_path( 'plugins/' . 'bold-timeline.zip' ), // The plugin source.
				'required'           => true, // If false, the plugin is only 'recommended' instead of required.
				'version'            => '1.0.3', // E.g. 1.0.0. If set, the active plugin must be this version or higher.
				'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
				'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
				'external_url'       => '', // If set, overrides default API URL and points to an external URL.
			),
			array(
				'name'               => esc_html__( 'Bold Builder', 'pawsitive' ), // The plugin name.
				'slug'               => 'bold-page-builder', // The plugin slug (typically the folder name).
				'required'           => true, // If false, the plugin is only 'recommended' instead of required.
				'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
				'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			),
			array(
				'name'               => esc_html__( 'BoldThemes WordPress Importer', 'pawsitive' ), // The plugin name.
				'slug'               => 'bt' . '_wordpress_importer', // The plugin slug (typically the folder name).
				'source'             => get_parent_theme_file_path( 'plugins/' . 'bt' . '_wordpress_importer.zip' ), // The plugin source.
				'required'           => true, // If false, the plugin is only 'recommended' instead of required.
				'version'            => '2.6.1', // E.g. 1.0.0. If set, the active plugin must be this version or higher.
				'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
				'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
				'external_url'       => '', // If set, overrides default API URL and points to an external URL.
			),
			array(
				'name'               => esc_html__( 'Meta Box', 'pawsitive' ), // The plugin name.
				'slug'               => 'meta-box', // The plugin slug (typically the folder name).
				'required'           => true, // If false, the plugin is only 'recommended' instead of required.
				'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
				'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			),
			array(
				'name'               => esc_html__( 'Contact Form 7', 'pawsitive' ), // The plugin name.
				'slug'               => 'contact-form-7', // The plugin slug (typically the folder name).
				'required'           => true, // If false, the plugin is only 'recommended' instead of required.
				'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
				'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			),
			array(
				'name'               => esc_html__( 'Lightweight Sidebar Manager', 'pawsitive' ), // The plugin name.
				'slug'               => 'sidebar-manager', // The plugin slug (typically the folder name).
				'required'           => true, // If false, the plugin is only 'recommended' instead of required.
				'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
				'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			)
		);
	 
		$config = array(
			'default_path' => '',                      // Default absolute path to pre-packaged plugins.
			'menu'         => 'tgmpa-install-plugins', // Menu slug.
			'has_notices'  => true,                    // Show admin notices or not.
			'dismissable'  => false,                    // If false, a user cannot dismiss the nag message.
			'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
			'is_automatic' => false,                   // Automatically activate plugins after installation or not.
			'message'      => '',                      // Message to output right before the plugins table.
			'strings'      => array(
				'page_title'                      => esc_html__( 'Install Required Plugins', 'pawsitive' ),
				'menu_title'                      => esc_html__( 'Install Plugins', 'pawsitive' ),
				'installing'                      => esc_html__( 'Installing Plugin: %s', 'pawsitive' ), // %s = plugin name.
				'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'pawsitive' ),
				'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'pawsitive' ), // %1$s = plugin name(s).
				'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'pawsitive' ), // %1$s = plugin name(s).
				'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'pawsitive' ), // %1$s = plugin name(s).
				'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'pawsitive' ), // %1$s = plugin name(s).
				'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'pawsitive' ), // %1$s = plugin name(s).
				'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'pawsitive' ), // %1$s = plugin name(s).
				'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'pawsitive' ), // %1$s = plugin name(s).
				'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'pawsitive' ), // %1$s = plugin name(s).
				'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'pawsitive' ),
				'activate_link'                   => _n_noop( 'Begin activating plugin', 'Begin activating plugins', 'pawsitive' ),
				'return'                          => esc_html__( 'Return to Required Plugins Installer', 'pawsitive' ),
				'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'pawsitive' ),
				'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'pawsitive' ), // %s = dashboard link.
				'nag_type'                        => 'updated' // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
			)
		);
	 
		tgmpa( $plugins, $config );
	 
	}
}

/**
 * Loads custom Google Fonts
 */
if ( ! function_exists( 'pawsitive_load_fonts' ) ) {
	function pawsitive_load_fonts() {
		$body_font = urldecode( boldthemes_get_option( 'body_font' ) );
		$heading_font = urldecode( boldthemes_get_option( 'heading_font' ) );
		$menu_font = urldecode( boldthemes_get_option( 'menu_font' ) );
		$heading_subtitle_font = urldecode( boldthemes_get_option( 'heading_subtitle_font' ) );
		$heading_supertitle_font = urldecode( boldthemes_get_option( 'heading_supertitle_font' ) );
		$button_font = urldecode( boldthemes_get_option( 'button_font' ) );
		
		$font_families = array();
		
		if ( $body_font != '' ) {
			if ( $body_font == 'no_change' ) {
				$body_font = BoldThemes_Customize_Default::$data['body_font'];
			}
			$font_families[] = $body_font . ':100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic';
		} else {
			/*
			Translators: If there are characters in your language that are not supported
			by chosen font(s), translate this to 'off'. Do not translate into your own language.
			 */
			if ( 'off' !== _x( 'on', 'Lato font: on or off', 'pawsitive' ) ) {
				$font_families[] = 'Lato' . ':100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic';
			}
		}
		
		if ( $heading_font != '' ) {
			if ( $heading_font == 'no_change' ) {
				$heading_font = BoldThemes_Customize_Default::$data['heading_font'];
			}
			$font_families[] = $heading_font . ':100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic';
		} else {
			/*
			Translators: If there are characters in your language that are not supported
			by chosen font(s), translate this to 'off'. Do not translate into your own language.
			 */
			if ( 'off' !== _x( 'on', 'Lato font: on or off', 'pawsitive' ) ) {
				$font_families[] = 'Lato' . ':100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic';
			}
		}
		
		if ( $menu_font != '' ) {
			if ( $menu_font == 'no_change' ) {
				$menu_font = BoldThemes_Customize_Default::$data['menu_font'];
			}
			$font_families[] = $menu_font . ':100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic';
		} else {
			/*
			Translators: If there are characters in your language that are not supported
			by chosen font(s), translate this to 'off'. Do not translate into your own language.
			 */
			if ( 'off' !== _x( 'on', 'Lato font: on or off', 'pawsitive' ) ) {
				$font_families[] = 'Lato' . ':100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic';
			}
		}

		if ( $heading_subtitle_font != '' ) {
			if ( $heading_subtitle_font == 'no_change' ) {
				$heading_subtitle_font = BoldThemes_Customize_Default::$data['heading_subtitle_font'];
			}
			$font_families[] = $heading_subtitle_font . ':100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic';
		} else {
			/*
			Translators: If there are characters in your language that are not supported
			by chosen font(s), translate this to 'off'. Do not translate into your own language.
			 */
			if ( 'off' !== _x( 'on', 'Lato font: on or off', 'pawsitive' ) ) {
				$font_families[] = 'Lato' . ':100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic';
			}
		}

		if ( $heading_supertitle_font != '' ) {
			if ( $heading_supertitle_font == 'no_change' ) {
				$heading_supertitle_font = BoldThemes_Customize_Default::$data['heading_supertitle_font'];
			}
			$font_families[] = $heading_supertitle_font . ':100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic';
		} else {
			/*
			Translators: If there are characters in your language that are not supported
			by chosen font(s), translate this to 'off'. Do not translate into your own language.
			 */
			if ( 'off' !== _x( 'on', 'Lato font: on or off', 'pawsitive' ) ) {
				$font_families[] = 'Lato' . ':100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic';
			}
		}

		if ( $button_font != '' ) {
			if ( $button_font == 'no_change' ) {
				$button_font = BoldThemes_Customize_Default::$data['button_font'];
			}
			$font_families[] = $button_font . ':100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic';
		} else {
			/*
			Translators: If there are characters in your language that are not supported
			by chosen font(s), translate this to 'off'. Do not translate into your own language.
			 */
			if ( 'off' !== _x( 'on', 'Lato font: on or off', 'pawsitive' ) ) {
				$font_families[] = 'Lato' . ':100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic';
			}
		}

		if ( count( $font_families ) > 0 ) {
			$query_args = array(
				'family' => urlencode( implode( '|', $font_families ) ),
				'subset' => urlencode( 'latin,latin-ext' ),
			);
			$font_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
			wp_enqueue_style( 'pawsitive-fonts', $font_url, array(), '1.0.0' );
			add_editor_style( $font_url );
		}
	}
}

if ( ! function_exists( 'pawsitive_load_admin_style' ) ) {
	function pawsitive_load_admin_style() {
		if ( function_exists( 'boldthemes_csscrush_file' ) ) {
			boldthemes_csscrush_file( get_theme_file_path( 'admin-style.crush.css' ), array( 'source_map' => true, 'minify' => false, 'output_file' => 'admin-style', 'formatter' => 'block', 'boilerplate' => false, 'vars' => BoldThemesFramework::$crush_vars, 'plugins' => array( 'loop', 'ease' ) ) );
		}
		wp_enqueue_style( 'pawsitive-admin-style', get_parent_theme_file_uri( 'admin-style.css' ) );
		require_once( get_parent_theme_file_path( 'admin-style.php' ) );
		wp_add_inline_style( 'pawsitive-admin-style', $admin_style );
	}
}

/**
 * TinyMCE style
 */
if ( ! function_exists( 'pawsitive_theme_add_editor_styles' ) ) {
	function pawsitive_theme_add_editor_styles() {
	    add_editor_style( 'admin-style.css' );
	}
}

/** 
* Font 
*/

if ( ! function_exists( 'bt_bb_get_font_param_array' ) ) {
	function bt_bb_get_font_param_array() {
		require_once( dirname(__FILE__) . '/../../plugins/bold-page-builder/content_elements_misc/fonts.php' );
	}
}

/**
 * SVG Icon array
 */
if ( ! function_exists( 'bt_bb_get_svg_icons_param_array' ) ) {
	function bt_bb_get_svg_icons_param_array() {
	    return array(
			esc_html__( 'No icon', 'pawsitive' ) 					=> 'no_icon',
			esc_html__( 'Armchair (Pawsitive)', 'pawsitive' ) 	=> 'f1/armchair',
			esc_html__( 'Backpack (Pawsitive)', 'pawsitive' ) 	=> 'f1/backpack',
			esc_html__( 'Ball (Pawsitive)', 'pawsitive' ) 		=> 'f1/ball',						
			esc_html__( 'Bath (Pawsitive)', 'pawsitive' ) 		=> 'f1/bath',
			esc_html__( 'Bed (Pawsitive)', 'pawsitive' ) 			=> 'f1/bed',
			esc_html__( 'Bird house (Pawsitive)', 'pawsitive' ) 	=> 'f1/bird-house',
			esc_html__( 'Bone (Pawsitive)', 'pawsitive' ) 		=> 'f1/bone',
			esc_html__( 'Bowl (Pawsitive)', 'pawsitive' ) 		=> 'f1/bowl',
			esc_html__( 'Box (Pawsitive)', 'pawsitive' ) 			=> 'f1/box',
			esc_html__( 'Box-1 (Pawsitive)', 'pawsitive' ) 		=> 'f1/box-1',
			esc_html__( 'Brush (Pawsitive)', 'pawsitive' ) 		=> 'f1/brush',
			esc_html__( 'Bubbles (Pawsitive)', 'pawsitive' ) 		=> 'f1/bubbles',
			esc_html__( 'Bus (Pawsitive)', 'pawsitive' ) 			=> 'f1/bus',
			esc_html__( 'Candy (Pawsitive)', 'pawsitive' ) 		=> 'f1/candy',
			esc_html__( 'Canned food (Pawsitive)', 'pawsitive' ) 	=> 'f1/canned-food',
			esc_html__( 'Car (Pawsitive)', 'pawsitive' ) 			=> 'f1/car',
			esc_html__( 'Carrier (Pawsitive)', 'pawsitive' ) 		=> 'f1/carrier',
			esc_html__( 'Carrot (Pawsitive)', 'pawsitive' ) 		=> 'f1/carrot',
			esc_html__( 'Cat food (Pawsitive)', 'pawsitive' ) 	=> 'f1/cat-food',
			esc_html__( 'Cat (Pawsitive)', 'pawsitive' ) 			=> 'f1/cat',
			esc_html__( 'Clock (Pawsitive)', 'pawsitive' ) 		=> 'f1/clock',
			esc_html__( 'Collar (Pawsitive)', 'pawsitive' ) 		=> 'f1/collar',
			esc_html__( 'Comb (Pawsitive)', 'pawsitive' ) 		=> 'f1/comb',
			esc_html__( 'Cookie (Pawsitive)', 'pawsitive' ) 		=> 'f1/cookie',
			esc_html__( 'Cup (Pawsitive)', 'pawsitive' ) 			=> 'f1/cup',
			esc_html__( 'Discount (Pawsitive)', 'pawsitive' ) 	=> 'f1/discount',
			esc_html__( 'Dog (Pawsitive)', 'pawsitive' ) 			=> 'f1/dog',
			esc_html__( 'Dryer (Pawsitive)', 'pawsitive' ) 		=> 'f1/dryer',
			esc_html__( 'Dustpan (Pawsitive)', 'pawsitive' ) 		=> 'f1/dustpan',
			esc_html__( 'Fence (Pawsitive)', 'pawsitive' ) 		=> 'f1/fence',
			esc_html__( 'Fence 1 (Pawsitive)', 'pawsitive' ) 		=> 'f1/fence-1',
			esc_html__( 'First aid (Pawsitive)', 'pawsitive' ) 	=> 'f1/first-aid',
			esc_html__( 'Fish bowl (Pawsitive)', 'pawsitive' ) 	=> 'f1/fish-bowl',
			esc_html__( 'Flag (Pawsitive)', 'pawsitive' ) 		=> 'f1/flag',
			esc_html__( 'Flat TV (Pawsitive)', 'pawsitive' ) 		=> 'f1/flat-tv',
			esc_html__( 'Food (Pawsitive)', 'pawsitive' ) 		=> 'f1/food',
			esc_html__( 'Food-1 (Pawsitive)', 'pawsitive' ) 		=> 'f1/food-1',
			esc_html__( 'Hand (Pawsitive)', 'pawsitive' ) 		=> 'f1/hand',
			esc_html__( 'Heart (Pawsitive)', 'pawsitive' ) 		=> 'f1/heart',
			esc_html__( 'House (Pawsitive)', 'pawsitive' ) 		=> 'f1/house',
			esc_html__( 'Info (Pawsitive)', 'pawsitive' ) 		=> 'f1/info',
			esc_html__( 'Key (Pawsitive)', 'pawsitive' ) 			=> 'f1/key',
			esc_html__( 'Liquid soap (Pawsitive)', 'pawsitive' ) 	=> 'f1/liquid-soap',
			esc_html__( 'Litter box (Pawsitive)', 'pawsitive' ) 	=> 'f1/litter-box',
			esc_html__( 'Lock (Pawsitive)', 'pawsitive' ) 		=> 'f1/lock',
			esc_html__( 'Mail box (Pawsitive)', 'pawsitive' ) 	=> 'f1/mail-box',
			esc_html__( 'Mail (Pawsitive)', 'pawsitive' ) 		=> 'f1/mail',
			esc_html__( 'Medicine (Pawsitive)', 'pawsitive' ) 	=> 'f1/medicine',
			esc_html__( 'Notes (Pawsitive)', 'pawsitive' ) 		=> 'f1/notes',
			esc_html__( 'Paper plane (Pawsitive)', 'pawsitive' ) 	=> 'f1/paper-plane',
			esc_html__( 'Paw (Pawsitive)', 'pawsitive' ) 			=> 'f1/paw',
			esc_html__( 'Person (Pawsitive)', 'pawsitive' ) 		=> 'f1/person',
			esc_html__( 'Pet (Pawsitive)', 'pawsitive' ) 			=> 'f1/pet',
			esc_html__( 'Pet bed (Pawsitive)', 'pawsitive' ) 		=> 'f1/pet-bed',
			esc_html__( 'Pet boarding (Pawsitive)', 'pawsitive' ) => 'f1/pet-boarding',
			esc_html__( 'Pet can (Pawsitive)', 'pawsitive' ) 		=> 'f1/pet-can',
			esc_html__( 'Pet plate (Pawsitive)', 'pawsitive' ) 	=> 'f1/pet-plate',
			esc_html__( 'Pet shop (Pawsitive)', 'pawsitive' ) 	=> 'f1/pet-shop',
			esc_html__( 'Phone (Pawsitive)', 'pawsitive' ) 		=> 'f1/phone',
			esc_html__( 'Phone-1 (Pawsitive)', 'pawsitive' ) 		=> 'f1/phone-1',
			esc_html__( 'Photo (Pawsitive)', 'pawsitive' ) 		=> 'f1/photo',
			esc_html__( 'Pin (Pawsitive)', 'pawsitive' ) 			=> 'f1/pin',
			esc_html__( 'Present (Pawsitive)', 'pawsitive' ) 		=> 'f1/present',
			esc_html__( 'Shower (Pawsitive)', 'pawsitive' ) 		=> 'f1/shower',
			esc_html__( 'Spray (Pawsitive)', 'pawsitive' ) 		=> 'f1/spray',
			esc_html__( 'Star (Pawsitive)', 'pawsitive' ) 		=> 'f1/star',
			esc_html__( 'Stopper (Pawsitive)', 'pawsitive' ) 		=> 'f1/stopper',
			esc_html__( 'Suitcase (Pawsitive)', 'pawsitive' ) 	=> 'f1/suitcase',
			esc_html__( 'Surveilance (Pawsitive)', 'pawsitive' ) 	=> 'f1/surveilance',
			esc_html__( 'Temperature (Pawsitive)', 'pawsitive' ) 	=> 'f1/temperature',
			esc_html__( 'Tomato (Pawsitive)', 'pawsitive' ) 		=> 'f1/tomato',
			esc_html__( 'Tooth paste (Pawsitive)', 'pawsitive' ) 	=> 'f1/tooth-paste',
			esc_html__( 'Towel (Pawsitive)', 'pawsitive' ) 		=> 'f1/towel',
			esc_html__( 'Tv (Pawsitive)', 'pawsitive' ) 			=> 'f1/tv',
			esc_html__( 'Vaccine (Pawsitive)', 'pawsitive' ) 		=> 'f1/vaccine',
			esc_html__( 'Volume (Pawsitive)', 'pawsitive' ) 		=> 'f1/volume',
			esc_html__( 'Whistle (Pawsitive)', 'pawsitive' ) 		=> 'f1/whistle',
			esc_html__( 'Yarn (Pawsitive)', 'pawsitive' ) 		=> 'f1/yarn',

			esc_html__( 'Award (Pastel)', 'pawsitive' ) 			=> 'f2/award',
			esc_html__( 'Ball (Pastel)', 'pawsitive' ) 			=> 'f2/ball',
			esc_html__( 'Bird cage (Pastel)', 'pawsitive' ) 		=> 'f2/bird-cage',
			esc_html__( 'Bone (Pastel)', 'pawsitive' ) 			=> 'f2/bone',
			esc_html__( 'Bottle (Pastel)', 'pawsitive' ) 			=> 'f2/bottle',
			esc_html__( 'Brush (Pastel)', 'pawsitive' ) 			=> 'f2/brush',
			esc_html__( 'Carrier (Pastel)', 'pawsitive' ) 		=> 'f2/carrier',
			esc_html__( 'Carrier-1 (Pastel)', 'pawsitive' ) 		=> 'f2/carrier-1',
			esc_html__( 'Cat (Pastel)', 'pawsitive' ) 			=> 'f2/cat',
			esc_html__( 'Cat boarding (Pastel)', 'pawsitive' ) 	=> 'f2/cat-boarding',
			esc_html__( 'Cat collar (Pastel)', 'pawsitive' ) 		=> 'f2/cat-collar',
			esc_html__( 'Cat food (Pastel)', 'pawsitive' ) 		=> 'f2/cat-food',
			esc_html__( 'Cat toy (Pastel)', 'pawsitive' ) 		=> 'f2/cat-toy',
			esc_html__( 'Chameleon (Pastel)', 'pawsitive' ) 		=> 'f2/chameleon',
			esc_html__( 'Cloves (Pastel)', 'pawsitive' ) 			=> 'f2/cloves',
			esc_html__( 'Comb (Pastel)', 'pawsitive' ) 			=> 'f2/comb',
			esc_html__( 'Cup (Pastel)', 'pawsitive' ) 			=> 'f2/cup',
			esc_html__( 'Dog (Pastel)', 'pawsitive' ) 			=> 'f2/dog',
			esc_html__( 'Dog collar (Pastel)', 'pawsitive' ) 		=> 'f2/dog-collar',
			esc_html__( 'Dog plate (Pastel)', 'pawsitive' ) 		=> 'f2/dog-plate',
			esc_html__( 'Fish (Pastel)', 'pawsitive' ) 			=> 'f2/fish',
			esc_html__( 'Fish bowl (Pastel)', 'pawsitive' ) 		=> 'f2/fish-bowl',
			esc_html__( 'Hamster (Pastel)', 'pawsitive' ) 		=> 'f2/hamster',
			esc_html__( 'Hamster wheel (Pastel)', 'pawsitive' ) 	=> 'f2/hamster-wheel',
			esc_html__( 'Home (Pastel)', 'pawsitive' ) 			=> 'f2/home',
			esc_html__( 'Medicine (Pastel)', 'pawsitive' ) 		=> 'f2/medicine',
			esc_html__( 'Mouse (Pastel)', 'pawsitive' ) 			=> 'f2/mouse',
			esc_html__( 'Parrot (Pastel)', 'pawsitive' ) 			=> 'f2/parrot',
			esc_html__( 'Paw (Pastel)', 'pawsitive' ) 			=> 'f2/paw',
			esc_html__( 'Pet bed (Pastel)', 'pawsitive' ) 		=> 'f2/pet-bed',
			esc_html__( 'Pet boarding (Pastel)', 'pawsitive' ) 	=> 'f2/pet-boarding',
			esc_html__( 'Rabbit (Pastel)', 'pawsitive' ) 			=> 'f2/rabbit',
			esc_html__( 'Ribbon (Pastel)', 'pawsitive' ) 			=> 'f2/ribbon',
			esc_html__( 'Scissors (Pastel)', 'pawsitive' ) 		=> 'f2/scissors',
			esc_html__( 'Scratcher (Pastel)', 'pawsitive' ) 		=> 'f2/scratcher',
			esc_html__( 'Seeds (Pastel)', 'pawsitive' ) 			=> 'f2/seeds',
			esc_html__( 'Spider (Pastel)', 'pawsitive' ) 			=> 'f2/spider',
			esc_html__( 'Spray (Pastel)', 'pawsitive' ) 			=> 'f2/spray',
			esc_html__( 'Suplements (Pastel)', 'pawsitive' ) 		=> 'f2/suplements',
			esc_html__( 'Turtle (Pastel)', 'pawsitive' ) 			=> 'f2/turtle',
			esc_html__( 'Vaccine (Pastel)', 'pawsitive' ) 		=> 'f2/vaccine',
			esc_html__( 'Vitamins (Pastel)', 'pawsitive' ) 		=> 'f2/vitamins'
		);
	}
}

/* Get icon HTML */

if ( ! function_exists( 'bt_bb_get_svg_icon_html' ) ) {
	function bt_bb_get_svg_icon_html( $icon ) {				
		ob_start();
		require( dirname(__FILE__) . '/bold-page-builder/content_elements_misc/svg/' . $icon . '.svg' );
		return ob_get_clean();							
	}	
}



/**
 * Add FontAwesome to TinyMCE editor
 */
if ( ! function_exists( 'pawsitive_editor_dynamic_styles' ) ) {
	function pawsitive_editor_dynamic_styles( $mceInit ) {
	    $styles = '@font-face{font-family:\"FontAwesome\";src:url(\"' . get_parent_theme_file_uri( 'fonts/FontAwesome/FontAwesome.woff' ) . '\") format(\"woff\"),url(\"' . get_parent_theme_file_uri( 'fonts/FontAwesome/FontAwesome.ttf' ) . '\") format(\"truetype\");}';
	    if ( isset( $mceInit['content_style'] ) ) {
	        $mceInit['content_style'] .= ' ' . ( $styles ) . ' ';
	    } else {
	        $mceInit['content_style'] = $styles . ' ';
	    }
	    return $mceInit;
	}
}

/**
 * Add class to body
 *
 * @return string 
 */
if ( ! function_exists( 'pawsitive_body_class' ) ) {
	function pawsitive_body_class( $extra_class ) {
		if ( boldthemes_get_option( 'default_heading_weight' ) ) {
			$extra_class[] =  'btHeadingWeight_' . boldthemes_get_option( 'default_heading_weight' );
		}
		if ( boldthemes_get_option( 'default_menu_weight' ) ) {
			$extra_class[] =  'btMenuWeight_' . boldthemes_get_option( 'default_menu_weight' );
		}
		if ( boldthemes_get_option( 'capitalize_main_menu' ) ) {
			$extra_class[] = 'btCapitalizeMainMenuItems';
		}
		if ( boldthemes_get_option( 'highlight_current_page' ) ) {
			$extra_class[] =  'btCurrentPage_' . boldthemes_get_option( 'highlight_current_page' );
		}
		if ( boldthemes_get_option( 'default_button_weight' ) ) {
			$extra_class[] =  'btButtonWeight_' . boldthemes_get_option( 'default_button_weight' );
		}

		return $extra_class;
	}
}

/**
 * Shop sidebar
 */
if ( ! function_exists( 'pawsitive_widget_area' ) ) {
	function pawsitive_widget_area() {
		if ( class_exists( 'woocommerce' ) ) {
			register_sidebar( array (
				'name' 			=> esc_html__( 'Shop Sidebar', 'pawsitive' ),
				'id' 			=> 'bt_shop_sidebar',
				'description'   => 'WooCommerce sidebar',
				'before_widget' => '<div class="btBox %2$s">',
				'after_widget' 	=> '</div>',
				'before_title' 	=> '<h4><span>',
				'after_title' 	=> '</span></h4>',
			));
		}
	}
}

require_once( get_parent_theme_file_path( 'php/before_framework.php' ) );

require_once( get_parent_theme_file_path( 'framework/framework.php' ) );

require_once( get_parent_theme_file_path( 'php/config.php' ) );

require_once( get_parent_theme_file_path( 'php/after_framework.php' ) );