<?php
if ( class_exists( 'BoldThemesFramework' ) && isset( BoldThemesFramework::$crush_vars ) ) {
	$boldthemes_crush_vars = apply_filters( 'boldthemes_crush_vars', BoldThemesFramework::$crush_vars );
}
if ( class_exists( 'BoldThemesFramework' ) && isset( BoldThemesFramework::$crush_vars_def ) ) {
	$boldthemes_crush_vars_def = BoldThemesFramework::$crush_vars_def;
}
if ( isset( $boldthemes_crush_vars['accentColor'] ) ) {
	$accentColor = $boldthemes_crush_vars['accentColor'];
} else {
	$accentColor = "#ed6436";
}
if ( isset( $boldthemes_crush_vars['alternateColor'] ) ) {
	$alternateColor = $boldthemes_crush_vars['alternateColor'];
} else {
	$alternateColor = "#82c55b";
}
if ( isset( $boldthemes_crush_vars['thirdColor'] ) ) {
	$thirdColor = $boldthemes_crush_vars['thirdColor'];
} else {
	$thirdColor = "#ffbaa0";
}
if ( isset( $boldthemes_crush_vars['fourthColor'] ) ) {
	$fourthColor = $boldthemes_crush_vars['fourthColor'];
} else {
	$fourthColor = "#a6eff8";
}
if ( isset( $boldthemes_crush_vars['bodyFont'] ) ) {
	$bodyFont = $boldthemes_crush_vars['bodyFont'];
} else {
	$bodyFont = "Nunito Sans";
}
if ( isset( $boldthemes_crush_vars['menuFont'] ) ) {
	$menuFont = $boldthemes_crush_vars['menuFont'];
} else {
	$menuFont = "Nunito Sans";
}
if ( isset( $boldthemes_crush_vars['headingFont'] ) ) {
	$headingFont = $boldthemes_crush_vars['headingFont'];
} else {
	$headingFont = "Nunito";
}
if ( isset( $boldthemes_crush_vars['headingSuperTitleFont'] ) ) {
	$headingSuperTitleFont = $boldthemes_crush_vars['headingSuperTitleFont'];
} else {
	$headingSuperTitleFont = "Nunito Sans";
}
if ( isset( $boldthemes_crush_vars['headingSubTitleFont'] ) ) {
	$headingSubTitleFont = $boldthemes_crush_vars['headingSubTitleFont'];
} else {
	$headingSubTitleFont = "Nunito Sans";
}
if ( isset( $boldthemes_crush_vars['buttonFont'] ) ) {
	$buttonFont = $boldthemes_crush_vars['buttonFont'];
} else {
	$buttonFont = "Nunito Sans";
}
if ( isset( $boldthemes_crush_vars['logoHeight'] ) ) {
	$logoHeight = $boldthemes_crush_vars['logoHeight'];
} else {
	$logoHeight = "70";
}
$accentColorDark = CssCrush\fn__l_adjust( $accentColor." -15" );$accentColorVeryDark = CssCrush\fn__l_adjust( $accentColor." -35" );$accentColorVeryVeryDark = CssCrush\fn__l_adjust( $accentColor." -42" );$accentColorLight = CssCrush\fn__a_adjust( $accentColor." -30" );$accentColorTransparent = CssCrush\fn__a_adjust( $accentColor." -90" );$accentColorLightTransparent = CssCrush\fn__a_adjust( $accentColor." -80" );$alternateColorDark = CssCrush\fn__l_adjust( $alternateColor." -15" );$alternateColorVeryDark = CssCrush\fn__l_adjust( $alternateColor." -25" );$alternateColorLight = CssCrush\fn__a_adjust( $alternateColor." -40" );$css_override = sanitize_text_field("select,
input{font-family: \"{$bodyFont}\",Arial,Helvetica,sans-serif;}
input[type='submit']{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;
    -webkit-box-shadow: 0 0 0 3em {$accentColor} inset;
    box-shadow: 0 0 0 3em {$accentColor} inset;}
input[type='submit']:hover{-webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;
    color: {$accentColor};}
.fancy-select ul.options li:hover{color: {$accentColor};}
input:not([type='checkbox']):not([type='radio']):not([type='submit']):focus,
textarea:focus,
.fancy-select .trigger.open{border: 1px solid {$accentColor};}
.btContent a{color: {$accentColor};}
a:hover{
    color: {$accentColor};}
.btText a{color: {$accentColor};}
body{font-family: \"{$bodyFont}\",Arial,Helvetica,sans-serif;}
h1,
h2,
h3,
h4,
h5,
h6{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
blockquote{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
blockquote:before{
    color: {$accentColor};}
.btContentHolder table thead th{
    background-color: {$accentColor};}
.btAccentDarkHeader .btPreloader .animation > div:first-child,
.btLightAccentHeader .btPreloader .animation > div:first-child,
.btTransparentLightHeader .btPreloader .animation > div:first-child{
    background-color: {$accentColor};}
.btPreloader .animation .preloaderLogo{height: {$logoHeight}px;}
.btLoader:before{
    background-color: {$accentColor};
    -webkit-box-shadow: 30px 0 0 {$thirdColor};
    box-shadow: 30px 0 0 {$thirdColor};}
.btLoader:after{
    background-color: {$alternateColor};
    -webkit-box-shadow: 30px 0 0 {$fourthColor};
    box-shadow: 30px 0 0 {$fourthColor};}
@-webkit-keyframes ball1{0%{-webkit-box-shadow: 30px 0 0 {$thirdColor};
    box-shadow: 30px 0 0 {$thirdColor};}
50%{-webkit-box-shadow: 0 0 0 {$thirdColor};
    box-shadow: 0 0 0 {$thirdColor};}
100%{-webkit-box-shadow: 30px 0 0 {$thirdColor};
    box-shadow: 30px 0 0 {$thirdColor};}
}@-moz-keyframes ball1{0%{box-shadow: 30px 0 0 {$thirdColor};}
50%{box-shadow: 0 0 0 {$thirdColor};}
100%{box-shadow: 30px 0 0 {$thirdColor};}
}@keyframes ball1{0%{-webkit-box-shadow: 30px 0 0 {$thirdColor};
    box-shadow: 30px 0 0 {$thirdColor};}
50%{-webkit-box-shadow: 0 0 0 {$thirdColor};
    box-shadow: 0 0 0 {$thirdColor};}
100%{-webkit-box-shadow: 30px 0 0 {$thirdColor};
    box-shadow: 30px 0 0 {$thirdColor};}
}@-webkit-keyframes ball2{0%{-webkit-box-shadow: 30px 0 0 {$fourthColor};
    box-shadow: 30px 0 0 {$fourthColor};}
50%{-webkit-box-shadow: 0 0 0 {$fourthColor};
    box-shadow: 0 0 0 {$fourthColor};}
100%{-webkit-box-shadow: 30px 0 0 {$fourthColor};
    box-shadow: 30px 0 0 {$fourthColor};}
}@-moz-keyframes ball2{0%{box-shadow: 30px 0 0 {$fourthColor};}
50%{box-shadow: 0 0 0 {$fourthColor};}
100%{box-shadow: 30px 0 0 {$fourthColor};}
}@keyframes ball2{0%{-webkit-box-shadow: 30px 0 0 {$fourthColor};
    box-shadow: 30px 0 0 {$fourthColor};}
50%{-webkit-box-shadow: 0 0 0 {$fourthColor};
    box-shadow: 0 0 0 {$fourthColor};}
100%{-webkit-box-shadow: 30px 0 0 {$fourthColor};
    box-shadow: 30px 0 0 {$fourthColor};}
}body.error404 .btErrorPage .port .bt_bb_button.bt_bb_style_outline a{
    -webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;}
body.error404 .btErrorPage .port .bt_bb_button.bt_bb_style_outline a:hover{-webkit-box-shadow: 0 0 0 3em {$accentColor} inset;
    box-shadow: 0 0 0 3em {$accentColor} inset;}
.btNoSearchResults .bt_bb_port #searchform input[type='submit']{
    -webkit-box-shadow: 0 0 0 3em {$accentColor} inset;
    box-shadow: 0 0 0 3em {$accentColor} inset;}
.btNoSearchResults .bt_bb_port #searchform input[type='submit']:hover{
    -webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;
    color: {$accentColor};}
.btNoSearchResults .bt_bb_port .bt_bb_button.bt_bb_style_filled a{
    -webkit-box-shadow: 0 0 0 3em {$accentColor} inset;
    box-shadow: 0 0 0 3em {$accentColor} inset;}
.btNoSearchResults .bt_bb_port .bt_bb_button.bt_bb_style_filled a:hover{-webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;
    color: {$accentColor};}
.mainHeader{
    font-family: \"{$menuFont}\",Arial,Helvetica,sans-serif;}
.mainHeader a:hover{color: {$accentColor};}
.btLightAccentHeader .mainHeader a:hover{color: {$alternateColor};}
.menuPort{font-family: \"{$menuFont}\",Arial,Helvetica,sans-serif;}
.menuPort nav ul li a:hover{color: {$accentColor};}
.btLightAccentHeader .menuPort nav ul li a:hover{color: {$alternateColor};}
.menuPort nav > ul > li > a{line-height: {$logoHeight}px;}
.btTextLogo{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;
    line-height: {$logoHeight}px;}
.btLogoArea .logo img{height: {$logoHeight}px;}
.btTransparentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btTransparentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btAccentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btAccentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btLightDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btHasAltLogo.btStickyHeaderActive .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btTransparentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:after,
.btTransparentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:after,
.btAccentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:after,
.btAccentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:after,
.btLightDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:after,
.btHasAltLogo.btStickyHeaderActive .btHorizontalMenuTrigger:hover .bt_bb_icon:after{border-top-color: {$accentColor};}
.btTransparentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btTransparentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btAccentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btAccentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btLightDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btHasAltLogo.btStickyHeaderActive .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before{border-top-color: {$accentColor};}
.btMenuHorizontal .menuPort nav > ul > li > a:after{
    background-color: {$accentColor};}
.btMenuHorizontal .menuPort nav > ul > li li.current-menu-ancestor > a,
.btMenuHorizontal .menuPort nav > ul > li li.current-menu-item > a{color: {$accentColor};}
.btMenuHorizontal .menuPort nav > ul > li.current-menu-ancestor li.current-menu-ancestor > a,
.btMenuHorizontal .menuPort nav > ul > li.current-menu-ancestor li.current-menu-item > a,
.btMenuHorizontal .menuPort nav > ul > li.current-menu-item li.current-menu-ancestor > a,
.btMenuHorizontal .menuPort nav > ul > li.current-menu-item li.current-menu-item > a,
.btMenuHorizontal .menuPort nav > ul > li.on li.current-menu-ancestor > a,
.btMenuHorizontal .menuPort nav > ul > li.on li.current-menu-item > a{color: {$accentColor};}
.btMenuHorizontal .menuPort nav > ul > li:not(.btMenuWideDropdown) > ul > li.menu-item-has-children > a:before{
    background-color: {$accentColor};}
.btMenuHorizontal .menuPort ul ul li a:hover{color: {$accentColor};}
body.btMenuHorizontal .subToggler{
    line-height: {$logoHeight}px;}
html:not(.touch) body.btMenuHorizontal .menuPort > nav > ul > li.btMenuWideDropdown > ul > li > a:after{
    background-color: {$accentColor};}
.btMenuHorizontal .topBar .topBarPort .topTools .btIconWidget.btAccentIconWidget.btWidgetWithText .btIconWidgetTitle{color: {$accentColor};}
.btMenuHorizontal .topBarInMenu{
    height: {$logoHeight}px;}
.btAccentLightHeader .btBelowLogoArea,
.btAccentLightHeader .topBar{background-color: {$accentColor};}
.btAccentLightHeader .btBelowLogoArea a:hover,
.btAccentLightHeader .topBar a:hover{color: {$alternateColor};}
.btAccentDarkHeader .btBelowLogoArea,
.btAccentDarkHeader .topBar{background-color: {$accentColor};}
.btAccentDarkHeader .btBelowLogoArea a:hover,
.btAccentDarkHeader .topBar a:hover{color: {$alternateColor};}
.btLightAccentHeader .btLogoArea,
.btLightAccentHeader .btVerticalHeaderTop{background-color: {$accentColor};}
.btLightAccentHeader .btBelowLogoArea a:hover,
.btLightAccentHeader .topBar a:hover{color: {$accentColor};}
.btLightAccentHeader.btMenuHorizontal.btBelowMenu .mainHeader .btLogoArea{background-color: {$accentColor};}
.btStickyHeaderActive.btMenuHorizontal .mainHeader .btLogoArea .logo img{height: -webkit-calc({$logoHeight}px*0.8);
    height: -moz-calc({$logoHeight}px*0.8);
    height: calc({$logoHeight}px*0.8);}
.btStickyHeaderActive.btMenuHorizontal .mainHeader .btLogoArea .btTextLogo{
    line-height: -webkit-calc({$logoHeight}px*0.8);
    line-height: -moz-calc({$logoHeight}px*0.8);
    line-height: calc({$logoHeight}px*0.8);}
.btStickyHeaderActive.btMenuHorizontal .mainHeader .btLogoArea .menuPort nav > ul > li > a,
.btStickyHeaderActive.btMenuHorizontal .mainHeader .btLogoArea .menuPort nav > ul > li > .subToggler{line-height: -webkit-calc({$logoHeight}px*0.8);
    line-height: -moz-calc({$logoHeight}px*0.8);
    line-height: calc({$logoHeight}px*0.8);}
.btStickyHeaderActive.btMenuHorizontal .mainHeader .btLogoArea .topBarInMenu{height: -webkit-calc({$logoHeight}px*0.8);
    height: -moz-calc({$logoHeight}px*0.8);
    height: calc({$logoHeight}px*0.8);}
.btTransparentDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btTransparentLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btAccentLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btAccentDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btLightDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btHasAltLogo.btStickyHeaderActive .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btTransparentDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:after,
.btTransparentLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon:after,
.btAccentLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon:after,
.btAccentDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:after,
.btLightDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:after,
.btHasAltLogo.btStickyHeaderActive .btVerticalMenuTrigger:hover .bt_bb_icon:after{border-top-color: {$accentColor};}
.btTransparentDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btTransparentLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btAccentLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btAccentDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btLightDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btHasAltLogo.btStickyHeaderActive .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before{border-top-color: {$accentColor};}
.btMenuVertical .mainHeader .btCloseVertical:before:hover{color: {$accentColor};}
.btMenuHorizontal .topBarInLogoArea{
    height: {$logoHeight}px;}
.btMenuHorizontal .topBarInLogoArea .topBarInLogoAreaCell{border: 0 solid {$accentColor};}
.btMenuVertical .mainHeader .btCloseVertical:before:hover{color: {$accentColor};}
.btDarkSkin .btSiteFooterCopyMenu .port:before,
.btLightSkin .btDarkSkin .btSiteFooterCopyMenu .port:before,
.btDarkSkin.btLightSkin .btDarkSkin .btSiteFooterCopyMenu .port:before{background-color: {$accentColor};}
.btContent .btArticleHeadline .bt_bb_headline a:hover{color: {$accentColor};}
.btPostSingleItemStandard .btArticleShareEtc > div.btReadMoreColumn .bt_bb_button a{
    -webkit-box-shadow: 0 0 0 3em {$accentColor} inset;
    box-shadow: 0 0 0 3em {$accentColor} inset;}
.btPostSingleItemStandard .btArticleShareEtc > div.btReadMoreColumn .bt_bb_button:hover a{-webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;}
.btMediaBox.btQuote:before,
.btMediaBox.btLink:before{
    background-color: {$accentColor};}
.sticky.btArticleListItem .btArticleHeadline h1 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h2 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h3 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h4 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h5 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h6 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h7 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h8 .bt_bb_headline_content span a:after{
    color: {$accentColor};}
.post-password-form p:first-child{color: {$alternateColor};}
.post-password-form p:nth-child(2) input[type=\"submit\"]{
    background: {$accentColor};}
.btPagination{font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.btPagination .paging a:hover{color: {$accentColor};}
.btPagination .paging a:hover:after{border-color: {$accentColor};
    color: {$accentColor};}
.btPrevNextNav .btPrevNext .btPrevNextItem .btPrevNextTitle{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.btPrevNextNav .btPrevNext .btPrevNextItem .btPrevNextDir{
    color: {$accentColor};}
.btPrevNextNav .btPrevNext:hover .btPrevNextTitle{color: {$accentColor};}
.btArticleCategories a:hover{color: {$accentColor};}
.btArticleCategories a:not(:first-child):before{
    background-color: {$accentColor};}
.btArticleAuthor a:hover{color: {$accentColor};}
.btArticleComments:hover{color: {$accentColor};}
.bt-comments-box .vcard .posted{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.bt-comments-box .commentTxt p.edit-link,
.bt-comments-box .commentTxt p.reply{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.bt-comments-box .comment-navigation a,
.bt-comments-box .comment-navigation span{
    font-family: \"{$headingSubTitleFont}\",Arial,Helvetica,sans-serif;}
.comment-awaiting-moderation{color: {$accentColor};}
a#cancel-comment-reply-link{
    color: {$accentColor};}
a#cancel-comment-reply-link:hover{color: {$alternateColor};}
.btCommentSubmit{
    color: {$accentColor};
    -webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;}
.btCommentSubmit:hover{
    -webkit-box-shadow: 0 0 0 3em {$accentColor} inset;
    box-shadow: 0 0 0 3em {$accentColor} inset;}
.sidebar .widget_bt_bb_recent_posts ul li a:hover,
.btSidebar .widget_bt_bb_recent_posts ul li a:hover,
.btSiteFooterWidgets .widget_bt_bb_recent_posts ul li a:hover{color: {$accentColor};}
.sidebar .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h1,
.sidebar .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h2,
.sidebar .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h3,
.sidebar .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h4,
.sidebar .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h5,
.sidebar .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h6,
.btSidebar .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h1,
.btSidebar .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h2,
.btSidebar .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h3,
.btSidebar .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h4,
.btSidebar .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h5,
.btSidebar .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h6,
.btSiteFooterWidgets .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h1,
.btSiteFooterWidgets .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h2,
.btSiteFooterWidgets .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h3,
.btSiteFooterWidgets .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h4,
.btSiteFooterWidgets .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h5,
.btSiteFooterWidgets .widget_bt_bb_recent_posts ul li .btImageTextWidget .btImageTextWidgetText .bt_bb_headline h6{font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
body:not(.btNoDashInSidebar) .btBox > h4:after,
body:not(.btNoDashInSidebar) .btCustomMenu > h4:after,
body:not(.btNoDashInSidebar) .btTopBox > h4:after{
    border-bottom: 3px solid {$accentColor};}
.btBox ul li.current-menu-item > a,
.btCustomMenu ul li.current-menu-item > a,
.btTopBox ul li.current-menu-item > a{color: {$accentColor};}
.widget_calendar table caption{background: {$accentColor};
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.widget_calendar table tbody tr td#today{color: {$accentColor};}
.widget_rss li a.rsswidget{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.widget_shopping_cart .total{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.widget_shopping_cart .total .amount{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.widget_shopping_cart .total strong{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.widget_shopping_cart .buttons .button{
    background: {$accentColor};}
.widget_shopping_cart .widget_shopping_cart_content .mini_cart_item .ppRemove a.remove{
    background-color: {$accentColor};}
.widget_shopping_cart .widget_shopping_cart_content .mini_cart_item .ppRemove a.remove:hover{background-color: {$alternateColor};}
.menuPort .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before,
.topTools .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before,
.topBarInLogoArea .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before{color: {$accentColor};}
.btAccentLightHeader .menuPort .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before,
.btAccentLightHeader .topTools .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before,
.btAccentLightHeader .topBarInLogoArea .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before{color: {$alternateColor};}
.menuPort .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon span.cart-contents,
.topTools .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon span.cart-contents,
.topBarInLogoArea .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon span.cart-contents{
    background-color: {$alternateColor};
    font: normal .9em/1.5 \"{$menuFont}\";}
.btMenuVertical .menuPort .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetInnerContent .verticalMenuCartToggler,
.btMenuVertical .topTools .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetInnerContent .verticalMenuCartToggler,
.btMenuVertical .topBarInLogoArea .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetInnerContent .verticalMenuCartToggler{
    background-color: {$accentColor};}
.widget_recent_reviews{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.widget_price_filter .price_slider_wrapper .ui-slider .ui-slider-handle{
    background-color: {$accentColor};}
.btBox .tagcloud a,
.btTags ul a{
    -webkit-box-shadow: 0 0 0 3em {$accentColor} inset;
    box-shadow: 0 0 0 3em {$accentColor} inset;}
.topTools a.btIconWidget:hover,
.topBarInMenu a.btIconWidget:hover{color: {$accentColor};}
.btLightAccentHeader .topTools a.btIconWidget:hover,
.btLightAccentHeader .topBarInMenu a.btIconWidget:hover{color: {$alternateColor};}
.btAccentLightHeader .topTools a.btIconWidget:hover,
.btAccentLightHeader .topBarInMenu a.btIconWidget:hover{color: {$alternateColor};}
.btAccentIconWidget.btIconWidget .btIconWidgetIcon{color: {$accentColor};}
.btLightAccentHeader .btAccentIconWidget.btIconWidget .btIconWidgetIcon{color: {$alternateColor};}
.btAccentLightHeader .btAccentIconWidget.btIconWidget .btIconWidgetIcon{color: {$alternateColor};}
a.btAccentIconWidget.btIconWidget:hover{color: {$accentColor};}
.btLightAccentHeader a.btAccentIconWidget.btIconWidget:hover{color: {$alternateColor};}
.btAccentLightHeader a.btAccentIconWidget.btIconWidget:hover{color: {$alternateColor};}
.btLightSkin .btSiteFooterWidgets .btSearch button:hover,
.btDarkSkin .btLightSkin .btSiteFooterWidgets .btSearch button:hover,
.btLightSkin .btDarkSkin .btLightSkin .btSiteFooterWidgets .btSearch button:hover,
.btDarkSkin .btSiteFooterWidgets .btSearch button:hover,
.btLightSkin .btDarkSkin .btSiteFooterWidgets .btSearch button:hover,
.btDarkSkin.btLightSkin .btDarkSkin .btSiteFooterWidgets .btSearch button:hover,
.btLightSkin .btSidebar .btSearch button:hover,
.btDarkSkin .btLightSkin .btSidebar .btSearch button:hover,
.btLightSkin .btDarkSkin .btLightSkin .btSidebar .btSearch button:hover,
.btDarkSkin .btSidebar .btSearch button:hover,
.btLightSkin .btDarkSkin .btSidebar .btSearch button:hover,
.btDarkSkin.btLightSkin .btDarkSkin .btSidebar .btSearch button:hover,
.btLightSkin .btSidebar .widget_product_search button:hover,
.btDarkSkin .btLightSkin .btSidebar .widget_product_search button:hover,
.btLightSkin .btDarkSkin .btLightSkin .btSidebar .widget_product_search button:hover,
.btDarkSkin .btSidebar .widget_product_search button:hover,
.btLightSkin .btDarkSkin .btSidebar .widget_product_search button:hover,
.btDarkSkin.btLightSkin .btDarkSkin .btSidebar .widget_product_search button:hover{background: {$accentColor} !important;
    border-color: {$accentColor} !important;}
.btSearchInner.btFromTopBox .btSearchInnerClose .bt_bb_icon a.bt_bb_icon_holder{color: {$accentColor};}
.btSearchInner.btFromTopBox .btSearchInnerClose .bt_bb_icon:hover a.bt_bb_icon_holder{color: {$accentColorDark};}
.btSearchInner.btFromTopBox button:hover:before{color: {$accentColor};}
div.btButtonWidget a.btButtonWidgetLink .btIconWidgetText{font-family: \"{$buttonFont}\",Arial,Helvetica,sans-serif;}
div.btButtonWidget a{-webkit-box-shadow: 0 0 0 3em {$accentColor} inset;
    box-shadow: 0 0 0 3em {$accentColor} inset;}
div.btButtonWidget a .btIconWidgetIcon{
    background: {$accentColor};}
div.btButtonWidget a:hover{-webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;}
div.btButtonWidget a:hover .btIconWidgetIcon{
    border-color: {$accentColor};}
.btTransparentLightHeader:not(.btStickyHeaderActive):not(.btStickyHeaderOpen) div.btButtonWidget a:hover .btIconWidgetIcon{
    border-color: {$accentColor};}
div.btButtonWidget.btOutline a{-webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;}
div.btButtonWidget.btOutline a .btIconWidgetIcon{background: {$accentColor};}
div.btButtonWidget.btOutline a:hover{-webkit-box-shadow: 0 0 0 3em {$accentColor} inset;
    box-shadow: 0 0 0 3em {$accentColor} inset;}
.bt_bb_headline .bt_bb_headline_superheadline{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_headline.bt_bb_subheadline .bt_bb_headline_subheadline{font-family: \"{$headingSubTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_headline h1 strong,
.bt_bb_headline h2 strong,
.bt_bb_headline h3 strong,
.bt_bb_headline h4 strong,
.bt_bb_headline h5 strong,
.bt_bb_headline h6 strong{color: {$accentColor};}
.bt_bb_headline h1 em,
.bt_bb_headline h2 em,
.bt_bb_headline h3 em,
.bt_bb_headline h4 em,
.bt_bb_headline h5 em,
.bt_bb_headline h6 em{color: {$alternateColor};}
.bt_bb_button .bt_bb_button_text{
    font-family: \"{$buttonFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_button.bt_bb_style_underline a:hover{border-color: {$accentColor};
    color: {$accentColor};}
.bt_bb_service .bt_bb_service_colored_icon svg .cls-1{fill: {$accentColor};}
.bt_bb_service .bt_bb_service_colored_icon svg line.cls-1,
.bt_bb_service .bt_bb_service_colored_icon svg rect.cls-1{
    stroke: {$accentColor};}
.bt_bb_service .bt_bb_service_content .bt_bb_service_content_title{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_title_size_huge.bt_bb_service .bt_bb_service_content .bt_bb_service_content_title{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_service:hover .bt_bb_service_content_title a{color: {$accentColor};}
.bt_bb_icon .bt_bb_icon_holder_inner svg .cls-1{fill: {$accentColor};}
.bt_bb_icon .bt_bb_icon_holder_inner svg line.cls-1,
.bt_bb_icon .bt_bb_icon_holder_inner svg rect.cls-1{
    stroke: {$accentColor};}
.bt_bb_price_list .bt_bb_price_list_content .bt_bb_price_list_supertitle{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_price_list .bt_bb_price_list_content .bt_bb_price_list_title{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_price_list .bt_bb_price_list_content .bt_bb_price_list_colored_icon svg .cls-1{fill: {$accentColor};}
.bt_bb_price_list .bt_bb_price_list_price{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_inner .bt_bb_latest_posts_item_media .bt_bb_latest_posts_item_date{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;
    background: {$alternateColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_inner .bt_bb_latest_posts_item_media .bt_bb_latest_posts_item_date span,
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_inner .bt_bb_latest_posts_item_media .bt_bb_latest_posts_item_date div{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_inner .bt_bb_latest_posts_item_content .bt_bb_latest_posts_item_meta .bt_bb_latest_posts_item_category ul.post-categories:before{
    color: {$accentColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_inner .bt_bb_latest_posts_item_content .bt_bb_latest_posts_item_meta .bt_bb_latest_posts_item_author:before{
    color: {$accentColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_inner .bt_bb_latest_posts_item_content .bt_bb_latest_posts_item_meta .bt_bb_latest_posts_item_comments:before{
    color: {$accentColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_inner .bt_bb_latest_posts_item_content .bt_bb_latest_posts_item_meta a:hover{color: {$accentColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_inner .bt_bb_latest_posts_item_content .bt_bb_latest_posts_item_title{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_inner .bt_bb_latest_posts_item_content .bt_bb_latest_posts_item_title a:hover{color: {$accentColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item:nth-child(2) .bt_bb_latest_posts_item_inner .bt_bb_latest_posts_item_media .bt_bb_latest_posts_item_date{background: {$thirdColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item:nth-child(3) .bt_bb_latest_posts_item_inner .bt_bb_latest_posts_item_media .bt_bb_latest_posts_item_date{background: {$fourthColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item:nth-child(4) .bt_bb_latest_posts_item_inner .bt_bb_latest_posts_item_media .bt_bb_latest_posts_item_date{background: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_post_grid_filter .bt_bb_post_grid_filter_item.active,
.bt_bb_masonry_post_grid .bt_bb_post_grid_filter .bt_bb_post_grid_filter_item:hover{
    color: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item .bt_bb_grid_item_inner .bt_bb_grid_item_date_box:before{
    color: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item .bt_bb_grid_item_inner .bt_bb_grid_item_date_box span{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;
    color: {$alternateColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item .bt_bb_grid_item_inner .bt_bb_grid_item_post_content .bt_bb_grid_item_meta a:hover{color: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item .bt_bb_grid_item_inner .bt_bb_grid_item_post_content .bt_bb_grid_item_meta .bt_bb_grid_item_category ul.post-categories li a:hover{color: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item .bt_bb_grid_item_inner .bt_bb_grid_item_post_content .bt_bb_grid_item_post_title a:hover{color: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_post_grid_loader{
    border-top: .4em solid {$accentColor};}
.bt_bb_style_line.bt_bb_progress_bar .bt_bb_progress_bar_content:after{
    -webkit-box-shadow: 0 0 0 5px {$accentColor} inset;
    box-shadow: 0 0 0 5px {$accentColor} inset;}
.slick-dots li{
    background: {$accentColor};}
.bt_bb_countdown.btCounterHolder{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_countdown.btCounterHolder span[class$=\"_text\"]{color: {$accentColor};
    font-family: \"{$headingSubTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_accordion .bt_bb_accordion_item .bt_bb_accordion_item_title_content .bt_bb_icon .bt_bb_icon_holder:before{
    -webkit-box-shadow: 0 0 0 3em {$alternateColor} inset;
    box-shadow: 0 0 0 3em {$alternateColor} inset;}
.bt_bb_icon_style_outline.bt_bb_accordion .bt_bb_accordion_item .bt_bb_accordion_item_title_content .bt_bb_icon .bt_bb_icon_holder:before{-webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;}
.bt_bb_icon_style_borderless.bt_bb_accordion .bt_bb_accordion_item .bt_bb_accordion_item_title_content .bt_bb_icon .bt_bb_icon_holder:before{-webkit-box-shadow: 0 0 0 0 {$accentColor} inset !important;
    box-shadow: 0 0 0 0 {$accentColor} inset !important;}
.bt_bb_accordion .bt_bb_accordion_item .bt_bb_accordion_item_title_content .bt_bb_accordion_item_title{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_organic_animation_fill.bt_bb_organic_animation .item .item__deco{fill: {$alternateColor};}
.bt_bb_organic_animation_fill_accent.bt_bb_organic_animation .item .item__deco{fill: {$accentColor};}
.bt_bb_organic_animation_stroke.bt_bb_organic_animation .item .item__deco{stroke: {$alternateColor};}
.bt_bb_organic_animation_stroke_accent.bt_bb_organic_animation .item .item__deco{stroke: {$accentColor};}
.bt_bb_organic_animation .item .item__meta .item__subtitle{
    font-family: \"{$headingSubTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_organic_animation .item .item__meta .item__button_text{
    font-family: \"{$buttonFont}\",Arial,Helvetica,sans-serif;}
@media (max-width: 480px){.bt_bb_style_filled.bt_bb_organic_animation .item .item__meta .item__button_text a{-webkit-box-shadow: 0 0 0 0 {$accentColor} inset !important;
    box-shadow: 0 0 0 0 {$accentColor} inset !important;}
}.bt_bb_card .bt_bb_card_content .bt_bb_card_colored_icon svg .cls-1{fill: {$accentColor};}
.bt_bb_card .bt_bb_card_content .bt_bb_card_title{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_card .bt_bb_card_content .bt_bb_card_title strong{color: {$accentColor};}
.bt_bb_progress_bar_advanced .bt_bb_progress_bar_advanced_content span{font-family: \"{$headingSubTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_progress_bar_advanced .bt_bb_progress_bar_advanced_bar_text span{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_progress_bar_advanced .bt_bb_progress_bar_advanced_colored_icon svg .cls-1{fill: {$accentColor};}
a .bt_bb_progress_bar_advanced .progressbar-text{color: {$accentColor};}
.bt_bb_single_product .bt_bb_single_product_image .bt_bb_single_product_image_content .bt_bb_single_product_price_cart .add_to_cart_inline a.add_to_cart_button{
    font-family: \"{$buttonFont}\",Arial,Helvetica,sans-serif;
    background-color: {$accentColor};}
.bt_bb_single_product .bt_bb_single_product_content .bt_bb_single_product_title{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_single_product .bt_bb_single_product_content .bt_bb_single_product_price{
    font-family: \"{$headingSubTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_menu_item .bt_bb_menu_item_title_price .bt_bb_menu_item_title span{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_menu_item .bt_bb_menu_item_title_price .bt_bb_menu_item_price span{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_menu_item .bt_bb_menu_item_description span{
    font-family: \"{$bodyFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_before_after_image .bt_bb_before_after_image-horizontal .bt_bb_before_after_image-handle:hover{background: {$accentColor};}
.bt_bb_before_after_image .bt_bb_before_after_image-container.active .bt_bb_before_after_image-handle{background: {$accentColor};}
.bt_bb_before_after_image .bt_bb_before_after_image_block{
    background: {$accentColor};}
.bt_bb_before_after_image .bt_bb_before_after_image_block .bt_bb_before_after_image_headline{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
div.wpcf7-validation-errors,
div.wpcf7-acceptance-missing{border: 2px solid {$accentColor};}
span.wpcf7-not-valid-tip{color: {$accentColor};}
.btLight.btNewsletter .btNewsletterColumn input[type='email']{border-color: {$accentColor};}
.btAccent.btNewsletter .btNewsletterButton input[type='submit']{-webkit-box-shadow: 0 0 0 3em {$accentColor} inset;
    box-shadow: 0 0 0 3em {$accentColor} inset;}
.btAccent.btNewsletter .btNewsletterButton input[type='submit']:hover{-webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;
    color: {$accentColor};}
.btAlternate.btNewsletter .btNewsletterButton input[type='submit']{-webkit-box-shadow: 0 0 0 3em {$alternateColor} inset;
    box-shadow: 0 0 0 3em {$alternateColor} inset;}
.btAlternate.btNewsletter .btNewsletterButton input[type='submit']:hover{-webkit-box-shadow: 0 0 0 2px {$alternateColor} inset;
    box-shadow: 0 0 0 2px {$alternateColor} inset;}
.btContactForm.btCocoForm .btContactColumn input:focus,
.btContactForm.btCocoForm .btContactColumn textarea:focus,
.btContactForm.btCocoForm .btContactColumn .trigger:focus{border: 1px solid {$accentColor} !important;}
.btContactForm.btBella .btContactColumn input:focus,
.btContactForm.btBella .btContactColumn textarea:focus,
.btContactForm.btBella .btContactColumn .trigger:focus{border: 1px solid {$accentColor} !important;}
.products ul li.product .btWooShopLoopItemInner .bt_bb_headline .bt_bb_headline_content a:hover,
.products li.product .btWooShopLoopItemInner .bt_bb_headline .bt_bb_headline_content a:hover{color: {$accentColor};}
.products ul li.product .btWooShopLoopItemInner .added:after,
.products ul li.product .btWooShopLoopItemInner .loading:after,
.products li.product .btWooShopLoopItemInner .added:after,
.products li.product .btWooShopLoopItemInner .loading:after{
    background-color: {$accentColor};}
.products ul li.product .btWooShopLoopItemInner .added_to_cart:hover,
.products li.product .btWooShopLoopItemInner .added_to_cart:hover{color: {$accentColor};}
.products ul li.product .onsale,
.products li.product .onsale{
    background: {$alternateColor};}
nav.woocommerce-pagination ul li a:focus,
nav.woocommerce-pagination ul li a:hover,
nav.woocommerce-pagination ul li a.next,
nav.woocommerce-pagination ul li a.prev,
nav.woocommerce-pagination ul li span.current{color: {$accentColor};}
div.product .onsale{
    background: {$alternateColor};}
div.product div.images .woocommerce-product-gallery__trigger:after{
    -webkit-box-shadow: 0 0 0 2em {$accentColor} inset,0 0 0 2em rgba(255,255,255,.5) inset;
    box-shadow: 0 0 0 2em {$accentColor} inset,0 0 0 2em rgba(255,255,255,.5) inset;}
div.product div.images .woocommerce-product-gallery__trigger:hover:after{-webkit-box-shadow: 0 0 0 2px {$accentColor} inset,0 0 0 2em rgba(255,255,255,.5) inset;
    box-shadow: 0 0 0 2px {$accentColor} inset,0 0 0 2em rgba(255,255,255,.5) inset;
    color: {$accentColor};}
div.product div.summary .price{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
table.shop_table .coupon .input-text{
    color: {$accentColor};}
table.shop_table td.product-remove a.remove{
    -webkit-box-shadow: 0 0 0 3em {$accentColor} inset;
    box-shadow: 0 0 0 3em {$accentColor} inset;}
table.shop_table td.product-remove a.remove:hover{-webkit-box-shadow: 0 0 0 3em {$alternateColor} inset;
    box-shadow: 0 0 0 3em {$alternateColor} inset;}
ul.wc_payment_methods li .about_paypal{
    color: {$accentColor};}
.woocommerce-MyAccount-navigation ul li a{
    border-bottom: 2px solid {$accentColor};}
.btDarkSkin .woocommerce-error,
.btLightSkin .btDarkSkin .woocommerce-error,
.btDarkSkin.btLightSkin .btDarkSkin .woocommerce-error,
.btDarkSkin .woocommerce-info,
.btLightSkin .btDarkSkin .woocommerce-info,
.btDarkSkin.btLightSkin .btDarkSkin .woocommerce-info,
.btDarkSkin .woocommerce-message,
.btLightSkin .btDarkSkin .woocommerce-message,
.btDarkSkin.btLightSkin .btDarkSkin .woocommerce-message{border-top: 4px solid {$accentColor};}
.woocommerce-info a:not(.button),
.woocommerce-message a:not(.button){color: {$accentColor};}
.woocommerce-message:before,
.woocommerce-info:before{
    color: {$accentColor};}
.woocommerce .btSidebar a.button,
.woocommerce .btContent a.button,
.woocommerce-page .btSidebar a.button,
.woocommerce-page .btContent a.button,
.woocommerce .btSidebar input[type=\"submit\"],
.woocommerce .btContent input[type=\"submit\"],
.woocommerce-page .btSidebar input[type=\"submit\"],
.woocommerce-page .btContent input[type=\"submit\"],
.woocommerce .btSidebar button[type=\"submit\"],
.woocommerce .btContent button[type=\"submit\"],
.woocommerce-page .btSidebar button[type=\"submit\"],
.woocommerce-page .btContent button[type=\"submit\"],
.woocommerce .btSidebar input.button,
.woocommerce .btContent input.button,
.woocommerce-page .btSidebar input.button,
.woocommerce-page .btContent input.button,
.woocommerce .btSidebar input.alt:hover,
.woocommerce .btContent input.alt:hover,
.woocommerce-page .btSidebar input.alt:hover,
.woocommerce-page .btContent input.alt:hover,
.woocommerce .btSidebar a.button.alt:hover,
.woocommerce .btContent a.button.alt:hover,
.woocommerce-page .btSidebar a.button.alt:hover,
.woocommerce-page .btContent a.button.alt:hover,
.woocommerce .btSidebar .button.alt:hover,
.woocommerce .btContent .button.alt:hover,
.woocommerce-page .btSidebar .button.alt:hover,
.woocommerce-page .btContent .button.alt:hover,
.woocommerce .btSidebar button.alt:hover,
.woocommerce .btContent button.alt:hover,
.woocommerce-page .btSidebar button.alt:hover,
.woocommerce-page .btContent button.alt:hover,
div.woocommerce a.button,
div.woocommerce input[type=\"submit\"],
div.woocommerce button[type=\"submit\"],
div.woocommerce input.button,
div.woocommerce input.alt:hover,
div.woocommerce a.button.alt:hover,
div.woocommerce .button.alt:hover,
div.woocommerce button.alt:hover{
    font-family: \"{$buttonFont}\",Arial,Helvetica,sans-serif;}
.woocommerce .btSidebar a.button,
.woocommerce .btContent a.button,
.woocommerce-page .btSidebar a.button,
.woocommerce-page .btContent a.button,
.woocommerce .btSidebar input[type=\"submit\"],
.woocommerce .btContent input[type=\"submit\"],
.woocommerce-page .btSidebar input[type=\"submit\"],
.woocommerce-page .btContent input[type=\"submit\"],
.woocommerce .btSidebar button[type=\"submit\"],
.woocommerce .btContent button[type=\"submit\"],
.woocommerce-page .btSidebar button[type=\"submit\"],
.woocommerce-page .btContent button[type=\"submit\"],
.woocommerce .btSidebar input.button,
.woocommerce .btContent input.button,
.woocommerce-page .btSidebar input.button,
.woocommerce-page .btContent input.button,
.woocommerce .btSidebar input.alt:hover,
.woocommerce .btContent input.alt:hover,
.woocommerce-page .btSidebar input.alt:hover,
.woocommerce-page .btContent input.alt:hover,
.woocommerce .btSidebar a.button.alt:hover,
.woocommerce .btContent a.button.alt:hover,
.woocommerce-page .btSidebar a.button.alt:hover,
.woocommerce-page .btContent a.button.alt:hover,
.woocommerce .btSidebar .button.alt:hover,
.woocommerce .btContent .button.alt:hover,
.woocommerce-page .btSidebar .button.alt:hover,
.woocommerce-page .btContent .button.alt:hover,
.woocommerce .btSidebar button.alt:hover,
.woocommerce .btContent button.alt:hover,
.woocommerce-page .btSidebar button.alt:hover,
.woocommerce-page .btContent button.alt:hover,
div.woocommerce a.button,
div.woocommerce input[type=\"submit\"],
div.woocommerce button[type=\"submit\"],
div.woocommerce input.button,
div.woocommerce input.alt:hover,
div.woocommerce a.button.alt:hover,
div.woocommerce .button.alt:hover,
div.woocommerce button.alt:hover{
    -webkit-box-shadow: 0 0 0 3em {$accentColor} inset;
    box-shadow: 0 0 0 3em {$accentColor} inset;}
.woocommerce .btSidebar a.button:hover,
.woocommerce .btContent a.button:hover,
.woocommerce-page .btSidebar a.button:hover,
.woocommerce-page .btContent a.button:hover,
.woocommerce .btSidebar input[type=\"submit\"]:hover,
.woocommerce .btContent input[type=\"submit\"]:hover,
.woocommerce-page .btSidebar input[type=\"submit\"]:hover,
.woocommerce-page .btContent input[type=\"submit\"]:hover,
.woocommerce .btSidebar button[type=\"submit\"]:hover,
.woocommerce .btContent button[type=\"submit\"]:hover,
.woocommerce-page .btSidebar button[type=\"submit\"]:hover,
.woocommerce-page .btContent button[type=\"submit\"]:hover,
.woocommerce .btSidebar input.button:hover,
.woocommerce .btContent input.button:hover,
.woocommerce-page .btSidebar input.button:hover,
.woocommerce-page .btContent input.button:hover,
.woocommerce .btSidebar input.alt,
.woocommerce .btContent input.alt,
.woocommerce-page .btSidebar input.alt,
.woocommerce-page .btContent input.alt,
.woocommerce .btSidebar a.button.alt,
.woocommerce .btContent a.button.alt,
.woocommerce-page .btSidebar a.button.alt,
.woocommerce-page .btContent a.button.alt,
.woocommerce .btSidebar .button.alt,
.woocommerce .btContent .button.alt,
.woocommerce-page .btSidebar .button.alt,
.woocommerce-page .btContent .button.alt,
.woocommerce .btSidebar button.alt,
.woocommerce .btContent button.alt,
.woocommerce-page .btSidebar button.alt,
.woocommerce-page .btContent button.alt,
div.woocommerce a.button:hover,
div.woocommerce input[type=\"submit\"]:hover,
div.woocommerce button[type=\"submit\"]:hover,
div.woocommerce input.button:hover,
div.woocommerce input.alt,
div.woocommerce a.button.alt,
div.woocommerce .button.alt,
div.woocommerce button.alt{
    color: {$accentColor};
    -webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;}
.star-rating span:before{
    color: {$accentColor};}
p.stars a[class^=\"star-\"].active:after,
p.stars a[class^=\"star-\"]:hover:after{color: {$accentColor};}
.select2-container--default .select2-results__option--highlighted[aria-selected],
.select2-container--default .select2-results__option--highlighted[data-selected]{background-color: {$accentColor};}
p.out-of-stock{color: {$accentColor};}
.btQuoteBooking .btContactNext{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;
    color: {$accentColor};
    -webkit-box-shadow: 0 0 0 1px {$accentColor} inset;
    box-shadow: 0 0 0 1px {$accentColor} inset;}
.btQuoteBooking .btContactNext:hover{
    -webkit-box-shadow: 0 0 0 3em {$accentColor} inset;
    box-shadow: 0 0 0 3em {$accentColor} inset;}
.btQuoteBooking .btQuoteSwitch.on .btQuoteSwitchInner{background: {$accentColor};}
.btQuoteBooking textarea:focus,
.btQuoteBooking input[type=\"text\"]:focus,
.btQuoteBooking input[type=\"email\"]:focus,
.btQuoteBooking input[type=\"password\"]:focus,
.btQuoteBooking .fancy-select .trigger:focus,
.btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus,
.btQuoteBooking .ddcommon.borderRadiusBtm .ddTitleText:focus{
    border: 1px solid {$accentColor};}
.btQuoteBooking .btQuoteItem textarea:focus{
    border: 1px solid {$accentColor};}
.btQuoteBooking .btQuoteItem label{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.btQuoteBooking .dd.ddcommon.borderRadiusTp .ddTitleText,
.btQuoteBooking .dd.ddcommon.borderRadiusBtm .ddTitleText{-webkit-box-shadow: 5px 0 0 {$accentColor} inset,0 2px 10px rgba(0,0,0,.2);
    box-shadow: 5px 0 0 {$accentColor} inset,0 2px 10px rgba(0,0,0,.2);}
.btQuoteBooking .ui-slider .ui-slider-handle{background: {$accentColor};}
.btQuoteBooking .btQuoteBookingForm .btQuoteTotal{
    background: {$accentColor};}
.btQuoteBooking .btQuoteContact .btQuoteItem .btContactFieldMandatory.btContactFieldError input,
.btQuoteBooking .btQuoteContact .btQuoteItem .btContactFieldMandatory.btContactFieldError textarea{border-color: {$accentColor};}
.btQuoteBooking .btQuoteContact .btQuoteItem .btContactFieldMandatory.btContactFieldError textarea.btContactMessage{-webkit-box-shadow: 0 0 0 1px {$accentColor} inset !important;
    box-shadow: 0 0 0 1px {$accentColor} inset !important;
    border-color: {$accentColor} !important;}
.btQuoteBooking .btQuoteContact .btQuoteItem .btContactFieldMandatory.btContactFieldError .dd.ddcommon.borderRadius .ddTitleText{-webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;}
.btQuoteBooking .btSubmitMessage{color: {$accentColor};}
.btQuoteBooking .dd.ddcommon.borderRadiusTp .ddTitleText,
.btQuoteBooking .btQuoteBooking .dd.ddcommon.borderRadiusBtm .ddTitleText{
    border: 1px solid {$accentColor};}
.btQuoteBooking .btContactSubmit{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;
    -webkit-box-shadow: 0 0 0 3em {$accentColor} inset;
    box-shadow: 0 0 0 3em {$accentColor} inset;}
.btQuoteBooking .btContactSubmit:hover{color: {$accentColor};
    -webkit-box-shadow: 0 0 0 1px {$accentColor} inset;
    box-shadow: 0 0 0 1px {$accentColor} inset;}
.bt_cc_email_confirmation_container [type=\"checkbox\"]:not(:checked) + label:before,
.bt_cc_email_confirmation_container [type=\"checkbox\"]:checked + label:before{border: 2px solid {$accentColor};}
.btDatePicker .ui-datepicker-header{background-color: {$accentColor};}
.bt_bb_cost_calculator .bt_bb_cost_calculator_total{background-color: {$accentColor};}
.bt_bb_cost_calculator .bt_bb_cost_calculator_total .bt_bb_cost_calculator_total_text{background-color: {$accentColor};}
.btQuoteBooking.btPetBoard .btQuoteItem .btQuoteSlider{
    background: {$accentColor};}
.btLuxBoard.btQuoteBooking.btPetBoard .btQuoteItem .btQuoteSlider{background: {$alternateColor};}
.btQuoteBooking.btPetBoard .btQuoteItem .ui-slider .ui-slider-handle{background: {$alternateColor};}
.btLuxBoard.btQuoteBooking.btPetBoard .btQuoteItem .ui-slider .ui-slider-handle{background: {$accentColor};}
.btLuxBoard.btQuoteBooking.btPetBoard .btQuoteBookingForm .btQuoteTotal{color: {$accentColor};}
.btQuoteBooking.btPetBoard .btQuoteBookingForm .btQuoteTotal .btQuoteTotalText{
    color: {$accentColor};}
.btQuoteBooking.btPetBoard .btQuoteBookingForm .btQuoteTotal .btQuoteTotalCurrency{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.btQuoteBooking.btPetBoard .btQuoteBookingForm .btQuoteTotal .btQuoteTotalCalc{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
", array() );