<?php

class bt_bb_service extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'icon'         					=> '',
			'title'        					=> '',
			'text'         					=> '',
			'url'          					=> '',
			'target'       					=> '',
			'color_scheme' 					=> '',
			'style'        					=> '',
			'size'         					=> '',
			'shape'        					=> '',
			'align'        					=> '',
			'colored_icon'         			=> 'no_icon',
			'colored_icon_color_scheme' 	=> '',
			'title_color_scheme' 			=> '',
			'title_size'         			=> '',
			'title_weight'      			=> '',
			'border'         				=> ''
		) ), $atts, $this->shortcode ) );

		$class = array( $this->shortcode );
		$data_override_class = array();

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}
		
		$color_scheme_id = NULL;
		if ( is_numeric ( $color_scheme ) ) {
			$color_scheme_id = $color_scheme;
		} else if ( $color_scheme != '' ) {
			$color_scheme_id = bt_bb_get_color_scheme_id( $color_scheme );
		}
		$color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $color_scheme_id - 1 );
		if ( $color_scheme_colors ) $el_style .= '; --service-primary-color:' . $color_scheme_colors[0] . '; --service-secondary-color:' . $color_scheme_colors[1] . ';';
		if ( $color_scheme != '' ) $class[] = $this->prefix . 'color_scheme_' .  $color_scheme_id;

		if ( $style != '' ) {
			$class[] = $this->prefix . 'style' . '_' . $style;
		}

		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'size',
				'value' => $size
			)
		);

		if ( $shape != '' ) {
			$class[] = $this->prefix . 'shape' . '_' . $shape;
		}

		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'align',
				'value' => $align
			)
		);

		if ( $text == '' ) {
			$class[] = 'btNoText';
		}

		if ( $title == '' && $text != '' ) {
			$class[] = 'btNoTitle';
		}

		if ( $title_size != '' ) {
			$class[] = $this->prefix . 'title_size' . '_' . $title_size;
		}

		if ( $border != '' ) {
			$class[] = $this->prefix . 'border' . '_' . $border;
		}

		if ( $title_weight != '' ) {
			$class[] = $this->prefix . 'title_weight' . '_' . $title_weight;
		}

		$colored_icon_color_scheme_id = NULL;
		if ( is_numeric ( $colored_icon_color_scheme ) ) {
			$colored_icon_color_scheme_id = $colored_icon_color_scheme;
		} else if ( $colored_icon_color_scheme != '' ) {
			$colored_icon_color_scheme_id = bt_bb_get_color_scheme_id( $colored_icon_color_scheme );
		}
		$colored_icon_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $colored_icon_color_scheme_id - 1 );
		if ( $colored_icon_color_scheme_colors ) $el_style .= '; --service-colored-icon-primary-color:' . $colored_icon_color_scheme_colors[0] . '; --service-colored-icon-secondary-color:' . $colored_icon_color_scheme_colors[1] . ';';
		if ( $colored_icon_color_scheme != '' ) $class[] = $this->prefix . 'colored_icon_color_scheme_' .  $colored_icon_color_scheme_id;

		$title_color_scheme_id = NULL;
		if ( is_numeric ( $title_color_scheme ) ) {
			$title_color_scheme_id = $title_color_scheme;
		} else if ( $title_color_scheme != '' ) {
			$title_color_scheme_id = bt_bb_get_color_scheme_id( $title_color_scheme );
		}
		$title_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $title_color_scheme_id - 1 );
		if ( $title_color_scheme_colors ) $el_style .= '; --service-title-primary-color:' . $title_color_scheme_colors[0] . '; --service-title-secondary-color:' . $title_color_scheme_colors[1] . ';';
		if ( $title_color_scheme != '' ) $class[] = $this->prefix . 'title_color_scheme_' .  $title_color_scheme_id;

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}

		$class = apply_filters( $this->shortcode . '_class', $class, $atts );		
		$class_attr = implode( ' ', $class );

		if ( $el_class != '' ) {
			$class_attr = $class_attr . ' ' . $el_class;
		}		

		$link = bt_bb_get_url( $url );

		if ( $link != '' ) {
			$title = '<a href="' . esc_url( $link ) . '" target="' . esc_attr( $target ) . '">' . $title . '</a>';
		}
		
		$icon_html = bt_bb_icon::get_html( $icon, '', $link, $target );

		// SERVICE
		$output = '<div' . $id_attr . ' class="' . esc_attr( implode( ' ', $class ) ) . '"' . $style_attr . ' data-bt-override-class="' . htmlspecialchars( json_encode( $data_override_class, JSON_FORCE_OBJECT ), ENT_QUOTES, 'UTF-8' ) . '">';

			// ICON
			if ( $icon != '' && $colored_icon == '' || $colored_icon == 'no_icon'  ) {
				$output .= $icon_html;
			}


			// COLORED ICON
			if ( $colored_icon != '' && $colored_icon != 'no_icon' ) {

				$output .= '<div class="' . esc_attr( $this->shortcode . '_colored_icon' ) . '">';
					
					if ( $link != '' ) {
						$output .= '<a href="' . esc_url( $link ) . '" target="' . esc_attr( $target ) . '">';
							$output .= bt_bb_get_svg_icon_html( $colored_icon );
						$output .= '</a>';

					} else {
						$output .= '<span>';
							$output .= bt_bb_get_svg_icon_html( $colored_icon );
						$output .= '</span>';
					}

				$output .= '</div>';
			}

			// CONTENT
			$output .= '<div class="' . esc_attr( $this->shortcode ) . '_content">';
				if ( $title != '' )$output .= '<div class="' . esc_attr( $this->shortcode ) . '_content_title">' . $title . '</div>';
				if ( $text != '' ) $output .= '<div class="' . esc_attr( $this->shortcode ) . '_content_text">' . nl2br( $text ) . '</div>';
			$output .= '</div>';


		$output .= '</div>';

		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {

		$color_scheme_arr = bt_bb_get_color_scheme_param_array();
		$svg_icons_arr = bt_bb_get_svg_icons_param_array();

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Service', 'pawsitive' ), 'description' => esc_html__( 'Icon with text', 'pawsitive' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'icon', 'type' => 'iconpicker', 'heading' => esc_html__( 'Icon', 'pawsitive' ), 'group' => esc_html__( 'Icon', 'pawsitive' ), 'description' => esc_html__( 'If colored icon is chosen from the list, regular icon will not be displayed', 'pawsitive' ), 'preview' => true ),
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon color scheme', 'pawsitive' ), 'value' => $color_scheme_arr, 'preview' => true, 'group' => esc_html__( 'Icon', 'pawsitive' ) ),
				array( 'param_name' => 'style', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon style', 'pawsitive' ), 'preview' => true, 'group' => esc_html__( 'Icon', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Outline', 'pawsitive' ) 			=> 'outline',
						esc_html__( 'Filled', 'pawsitive' ) 			=> 'filled',
						esc_html__( 'Borderless', 'pawsitive' ) 		=> 'borderless'
					)
				),
				array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon shape', 'pawsitive' ), 'group' => esc_html__( 'Icon', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Circle', 'pawsitive' ) 			=> 'circle',
						esc_html__( 'Square', 'pawsitive' ) 			=> 'square',
						esc_html__( 'Rounded Square', 'pawsitive' ) 	=> 'round'
					)
				),

				array( 'param_name' => 'colored_icon', 'type' => 'dropdown', 'default' => 'no_icon', 'group' => esc_html__( 'Icon', 'pawsitive' ), 'heading' => esc_html__( 'Colored Icon', 'pawsitive' ), 'description' => esc_html__( 'If colored icon is chosen from the list, regular icon will not be displayed', 'pawsitive' ), 'value' => $svg_icons_arr ),
				array( 'param_name' => 'colored_icon_color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Colored icon color scheme', 'pawsitive' ), 'value' => $color_scheme_arr, 'group' => esc_html__( 'Icon', 'pawsitive' ) ),
				
				array( 'param_name' => 'title', 'type' => 'textfield', 'heading' => esc_html__( 'Title', 'pawsitive' ), 'group' => esc_html__( 'Content', 'pawsitive' ), 'preview' => true ),
				array( 'param_name' => 'text', 'type' => 'textarea', 'group' => esc_html__( 'Content', 'pawsitive' ), 'heading' => esc_html__( 'Text', 'pawsitive' ) ),
				array( 'param_name' => 'url', 'type' => 'textfield', 'heading' => esc_html__( 'URL', 'pawsitive' ), 'group' => esc_html__( 'Content', 'pawsitive' ), 'description' => esc_html__( 'Enter full or local URL (eg. https://www.bold-themes.com or /pages/about-us) or post slug (eg. about-us)', 'pawsitive' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'pawsitive' ), 'group' => esc_html__( 'Content', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'pawsitive' ) 	=> '_self',
						esc_html__( 'Blank (open in new tab)', 'pawsitive' ) 	=> '_blank',
					)
				),
				array( 'param_name' => 'title_color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Title color scheme', 'pawsitive' ), 'value' => $color_scheme_arr, 'group' => esc_html__( 'Content', 'pawsitive' ) ),
				array( 'param_name' => 'title_size', 'type' => 'dropdown', 'default' => '', 'heading' => esc_html__( 'Title size', 'pawsitive' ), 'preview' => true, 'group' => esc_html__( 'Content', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Inherit', 'pawsitive' ) 			=> '',
						esc_html__( 'Extra small', 'pawsitive' ) 		=> 'xsmall',
						esc_html__( 'Small', 'pawsitive' ) 			=> 'small',
						esc_html__( 'Normal', 'pawsitive' ) 			=> 'normal',
						esc_html__( 'Large', 'pawsitive' ) 			=> 'large',
						esc_html__( 'Extra large', 'pawsitive' ) 		=> 'xlarge',
						esc_html__( 'Huge', 'pawsitive' ) 			=> 'huge'
					)
				),
				array( 'param_name' => 'title_weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Title weight', 'pawsitive' ), 'group' => esc_html__( 'Content', 'pawsitive' ), 
					'value' => array(
						esc_html__( 'Inherit', 'pawsitive' ) 			=> '',
						esc_html__( 'Thin', 'pawsitive' ) 			=> 'thin',
						esc_html__( 'Lighter', 'pawsitive' ) 			=> 'lighter',
						esc_html__( 'Light', 'pawsitive' ) 			=> 'light',
						esc_html__( 'Normal', 'pawsitive' ) 			=> 'normal',
						esc_html__( 'Medium', 'pawsitive' ) 			=> 'medium',
						esc_html__( 'Semi bold', 'pawsitive' ) 		=> 'semi-bold',
						esc_html__( 'Bold', 'pawsitive' ) 			=> 'bold',
						esc_html__( 'Bolder', 'pawsitive' ) 			=> 'bolder',
						esc_html__( 'Black', 'pawsitive' ) 			=> 'black'
					)
				),

				array( 'param_name' => 'align', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon alignment', 'pawsitive' ), 'group' => esc_html__( 'Icon', 'pawsitive' ), 'responsive_override' => true,
					'value' => array(
						esc_html__( 'Inherit', 'pawsitive' ) 			=> 'inherit',
						esc_html__( 'Left', 'pawsitive' ) 			=> 'left',
						esc_html__( 'Right', 'pawsitive' ) 			=> 'right'
					)
				),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon size', 'pawsitive' ), 'responsive_override' => true, 'preview' => true, 'group' => esc_html__( 'Icon', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Extra small', 'pawsitive' ) 		=> 'xsmall',
						esc_html__( 'Small', 'pawsitive' ) 			=> 'small',
						esc_html__( 'Normal', 'pawsitive' ) 			=> 'normal',
						esc_html__( 'Large', 'pawsitive' ) 			=> 'large',
						esc_html__( 'Extra large', 'pawsitive' ) 		=> 'xlarge'
					)
				),
				array( 'param_name' => 'border', 'type' => 'dropdown', 'heading' => esc_html__( 'Border', 'pawsitive' ), 'group' => esc_html__( 'Icon', 'pawsitive' ),
					'value' => array(
						esc_html__( 'No', 'pawsitive' ) 				=> '',
						esc_html__( 'Yes', 'pawsitive' ) 				=> 'visible'
					)
				)
			)
		) );
	}
}