<?php

class bt_bb_section extends BT_BB_Element {
    
        function  bb_exist() {
            if ( file_exists( WP_PLUGIN_DIR . '/bold-page-builder/bold-builder.php' ) ) { return true; }
            return false;
        }

	function handle_shortcode( $atts, $content ) {
                if ( !$this->bb_exist() ) { return false; }
            
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'layout'                		=> '',
			'full_screen'           		=> '',
			'vertical_align'        		=> '',
			'top_spacing'           		=> '',
			'bottom_spacing'        		=> '',
			'negative_margin'				=> '',
			'color_scheme'          		=> '',
			'background_color'      		=> '',
			'background_image'      		=> '',
			'lazy_load'  					=> 'no',
			'background_overlay'    		=> '',
			'background_video_yt'   		=> '',
			'yt_video_settings'     		=> '',
			'background_video_mp4'  		=> '',
			'background_video_ogg'  		=> '',
			'background_video_webm' 		=> '',
			'show_video_on_mobile' 			=> '',
			'parallax'              		=> '',
			'parallax_offset'       		=> '',
			'background_position'    		=> '',
			'background_size'               => '',
			'top_section_coverage_image'    => '',
			'bottom_section_coverage_image' => ''
		) ), $atts, $this->shortcode ) );

		$class = array( $this->shortcode );

		wp_enqueue_script(
			'bt_bb_elements',
			 plugins_url() . '/bold-page-builder/content_elements/bt_bb_section/bt_bb_elements.js',
			 array( 'jquery' ),
			 '',
			 true
		);

		$show_video_on_mobile = ( $show_video_on_mobile == 'show_video_on_mobile' || $show_video_on_mobile == 'yes' ) ? 1 : 0;

		$color_scheme_id = NULL;
		if ( is_numeric ( $color_scheme ) ) {
			$color_scheme_id = $color_scheme;
		} else if ( $color_scheme != '' ) {
			$color_scheme_id = bt_bb_get_color_scheme_id( $color_scheme );
		}
		$color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $color_scheme_id - 1 );
		if ( $color_scheme_colors ) $el_style .= '; --section-primary-color:' . $color_scheme_colors[0] . '; --section-secondary-color:' . $color_scheme_colors[1] . ';';
		if ( $color_scheme != '' ) $class[] = $this->prefix . 'color_scheme_' .  $color_scheme_id;
		
		if ( $background_color != '' ) {
			$el_style = $el_style . ';' . 'background-color:' . $background_color . ';';
		}

		if ( $layout != '' ) {
			$class[] = $this->prefix . 'layout' . '_' . $layout;
		}

		if ( $full_screen == 'yes' ) {
			$class[] = $this->prefix . 'full_screen';
		}

		if ( $vertical_align != '' ) {
			$class[] = $this->prefix . 'vertical_align' . '_' . $vertical_align;
		}

		if ( $negative_margin != '' ) {
			$class[] = $this->prefix . 'negative_margin' . '_' . $negative_margin;
		}

		$data_parallax_attr = '';
		if ( $parallax != '' ) {
			$data_parallax_attr = 'data-parallax="' . esc_attr( $parallax ) . '" data-parallax-offset="' . esc_attr( intval( $parallax_offset ) ) . '"';
			$class[] = $this->prefix . 'parallax';
		}
		$background_data_attr = '';

		if ( $background_image != '' ) {
			$background_image = wp_get_attachment_image_src( $background_image, 'full' );
			$background_image_url = '';
			if ( $background_image ) {
				$background_image_url = isset($background_image[0]) ? $background_image[0] : '';
			}
			// $background_image_url = $background_image[0];
			if ( $background_image_url != '' ) {
				if ( $lazy_load == 'yes' ) {
					$blank_image_src = BT_BB_Root::$path . 'img/blank.gif';
					$background_image_style = 'background-image:url(\'' . $blank_image_src . '\');';
					$background_data_attr .= ' data-background_image_src="\'' . $background_image_url . '\'"';
					$class[] = 'btLazyLoadBackground';
				} else {
					$background_image_style = 'background-image:url(\'' . $background_image_url . '\');';
					
				}
				$el_style = $background_image_style . $el_style;	
				$class[] = $this->prefix . 'background_image';			
			}

		}

		if ( $background_overlay != '' ) {
			$class[] = $this->prefix . 'background_overlay' . '_' . $background_overlay;
		}

		$id_attr = '';
		if ( $el_id == '' ) {
			$el_id = uniqid( 'bt_bb_section' );
		}
		$id_attr = 'id="' . esc_attr( $el_id ) . '"';

		$background_video_attr = '';

		$video_html = '';

		if ( $background_video_yt != '' ) {
			wp_enqueue_style( 'bt_bb_style_yt', plugins_url() . '/bold-page-builder/content_elements/bt_bb_section/YTPlayer.css' );
			wp_enqueue_script( 
				'bt_bb_yt',
				plugins_url() . '/bold-page-builder/content_elements/bt_bb_section/jquery.mb.YTPlayer.min.js',
				array( 'jquery' ),
				'',
				true
			);

			$class[] = $this->prefix . 'background_video_yt';

			if ( $yt_video_settings == '' ) {
				$yt_video_settings = 'showControls:false,showYTLogo:false,startAt:0,loop:true,mute:true,stopMovieOnBlur:false,opacity:1';
				// $yt_video_settings = '';
			}

			$yt_video_settings .= $show_video_on_mobile ? ',useOnMobile:true' : ',useOnMobile:false';
			
			$yt_video_settings .= '';
			// $yt_video_settings .= ',cc_load_policy:false,showAnnotations:false,optimizeDisplay:true,anchor:\'center,center\'';

			$background_video_attr = ' ' . 'data-property="{videoURL:\'' . $background_video_yt . '\',containment:\'#' . $el_id . '\',' . $yt_video_settings . '}"';
			
			$video_html .= '<div class="' . $this->prefix . 'background_video_yt_inner" ' . $background_video_attr . ' ></div>';
			
			$proxy = new BT_BB_YT_Video_Proxy( $this->prefix, $el_id );
			add_action( 'wp_footer', array( $proxy, 'js_init' ) );

		} else if ( ( $background_video_mp4 != '' || $background_video_ogg != '' || $background_video_webm != '' ) ) {
			$class[] = $this->prefix . 'video';
			$video_html = '<video autoplay loop muted playsinline onplay="bt_bb_video_callback( this )">';
			if ( $background_video_mp4 != '' ) {
				$video_html .= '<source src="' . esc_url( $background_video_mp4 ) . '" type="video/mp4">';
			}
			if ( $background_video_ogg != '' ) {
				$video_html .= '<source src="' . esc_url( $background_video_ogg ) . '" type="video/ogg">';
			}
			if ( $background_video_webm != '' ) {
				$video_html .= '<source src="' . esc_url( $background_video_webm ) . '" type="video/webm">';
			}
			$video_html .= '</video>';
		}

		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'top_spacing',
				'value' => $top_spacing
			)
		);
		
		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'bottom_spacing',
				'value' => $bottom_spacing
			)
		);

		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		$class_attr = implode( ' ', $class );

		if ( $el_class != '' ) {
			$class_attr = $class_attr . ' ' . $el_class;
		}

		$top_section_coverage_image_output = '';
			if ( $top_section_coverage_image != '' ) { 
				$alt_top_section_coverage_image = get_post_meta($top_section_coverage_image, '_wp_attachment_image_alt', true);
				$alt_top_section_coverage_image = $alt_top_section_coverage_image ? $alt_top_section_coverage_image : $this->shortcode . '_top_section_coverage_image';

				$top_section_coverage_image = wp_get_attachment_image_src( $top_section_coverage_image, 'full' );
				if ( isset($top_section_coverage_image[0]) ) {
					$class_attr = $class_attr . ' ' . $this->shortcode . '_with_top_coverage_image';
					$top_section_coverage_image = $top_section_coverage_image[0];
					$top_section_coverage_image_output = 
						'<div class="' . esc_attr( $this->shortcode ) . '_top_section_coverage_image">'
							. '<img src="' . esc_url( $top_section_coverage_image ) . '" alt="' . esc_attr($alt_top_section_coverage_image) . '" />'
						. '</div>';
				}
			}

		$bottom_section_coverage_image_output = '';
			if ( $bottom_section_coverage_image != '' ) {  
				$alt_bottom_section_coverage_image = get_post_meta($bottom_section_coverage_image, '_wp_attachment_image_alt', true);
				$alt_bottom_section_coverage_image = $alt_bottom_section_coverage_image ? $alt_bottom_section_coverage_image : $this->shortcode . '_bottom_section_coverage_image';

				$bottom_section_coverage_image = wp_get_attachment_image_src( $bottom_section_coverage_image, 'full' );
				if ( isset($bottom_section_coverage_image[0]) ) {
					$class_attr = $class_attr . ' ' .$this->shortcode . '_with_bottom_coverage_image';
					$bottom_section_coverage_image = $bottom_section_coverage_image[0];
					$bottom_section_coverage_image_output = 
						'<div class="' . esc_attr( $this->shortcode ) . '_bottom_section_coverage_image">'
							. '<img src="' . esc_url( $bottom_section_coverage_image ) . '" alt="' . esc_attr($alt_bottom_section_coverage_image) . '" />'
						. '</div>';
				}
			}


		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = 'style="' . esc_attr( $el_style ) . '"';
		}

		$output = '<section ' . $id_attr . ' ' . $data_parallax_attr . $background_data_attr . ' class="' . esc_attr( $class_attr ) . '" ' . $style_attr . $background_video_attr . ' data-bt-override-class="' . htmlspecialchars( json_encode( $data_override_class, JSON_FORCE_OBJECT ), ENT_QUOTES, 'UTF-8' ) . '">';
			$output .= $video_html;
			
			$output .= '<div class="' . esc_attr( $this->prefix ) . 'port">';
				$output .= '<div class="' . esc_attr( $this->prefix ) . 'cell">';
					$output .= '<div class="' . esc_attr( $this->prefix ) . 'cell_inner">';
						$output .= do_shortcode( $content );
					$output .= '</div>';
				$output .= '</div>';
			$output .= '</div>';

			$output .= $top_section_coverage_image_output;
			$output .= $bottom_section_coverage_image_output;

		$output .= '</section>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {

		if ( !$this->bb_exist() ) { return false; }
		require_once( WP_PLUGIN_DIR   . '/bold-page-builder/content_elements_misc/misc.php' );
		$color_scheme_arr = bt_bb_get_color_scheme_param_array();

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Section', 'pawsitive' ), 'description' => esc_html__( 'Basic root element', 'pawsitive' ), 'root' => true, 'container' => 'vertical', 'accept' => array( 'bt_bb_row' => true ), 'toggle' => true, 'auto_add' => 'bt_bb_row', 'show_settings_on_create' => false,
			'params' => array( 
				array( 'param_name' => 'layout', 'type' => 'dropdown', 'default' => 'boxed_1200', 'heading' => esc_html__( 'Layout', 'pawsitive' ), 'group' => esc_html__( 'General', 'pawsitive' ), 'weight' => 0, 'preview' => true,
					'value' => array(
						esc_html__( 'Boxed (800px)', 'pawsitive' ) 			=> 'boxed_800',
						esc_html__( 'Boxed (900px)', 'pawsitive' ) 			=> 'boxed_900',
						esc_html__( 'Boxed (1000px)', 'pawsitive' ) 			=> 'boxed_1000',
						esc_html__( 'Boxed (1100px)', 'pawsitive' ) 			=> 'boxed_1100',
						esc_html__( 'Boxed (1200px)', 'pawsitive' ) 			=> 'boxed_1200',
						esc_html__( 'Boxed (1300px)', 'pawsitive' ) 			=> 'boxed_1300',
						esc_html__( 'Boxed (1400px)', 'pawsitive' ) 			=> 'boxed_1400',
						esc_html__( 'Boxed (1500px)', 'pawsitive' ) 			=> 'boxed_1500',
						esc_html__( 'Boxed (1600px)', 'pawsitive' ) 			=> 'boxed_1600',
						esc_html__( 'Boxed limit (1400px)', 'pawsitive' ) 	=> 'boxed_limit_1400',
						esc_html__( 'Boxed right (1200px)', 'pawsitive' ) 	=> 'boxed_right_1200',
						esc_html__( 'Boxed left (1200px)', 'pawsitive' ) 		=> 'boxed_left_1200',
						esc_html__( 'Wide', 'pawsitive' ) 					=> 'wide'
					)
				),
				array( 'param_name' => 'top_spacing', 'type' => 'dropdown', 'heading' => esc_html__( 'Top spacing', 'pawsitive' ), 'preview' => true,
					 'responsive_override' => true, 
					 'value' => array(
						esc_html__( 'No spacing', 'pawsitive' ) 		=> 'none',
						esc_html__( 'Extra small', 'pawsitive' ) 		=> 'extra_small',
						esc_html__( 'Small', 'pawsitive' ) 			=> 'small',
						esc_html__( 'Normal', 'pawsitive' ) 			=> 'normal',
						esc_html__( 'Medium', 'pawsitive' ) 			=> 'medium',
						esc_html__( 'Large', 'pawsitive' ) 			=> 'large',
						esc_html__( 'Extra large', 'pawsitive' ) 		=> 'extra_large',
						esc_html__( '5px', 'pawsitive' ) 				=> '5',
						esc_html__( '10px', 'pawsitive' ) 			=> '10',
						esc_html__( '15px', 'pawsitive' ) 			=> '15',
						esc_html__( '20px', 'pawsitive' ) 			=> '20',
						esc_html__( '25px', 'pawsitive' ) 			=> '25',
						esc_html__( '30px', 'pawsitive' ) 			=> '30',
						esc_html__( '35px', 'pawsitive' ) 			=> '35',
						esc_html__( '40px', 'pawsitive' ) 			=> '40',
						esc_html__( '45px', 'pawsitive' ) 			=> '45',
						esc_html__( '50px', 'pawsitive' ) 			=> '50',
						esc_html__( '60px', 'pawsitive' ) 			=> '60',
						esc_html__( '70px', 'pawsitive' ) 			=> '70',
						esc_html__( '80px', 'pawsitive' ) 			=> '80',
						esc_html__( '90px', 'pawsitive' ) 			=> '90',
						esc_html__( '100px', 'pawsitive' ) 			=> '100',
						esc_html__( '110px', 'pawsitive' ) 			=> '110',
						esc_html__( '120px', 'pawsitive' ) 			=> '120',
						esc_html__( '130px', 'pawsitive' ) 			=> '130',
						esc_html__( '140px', 'pawsitive' ) 			=> '140',
						esc_html__( '150px', 'pawsitive' ) 			=> '150'
					)
				),
				array( 'param_name' => 'bottom_spacing', 'type' => 'dropdown', 'heading' => esc_html__( 'Bottom spacing', 'pawsitive' ), 'preview' => true,
					 'responsive_override' => true,
					 'value' => array(
						esc_html__( 'No spacing', 'pawsitive' ) 		=> 'none',
						esc_html__( 'Extra small', 'pawsitive' ) 		=> 'extra_small',
						esc_html__( 'Small', 'pawsitive' ) 			=> 'small',
						esc_html__( 'Normal', 'pawsitive' ) 			=> 'normal',
						esc_html__( 'Medium', 'pawsitive' ) 			=> 'medium',
						esc_html__( 'Large', 'pawsitive' ) 			=> 'large',
						esc_html__( 'Extra large', 'pawsitive' ) 		=> 'extra_large',
						esc_html__( '5px', 'pawsitive' ) 				=> '5',
						esc_html__( '10px', 'pawsitive' ) 			=> '10',
						esc_html__( '15px', 'pawsitive' ) 			=> '15',
						esc_html__( '20px', 'pawsitive' ) 			=> '20',
						esc_html__( '25px', 'pawsitive' ) 			=> '25',
						esc_html__( '30px', 'pawsitive' ) 			=> '30',
						esc_html__( '35px', 'pawsitive' ) 			=> '35',
						esc_html__( '40px', 'pawsitive' ) 			=> '40',
						esc_html__( '45px', 'pawsitive' ) 			=> '45',
						esc_html__( '50px', 'pawsitive' ) 			=> '50',
						esc_html__( '60px', 'pawsitive' ) 			=> '60',
						esc_html__( '70px', 'pawsitive' ) 			=> '70',
						esc_html__( '80px', 'pawsitive' ) 			=> '80',
						esc_html__( '90px', 'pawsitive' ) 			=> '90',
						esc_html__( '100px', 'pawsitive' ) 			=> '100',
						esc_html__( '110px', 'pawsitive' ) 			=> '110',
						esc_html__( '120px', 'pawsitive' ) 			=> '120',
						esc_html__( '130px', 'pawsitive' ) 			=> '130',
						esc_html__( '140px', 'pawsitive' ) 			=> '140',
						esc_html__( '150px', 'pawsitive' ) 			=> '150'
					)
				),
				array( 'param_name' => 'full_screen', 'type' => 'dropdown', 'heading' => esc_html__( 'Full screen', 'pawsitive' ), 
					'value' => array(
						esc_html__( 'No', 'pawsitive' ) 	=> '',
						esc_html__( 'Yes', 'pawsitive' ) 	=> 'yes'
					)
				),
				array( 'param_name' => 'vertical_align', 'type' => 'dropdown', 'heading' => esc_html__( 'Vertical align (for fullscreen section)', 'pawsitive' ), 'preview' => true,
					'value' => array(
						esc_html__( 'Top', 'pawsitive' )     => 'top',
						esc_html__( 'Middle', 'pawsitive' )  => 'middle',
						esc_html__( 'Bottom', 'pawsitive' )  => 'bottom'
					)
				),
				array( 'param_name' => 'negative_margin', 'type' => 'dropdown', 'heading' => esc_html__( 'Negative margin', 'pawsitive' ), 'group' => esc_html__( 'General', 'pawsitive' ), 'weight' => 4, 'preview' => true,
					'value' => array(
							esc_html__( 'No margin', 'pawsitive' ) 	=> '',
							esc_html__( 'Small', 'pawsitive' ) 		=> 'small',
							esc_html__( 'Normal', 'pawsitive' ) 		=> 'normal',
							esc_html__( 'Medium', 'pawsitive' ) 		=> 'medium',
							esc_html__( 'Large', 'pawsitive' ) 		=> 'large',
							esc_html__( 'Extra Large', 'pawsitive' ) 	=> 'extralarge'
						)
					),
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'pawsitive' ), 'value' => $color_scheme_arr, 'preview' => true, 'group' => esc_html__( 'Design', 'pawsitive' )  ),
				array( 'param_name' => 'background_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Background color', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ), 'preview' => true ),
				array( 'param_name' => 'background_image', 'type' => 'attach_image',  'preview' => true, 'heading' => esc_html__( 'Background image', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ) ),
				array( 'param_name' => 'lazy_load', 'type' => 'dropdown', 'default' => 'yes', 'heading' => esc_html__( 'Lazy load background image', 'pawsitive' ),
					'value' => array(
						esc_html__( 'No', 'pawsitive' ) 	=> 'no',
						esc_html__( 'Yes', 'pawsitive' ) 	=> 'yes'
					)
				),
				array( 'param_name' => 'background_overlay', 'type' => 'dropdown', 'heading' => esc_html__( 'Background overlay', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ), 
					'value' => array(
						esc_html__( 'No overlay', 'pawsitive' )    	=> '',
						esc_html__( 'Light stripes', 'pawsitive' ) 	=> 'light_stripes',
						esc_html__( 'Dark stripes', 'pawsitive' )  	=> 'dark_stripes',
						esc_html__( 'Light solid', 'pawsitive' )	  	=> 'light_solid',
						esc_html__( 'Dark solid', 'pawsitive' )	  	=> 'dark_solid',
						esc_html__( 'Light gradient', 'pawsitive' )	=> 'light_gradient',
						esc_html__( 'Dark gradient', 'pawsitive' )	=> 'dark_gradient'
					)
				),
				array( 'param_name' => 'top_section_coverage_image', 'type' => 'attach_image',  'preview' => true, 'heading' => esc_html__( 'Top Section Coverage Image', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ) ),
				array( 'param_name' => 'bottom_section_coverage_image', 'type' => 'attach_image',  'preview' => true, 'heading' => esc_html__( 'Bottom Section Coverage Image', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ) ),
				array( 'param_name' => 'parallax', 'type' => 'textfield', 'heading' => esc_html__( 'Parallax (e.g. 0.7)', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ) ),
				array( 'param_name' => 'parallax_offset', 'type' => 'textfield', 'heading' => esc_html__( 'Parallax offset in px (e.g. -100)', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ) ),
				array( 'param_name' => 'background_video_yt', 'type' => 'textfield', 'heading' => esc_html__( 'YouTube background video', 'pawsitive' ), 'group' => esc_html__( 'Video', 'pawsitive' ) ),
				array( 'param_name' => 'yt_video_settings', 'type' => 'textfield', 'heading' => esc_html__( 'YouTube video settings (e.g. startAt:20, mute:true, stopMovieOnBlur:false)', 'pawsitive' ), 'group' => esc_html__( 'Video', 'pawsitive' ) ),
				array( 'param_name' => 'background_video_mp4', 'type' => 'textfield', 'heading' => esc_html__( 'MP4 background video', 'pawsitive' ), 'group' => esc_html__( 'Video', 'pawsitive' ) ),
				array( 'param_name' => 'background_video_ogg', 'type' => 'textfield', 'heading' => esc_html__( 'OGG background video', 'pawsitive' ), 'group' => esc_html__( 'Video', 'pawsitive' ) ),
				array( 'param_name' => 'background_video_webm', 'type' => 'textfield', 'heading' => esc_html__( 'WEBM background video', 'pawsitive' ), 'group' => esc_html__( 'Video', 'pawsitive' ) ),
				array( 'param_name' => 'show_video_on_mobile',  'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'pawsitive' ) => 'yes' ), 'default' => '', 'heading' => esc_html__( 'Show Video on Mobile Devices', 'pawsitive' ), 'group' => esc_html__( 'Video', 'pawsitive' ) )
			)
		) );
	} 
}

class BT_BB_YT_Video_Proxy {
	function __construct( $prefix, $el_id ) {
		$this->prefix = $prefix;
		$this->el_id = $el_id;
	}
	public function js_init() {
		wp_register_script( 'boldthemes-script-bt-bb-section-js-init', '' );
		wp_enqueue_script( 'boldthemes-script-bt-bb-section-js-init' );
		wp_add_inline_script( 'boldthemes-script-bt-bb-section-js-init', 'jQuery(function() { jQuery( "#' . esc_html( $this->el_id ) . ' .' . esc_html( $this->prefix ) . 'background_video_yt_inner" ).YTPlayer();});' );
    }

}