<?php

class bt_bb_row extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {

		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'column_gap'  				=> '',
			'negative_margin'  			=> '',
			'layout'					=> '',
			'shadow'  					=> '',
			'background_color' 			=> '',
			'opacity'	       			=> ''
		) ), $atts, $this->shortcode ) );

		$class = array( $this->shortcode );

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = 'id="' . esc_attr( $el_id ) . '"';
		}

		if ( $column_gap != '' ) {
			$class[] = $this->prefix . 'column_gap' . '_' . $column_gap;
		}

		if ( $negative_margin != '' ) {
			$class[] = $this->prefix . 'negative_margin' . '_' . $negative_margin;
		}

		if ( $shadow != '' ) {
			$class[] = $this->prefix . 'shadow' . '_' . $shadow;
		}

		if ( $layout != '' ) {
			$class[] = $this->prefix . 'layout' . '_' . $layout;
		}

		if ( $background_color != '' ) {
			if ( strpos( $background_color, '#' ) !== false ) {
				$background_color = bt_bb_column::hex2rgb( $background_color );
				if ( $opacity == '' ) {
					$opacity = 1;
				}
				$el_style .= 'background-color: rgba(' . $background_color[0] . ', ' . $background_color[1] . ', ' . $background_color[2] . ', ' . $opacity . ');';
			} else {
				$el_style .= 'background-color: ' . $background_color . ';';
			}
		}

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = 'style="' . esc_attr( $el_style ) . '"';
		}


		$style_attr = apply_filters( $this->shortcode . '_style_attr', $style_attr, $atts );

		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		$class_attr = implode( ' ', $class );

		$output = '<div ' . $id_attr . ' class="' . esc_attr( $class_attr ) . '" ' . $style_attr . '>';
			$output .= do_shortcode( $content );
		$output .= '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Row', 'pawsitive' ), 'description' => esc_html__( 'Row element', 'pawsitive' ), 'container' => 'horizontal', 'accept' => array( 'bt_bb_column' => true ), 'toggle' => true, 'auto_add' => 'bt_bb_column', 'show_settings_on_create' => false,
			'params' => array(
				array( 'param_name' => 'column_gap', 'type' => 'dropdown', 'heading' => esc_html__( 'Column gap', 'pawsitive' ), 'preview' => true,
					'value' => array(
						esc_html__( 'Default', 'pawsitive' ) 		=> '',
						esc_html__( '0px', 'pawsitive' ) 			=> '0',
						esc_html__( 'Extra small', 'pawsitive' ) 	=> 'extra_small',
						esc_html__( 'Small', 'pawsitive' ) 		=> 'small',
						esc_html__( 'Normal', 'pawsitive' ) 		=> 'normal',
						esc_html__( 'Medium', 'pawsitive' ) 		=> 'medium',
						esc_html__( 'Large', 'pawsitive' ) 		=> 'large',
						esc_html__( '5px', 'pawsitive' ) 			=> '5',
						esc_html__( '10px', 'pawsitive' ) 		=> '10',
						esc_html__( '15px', 'pawsitive' ) 		=> '15',
						esc_html__( '20px', 'pawsitive' ) 		=> '20',
						esc_html__( '25px', 'pawsitive' ) 		=> '25',
						esc_html__( '30px', 'pawsitive' ) 		=> '30',
						esc_html__( '35px', 'pawsitive' )			=> '35',
						esc_html__( '40px', 'pawsitive' ) 		=> '40',
						esc_html__( '45px', 'pawsitive' ) 		=> '45',
						esc_html__( '50px', 'pawsitive' ) 		=> '50',
						esc_html__( '60px', 'pawsitive' ) 		=> '60',
						esc_html__( '70px', 'pawsitive' ) 		=> '70',
						esc_html__( '80px', 'pawsitive' ) 		=> '80',
						esc_html__( '90px', 'pawsitive' ) 		=> '90',
						esc_html__( '100px', 'pawsitive' ) 		=> '100'
					)
				),
				array( 'param_name' => 'negative_margin', 'type' => 'dropdown', 'heading' => esc_html__( 'Negative Margin', 'pawsitive' ), 'group' => esc_html__( 'General', 'pawsitive' ), 'preview' => true,
				'value' => array(
						esc_html__( 'No margin', 'pawsitive' ) 	=> '',
						esc_html__( 'Small', 'pawsitive' ) 		=> 'small',
						esc_html__( 'Normal', 'pawsitive' ) 		=> 'normal',
						esc_html__( 'Medium', 'pawsitive' ) 		=> 'medium',
						esc_html__( 'Large', 'pawsitive' ) 		=> 'large',
						esc_html__( 'Extra Large', 'pawsitive' ) 	=> 'extralarge',
						esc_html__( '5px', 'pawsitive' ) 			=> '5',
						esc_html__( '10px', 'pawsitive' ) 		=> '10',
						esc_html__( '15px', 'pawsitive' ) 		=> '15',
						esc_html__( '20px', 'pawsitive' ) 		=> '20',
						esc_html__( '25px', 'pawsitive' ) 		=> '25',
						esc_html__( '30px', 'pawsitive' ) 		=> '30',
						esc_html__( '35px', 'pawsitive' ) 		=> '35',
						esc_html__( '40px', 'pawsitive' ) 		=> '40',
						esc_html__( '45px', 'pawsitive' ) 		=> '45',
						esc_html__( '50px', 'pawsitive' ) 		=> '50',
						esc_html__( '60px', 'pawsitive' ) 		=> '60',
						esc_html__( '70px', 'pawsitive' ) 		=> '70',
						esc_html__( '80px', 'pawsitive' ) 		=> '80',
						esc_html__( '90px', 'pawsitive' ) 		=> '90',
						esc_html__( '100px', 'pawsitive' ) 		=> '100',
						esc_html__( '110px', 'pawsitive' ) 		=> '110',
						esc_html__( '120px', 'pawsitive' ) 		=> '120',
						esc_html__( '130px', 'pawsitive' ) 		=> '130',
						esc_html__( '140px', 'pawsitive' ) 		=> '140',
						esc_html__( '150px', 'pawsitive' ) 		=> '150'
					)
				),
				array( 'param_name' => 'shadow', 'type' => 'dropdown', 'heading' => esc_html__( 'Shadow', 'pawsitive' ), 
					'value' => array(
						esc_html__( 'Default', 'pawsitive' ) 		=> '',
						esc_html__( 'Shadow', 'pawsitive' ) 		=> 'visible'
					)
				),
				array( 'param_name' => 'layout', 'type' => 'dropdown', 'heading' => esc_html__( 'Layout', 'pawsitive' ), 'group' => esc_html__( 'General', 'pawsitive' ), 'preview' => true,
				'value' => array(
						esc_html__( 'Default', 'pawsitive' ) 				=> '',
						esc_html__( 'Boxed 1200px', 'pawsitive' ) 		=> 'boxed_1200'
					)
				),
				array( 'param_name' => 'background_color', 'preview' => true, 'type' => 'colorpicker', 'heading' => esc_html__( 'Background color', 'pawsitive' ) ),
				array( 'param_name' => 'opacity', 'type' => 'textfield', 'heading' => esc_html__( 'Background color opacity (e.g. 0.4)', 'pawsitive' ) )
			)
		) );
	}

	static function hex2rgb( $hex ) {
		$hex = str_replace( '#', '', $hex );
		if ( strlen( $hex ) == 3 ) {
			$r = hexdec( substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) );
			$g = hexdec( substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) );
			$b = hexdec( substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) );
		} else {
			$r = hexdec( substr( $hex, 0, 2 ) );
			$g = hexdec( substr( $hex, 2, 2 ) );
			$b = hexdec( substr( $hex, 4, 2 ) );
		}
		$rgb = array( $r, $g, $b );
		return $rgb;
	}

}