<?php

/* examples:

https://kimmobrunfeldt.github.io/progressbar.js/

http://progressbarjs.readthedocs.io/en/latest/api/shape/

*/

class bt_bb_progress_bar_advanced extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
			'type'        					=> '',
			'percentage'        			=> '',
			'duration'     	   				=> '',
			'easing'       	 				=> '',
			'title'        					=> '',
			'title_size' 					=> '',
			'title_color_scheme' 			=> '',
			'text'        					=> '',
			'icon'							=> 'no_icon',
			'regular_icon'         			=> '',
			'progress_text'        			=> '',
			'colored_icon_color_scheme' 	=> '',
			'url'							=> '',
			'target'						=> '',
			'size'        					=> '',
			'thickness'						=> '',
			'trail_thickness'				=> '',
			'color_from' 					=> '',
			'color_to' 						=> '',
			'text_color' 					=> '',
			'trail_color'       			=> '',
			'fill_color'					=> ''
		) ), $atts, $this->shortcode ) );

		$pb_id = rand(1000, 100000);

		/**
		* Enqueue scripts and styles
		*/

		$content_elements_path			= get_template_directory_uri() . '/bold-page-builder/content_elements/bt_bb_progress_bar_advanced/';
		$content_elements_misc_path_js	= get_template_directory_uri() . '/bold-page-builder/content_elements_misc/js/';

		wp_enqueue_script( 
			'bt_bb_progressbar_advanced_js',
			$content_elements_path . 'bb_progressbar_advanced.js',
			array( 'jquery' ),
			'',
			true
		);

		wp_enqueue_script( 
			'bt_bb_progressbar_advanced',
			$content_elements_misc_path_js . 'bt_bb_progress_bar_advanced.js',
			array( 'jquery' ),
			'',
			true
		);


		$class = array( $this->shortcode );
		$class[] = 'animate-adv_progressbar';

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		if ( $size != '' ) {
			$class[] = $this->prefix . 'size' . '_' . $size;
		}

		if ( $title_size != '' ) {
			$class[] = $this->prefix . 'title_size' . '_' . $title_size;
		}
		
		$colored_icon_color_scheme_id = NULL;
		if ( is_numeric ( $colored_icon_color_scheme ) ) {
			$colored_icon_color_scheme_id = $colored_icon_color_scheme;
		} else if ( $colored_icon_color_scheme != '' ) {
			$colored_icon_color_scheme_id = bt_bb_get_color_scheme_id( $colored_icon_color_scheme );
		}
		$colored_icon_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $colored_icon_color_scheme_id - 1 );
		if ( $colored_icon_color_scheme_colors ) $el_style .= '; --progress-bar-colored-icon-primary-color:' . $colored_icon_color_scheme_colors[0] . '; --progress-bar-colored-icon-secondary-color:' . $colored_icon_color_scheme_colors[1] . ';';
		if ( $colored_icon_color_scheme != '' ) $class[] = $this->prefix . 'colored_icon_color_scheme_' .  $colored_icon_color_scheme_id;

		$title_color_scheme_id = NULL;
		if ( is_numeric ( $title_color_scheme ) ) {
			$title_color_scheme_id = $title_color_scheme;
		} else if ( $title_color_scheme != '' ) {
			$title_color_scheme_id = bt_bb_get_color_scheme_id( $title_color_scheme );
		}
		$title_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $title_color_scheme_id - 1 );
		if ( $title_color_scheme_colors ) $el_style .= '; --progress-bar-title-primary-color:' . $title_color_scheme_colors[0] . '; --progress-bar-title-secondary-color:' . $title_color_scheme_colors[1] . ';';
		if ( $title_color_scheme != '' ) $class[] = $this->prefix . 'title_color_scheme_' .  $title_color_scheme_id;

		if ( $percentage == '' ){
			$percentage = 100;
		}

		if ( $fill_color != '' ){
			if ( strpos( $fill_color, '#' ) !== false ) {
				$fill_color = $this->hex2rgba($fill_color, 1);
			}
		}

		$container				= 'container_' . $pb_id;
		$container_text			= $text;
		$container_percentage	= $percentage / 100;
		$container_duration		= ( $duration == '' ) ? '1400' : $duration;	
		$container_easing		= ( $easing == '') ? 'linear' : $easing;
		
		$container_text_color	= ( $text_color == '') ? '' : $text_color;		
		$container_color_from	= ( $color_from == '') ? '#eee' : $color_from;
		$container_color_to		= ( $color_to == '') ? '#000' : $color_to;		
		$container_trail_color	= ( $trail_color == '') ? '#eee' : $trail_color;
		$container_fill			= ( $fill_color) ? $fill_color : null;


		if ( $color_to == "" && $color_from != "") {
			$container_color_to = $container_color_from;
		}


		switch( $thickness ){
			case 'small':	$container_depth_from	= 1;	$container_depth_to		= 1;	$container_stroke_width = 1;	$container_trail_width	= 1;break;
			case 'normal':	$container_depth_from	= 2;	$container_depth_to		= 2;	$container_stroke_width = 2;	$container_trail_width	= 2;break;
			case 'medium':	$container_depth_from	= 4;	$container_depth_to		= 4;	$container_stroke_width = 4;	$container_trail_width	= 4;break;
			case 'large':	$container_depth_from	= 8;	$container_depth_to		= 8;	$container_stroke_width = 8;	$container_trail_width	= 8;break;
			case 'xlarge':	$container_depth_from	= 10;	$container_depth_to		= 10;	$container_stroke_width = 10;	$container_trail_width	= 10;break;
			default:break;
		}

		switch( $trail_thickness ){
			case 'small':	$container_trail_width	= 1;break;
			case 'normal':	$container_trail_width	= 2;break;
			case 'medium':	$container_trail_width	= 4;break;
			case 'large':	$container_trail_width	= 8;break;
			case 'xlarge':	$container_trail_width	= 10;break;
			default:break;
		}

		$link = '';

		if ( $url != '' && $url != '#' && substr( $url, 0, 4 ) != 'http' && substr( $url, 0, 5 ) != 'https' && substr( $url, 0, 6 ) != 'mailto' ) {
			$link = bt_bb_get_permalink_by_slug( $url );
		} else {
			$link = $url;
		}


		if ( $container_color_to == "" ) {
			$container_color_to = $container_color_from;
		}

		$content = do_shortcode( $content );
		$data = ' data-container="' . esc_attr( $container ) . '"';
		$data .= ' data-container-pbid="' . esc_attr( $pb_id ) . '"';
		$data .= ' data-container-type="' . esc_attr( $type ) . '"';
		$data .= ' data-container-percentage="' . esc_attr( $container_percentage ) . '"';
		$data .= ' data-container-text-color="' . esc_attr( $container_text_color ) . '"';
		$data .= ' data-container-stroke-width="' . esc_attr( $container_stroke_width ) . '"';
		$data .= ' data-container-trail-color="' . esc_attr( $container_trail_color ) . '"';
		$data .= ' data-container-trail-width="' . esc_attr( $container_trail_width ) . '"';
		$data .= ' data-container-easing="' . esc_attr( $container_easing ) . '"';
		$data .= ' data-container-color-from="' . esc_attr( $container_color_from ) . '"';
		$data .= ' data-container-depth-from="' . esc_attr( $container_depth_from ) . '"';
		$data .= ' data-container-color-to="' . esc_attr( $container_color_to ) . '"';
		$data .= ' data-container-depth-to="' . esc_attr( $container_depth_to ) . '"';
		$data .= ' data-container-fill="' . esc_attr( $container_fill ) . '"';
		$data .= ' data-container-duration="' . esc_attr( $container_duration ) . '"';
		$data .= ' data-container-text="' . esc_attr( $container_text ) . '"';

		$output = '';

		
		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}

		$class = apply_filters( $this->shortcode . '_class', $class, $atts );


		
		if ( $link != '' ) {
			$target_attr = 'target="_self"';
			if ( $target != '' ) {
				$target_attr = ' ' . 'target="' . esc_attr( $target ) . '"';
			}
			$output .= '<a href="' . esc_url( $link ) . '" ' . $target_attr.'>';
		}

			$output .= '<div' . $id_attr . ' class="' . esc_attr( implode( ' ', $class ) ) . '"' . $style_attr . ' ' . $data . '>';		
				
				// PROGRESS BAR
				$output .= '<div id="' . esc_attr( 'container_' . $pb_id ) . '" class="container">';
					
					// COLORED ICON
					if ( $icon != '' && $icon != 'no_icon' ) {
						$output .= '<div class="' . esc_attr( $this->shortcode . '_colored_icon' ) . '">';
							$output .= bt_bb_get_svg_icon_html( $icon );
						$output .= '</div>';
					}


					// REGULAR ICON
					if ( $regular_icon != '' && $icon == '' || $icon == 'no_icon'  ) {
						$regular_icon_html = bt_bb_icon::get_html( $regular_icon, '' );
						$output .= $regular_icon_html;
					}


					// PROGRESS TEXT
					if ( $progress_text != '' && $icon == 'no_icon' && $regular_icon == '' ) {
						$output .= '<div class="' . esc_attr( $this->shortcode . '_bar_text' ) . '"><span>' . $progress_text . '</span></div>';
					}

				$output .= '</div>';


				
				
				// CONTENT
				$output .= '<div class="' . esc_attr( $this->shortcode . '_content' ) . '">';
					if ( $title != '' ) {
						$output .= '<span>' . wp_kses_post( $title ) . '</span>';
					}
					if ( $container_text != '' ) {
						$output .= '<p>' . wp_kses_post( $container_text ) . '</p>';
					}
				$output .= '</div>';
				
			$output .= '</div>';

		if ( $link != '' ) {
			$output .= '</a>';
		}
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );
			
		return $output;
	}

	

	/* Convert hexdec color string to rgb(a) string */ 
	static function hex2rgba($color, $opacity = false) {
		$default = 'rgb(0,0,0)';

		// Return default if no color provided
		if ( empty($color) )
			return $default;

		// Sanitize $color if "#" is provided 
		if ($color[0] == '#' ) {
			$color = substr( $color, 1 );
		}

		// Check if color has 6 or 3 characters and get values
		if (strlen($color) == 6) {
			$hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
		} elseif ( strlen( $color ) == 3 ) {
			$hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
		} else {
			return $default;
		}

		// Convert hexadec to rgb
		$rgb =  array_map('hexdec', $hex);

		// Check if opacity is set(rgba or rgb)
		if ( $opacity ) {
			if ( abs($opacity ) > 1 )
				$opacity = 1.0;
				$output = 'rgba('.implode(",",$rgb).','.$opacity.')';
			} else {
				$output = 'rgb('.implode(",",$rgb).')';
			}
		// Return rgb(a) color string
		return $output;
	}

	function map_shortcode() {

		$color_scheme_arr = bt_bb_get_color_scheme_param_array();
		$svg_icons_arr = bt_bb_get_svg_icons_param_array();

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Advanced Progress bar', 'pawsitive' ), 'description' => esc_html__( 'Advanced Progress bar', 'pawsitive' ), 'container' => 'vertical', 'accept' => false, 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'type', 'type' => 'dropdown', 'heading' => esc_html__( 'Progress Bar Type', 'pawsitive' ), 'preview' => true,
					'value' => array(
						esc_html__( 'Semi circle', 'pawsitive' ) 		=> 'semi-circle',
						esc_html__( 'Circle', 'pawsitive' ) 			=> 'circle'
					)
				),
				array( 'param_name' => 'percentage', 'type' => 'textfield', 'heading' => esc_html__( 'Percentage', 'pawsitive' ), 'description' => esc_html__( 'Enter number from 1 to 100, without %', 'pawsitive' ), 'preview' => true ),
				array( 'param_name' => 'duration', 'type' => 'textfield', 'heading' => esc_html__( 'Animation duration', 'pawsitive' ), 'preview' => true ),
						array( 'param_name' => 'easing', 'type' => 'dropdown', 'heading' => esc_html__( 'Easing', 'pawsitive' ), 'preview' => true,
					'value' => array(
						esc_html__( 'Linear', 'pawsitive' ) 			=> 'linear',
						esc_html__( 'Ease In Out', 'pawsitive' ) 		=> 'easeInOut',
						esc_html__( 'Bounce', 'pawsitive' ) 			=> 'bounce'
					)
				),
				array( 'param_name' => 'colored_icon_color_scheme', 'type' => 'dropdown', 'group' => esc_html__( 'Design', 'pawsitive' ), 'heading' => esc_html__( 'Colored icon color scheme', 'pawsitive' ), 'value' => $color_scheme_arr ),
				array( 'param_name' => 'title', 'type' => 'textfield', 'heading' => esc_html__( 'Title', 'pawsitive' ), 'preview' => true ),
				array( 'param_name' => 'title_size', 'type' => 'dropdown', 'default' => '', 'heading' => esc_html__( 'Title size', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Small', 'pawsitive' ) 			=> 'small',
						esc_html__( 'Normal', 'pawsitive' ) 			=> '',
						esc_html__( 'Large', 'pawsitive' ) 			=> 'large'
					)
				),
				array( 'param_name' => 'title_color_scheme', 'type' => 'dropdown', 'group' => esc_html__( 'Design', 'pawsitive' ), 'heading' => esc_html__( 'Title & Icon color scheme', 'pawsitive' ), 'value' => $color_scheme_arr ),
				array( 'param_name' => 'text', 'type' => 'textarea', 'heading' => esc_html__( 'Text below the icon or percentage', 'pawsitive' ) ),

				array( 'param_name' => 'icon', 'type' => 'dropdown', 'default' => 'no_icon', 'heading' => esc_html__( 'Colored Icon', 'pawsitive' ), 'value' => $svg_icons_arr ),

				array( 'param_name' => 'regular_icon', 'type' => 'iconpicker', 'heading' => esc_html__( 'Icon', 'pawsitive' ), 'description' => esc_html__( 'If colored icon is chosen from the list, regular icon will not be displayed', 'pawsitive' ), 'preview' => true ),

				array( 'param_name' => 'progress_text', 'type' => 'textfield', 'heading' => esc_html__( 'Progress Text', 'pawsitive' ), 'preview' => true ),

				array( 'param_name' => 'url', 'type' => 'textfield', 'heading' => esc_html__( 'URL', 'pawsitive' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'URL Target', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'pawsitive' ) 	=> '_self',
						esc_html__( 'Blank (open in new tab)', 'pawsitive' ) 	=> '_blank',
					)
				),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'default' => 'normal', 'heading' => esc_html__( 'Size', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ), 'preview' => true,
					'value' => array(
						esc_html__( 'Small', 'pawsitive' ) 			=> 'small',
						esc_html__( 'Normal', 'pawsitive' ) 			=> 'normal',
						esc_html__( 'Medium', 'pawsitive' ) 			=> 'medium',
						esc_html__( 'Large', 'pawsitive' ) 			=> 'large',
						esc_html__( 'Extra large', 'pawsitive' ) 		=> 'xlarge'
					)
				),
				array( 'param_name' => 'thickness', 'type' => 'dropdown', 'heading' => esc_html__( 'Progress bar thickness', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Small', 'pawsitive' ) 			=> 'small',
						esc_html__( 'Normal', 'pawsitive' ) 			=> 'normal',
						esc_html__( 'Medium', 'pawsitive' ) 			=> 'medium',
						esc_html__( 'Large', 'pawsitive' ) 			=> 'large',
						esc_html__( 'Extra large', 'pawsitive' ) 		=> 'xlarge'
					)
				),
				array( 'param_name' => 'trail_thickness', 'type' => 'dropdown', 'heading' => esc_html__( 'Progress bar trail thickness', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Same as progress bar', 'pawsitive' ) 	=> 'progressbar',
						esc_html__( 'Small', 'pawsitive' ) 					=> 'small',
						esc_html__( 'Normal', 'pawsitive' ) 					=> 'normal',
						esc_html__( 'Medium', 'pawsitive' ) 					=> 'medium',
						esc_html__( 'Large', 'pawsitive' ) 					=> 'large',
						esc_html__( 'Extra large', 'pawsitive' ) 				=> 'xlarge'
					)
				),
				array( 'param_name' => 'color_from', 'type' => 'colorpicker', 'heading' => esc_html__( 'Starting Progress Bar Background color', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ) ),
				array( 'param_name' => 'color_to', 'type' => 'colorpicker', 'heading' => esc_html__( 'Ending Progress Bar Background color', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ) ),
				array( 'param_name' => 'text_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Text color', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ) ),
				array( 'param_name' => 'trail_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Color for lighter trail stroke underneath the actual progress path', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ) ),
				array( 'param_name' => 'fill_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Fill color', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ) )
			)
		) );
	}
}

