<?php

class bt_bb_price_list extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'supertitle'					=> '',
			'title'							=> '',
			'icon'							=> '',
			'colored_icon'         			=> 'no_icon',
			'colored_icon_color_scheme' 	=> '',
			'items'							=> '',
			'currency'						=> '',
			'position'						=> '',
			'price'							=> '',
			'image'							=> '',
			'style'  						=> '',
			'shape'     					=> '',
			'background_color' 				=> '',
			'opacity'	       				=> '',
			'color_scheme'					=> '',
			'highlight'						=> ''
		) ), $atts, $this->shortcode ) );

		$class = array( $this->shortcode );

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		if ( $background_color != '' ) {
			$background_color = bt_bb_column::hex2rgb( $background_color );
			if ( $opacity == '' ) {
				$opacity = 1;
			}
			$el_style .= 'background-color: rgba(' . $background_color[0] . ', ' . $background_color[1] . ', ' . $background_color[2] . ', ' . $opacity . ');';
			$class[] = "btHasBgColor";
		}

		$size = '';
		if ( $image != '' && is_numeric( $image ) ) {
			$post_image = get_post( $image );
			if ( $post_image == '' ) return;
			$size = " boldthemes_large_rectangle";
			$image = wp_get_attachment_image_src( $image, $size );
			$image = $image[0];
			
			$class[] = "btHasBgImage";
			$el_style .= 'background-image: url(' . $image . ')';
		}
	
		if ( $style != '' ) {
			$class[] = $this->prefix . 'style' . '_' . $style;
		}

		if ( $position != '' ) {
			$class[] = $this->prefix . 'position' . '_' . $position;
		}

		if ( $shape != '' ) {
			$class[] = $this->prefix . 'shape' . '_' . $shape;
		}

		if ( $highlight != '' ) {
			$class[] = 'btHighlight';
		}

		$color_scheme_id = NULL;
		if ( is_numeric ( $color_scheme ) ) {
			$color_scheme_id = $color_scheme;
		} else if ( $color_scheme != '' ) {
			$color_scheme_id = bt_bb_get_color_scheme_id( $color_scheme );
		}
		$color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $color_scheme_id - 1 );
		if ( $color_scheme_colors ) $el_style .= '; --price-list-primary-color:' . $color_scheme_colors[0] . '; --price-list-secondary-color:' . $color_scheme_colors[1] . ';';
		if ( $color_scheme != '' ) $class[] = $this->prefix . 'color_scheme_' .  $color_scheme_id;

		$colored_icon_color_scheme_id = NULL;
		if ( is_numeric ( $colored_icon_color_scheme ) ) {
			$colored_icon_color_scheme_id = $colored_icon_color_scheme;
		} else if ( $colored_icon_color_scheme != '' ) {
			$colored_icon_color_scheme_id = bt_bb_get_color_scheme_id( $colored_icon_color_scheme );
		}
		$colored_icon_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $colored_icon_color_scheme_id - 1 );
		if ( $colored_icon_color_scheme_colors ) $el_style .= '; --price-list-colored-icon-primary-color:' . $colored_icon_color_scheme_colors[0] . '; --price-list-colored-icon-secondary-color:' . $colored_icon_color_scheme_colors[1] . ';';
		if ( $colored_icon_color_scheme != '' ) $class[] = $this->prefix . 'colored_icon_color_scheme_' .  $colored_icon_color_scheme_id;

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		$class_attr = implode( ' ', $class );

		if ( $el_class != '' ) {
			$class_attr = $class_attr . ' ' . $el_class;
		}

		$content = do_shortcode( $content );
		$icon_html = bt_bb_icon::get_html( $icon, '' );

		
		$output = '<div' . $id_attr . ' class="' . esc_attr( $class_attr ) . '"' . $style_attr . '>';

			// CONTENT
			$output .= '<div class="' . esc_attr( $this->shortcode ) . '_content">';

				if ( $supertitle != '' ) $output .= '<div class="' . esc_attr( $this->shortcode ) . '_supertitle">' . $supertitle . '</div>';
				if ( $title != '' ) $output .= '<div class="' . esc_attr( $this->shortcode ) . '_title">' . $title . '</div>';
				
				// ICON
				if ( $icon != '' && $colored_icon == '' || $colored_icon == 'no_icon'  ) $output .= '<div class="' . esc_attr( $this->shortcode . '_box' ) . '">' . $icon_html . '</div>';

				// COLORED ICON
				if ( $colored_icon != '' && $colored_icon != 'no_icon' ) {
					$output .= '<div class="' . esc_attr( $this->shortcode . '_colored_icon' ) . '">';
						$output .= bt_bb_get_svg_icon_html( $colored_icon );
					$output .= '</div>';
				}

			$output .= '</div>';

			// LIST
			if ( $items != '' ) {
				$items_arr = preg_split( '/$\R?^/m', $items );
				$output .= '<ul>';
					foreach ( $items_arr as $item ) {
						if ( $item != '' ){
							$li_class	=	substr($item, 0, 1) == '+' ? 'included' : 'excluded';					
							$item		=	substr($item, 0, 1) == '+' ? ltrim($item, '+')   :  $item;

							$output .= '<li class="' .  esc_attr( $li_class ) . '">' .  wp_kses_post( $item ) . '</li>';
						}
					}
				$output .= '</ul>';
			}

			// PRICE
			$output .= '<div class="' . esc_attr( $this->shortcode . '_price' ) . '">';
				$output .= '<span class="' . esc_attr( $this->shortcode . '_currency' ) . '">' . $currency . '</span>';
				$output .= '<div class="' . esc_attr( $this->shortcode . '_amount' ) . '">' . do_shortcode( '[bt_bb_counter number="' . $price . '" ignore_fe_editor="true"]' ) . '</div>';
			$output .= '</div>';

			// CONTENT
			if ( $content != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_content_inner' ) . '">' . ( $content ) . '</div>';

		$output .= '</div>';

		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {
		
		$color_scheme_arr = bt_bb_get_color_scheme_param_array();
		$svg_icons_arr = bt_bb_get_svg_icons_param_array();
		
		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Price List', 'pawsitive' ), 'description' => esc_html__( 'List of items with total price', 'pawsitive' ), 'container' => 'vertical', 'accept' => array( 'bt_bb_button' => true, 'bt_bb_separator' => true, 'bt_bb_text' => true, 'bt_bb_headline' => true ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'supertitle', 'type' => 'textfield', 'heading' => esc_html__( 'Supertitle', 'pawsitive' ) ),
				array( 'param_name' => 'title', 'type' => 'textfield', 'heading' => esc_html__( 'Title', 'pawsitive' ), 'preview' => true ),
				array( 'param_name' => 'icon', 'type' => 'iconpicker', 'heading' => esc_html__( 'Icon', 'pawsitive' ), 'preview' => true ),
				array( 'param_name' => 'colored_icon', 'type' => 'dropdown', 'default' => 'no_icon', 'heading' => esc_html__( 'Colored Icon', 'pawsitive' ), 'description' => esc_html__( 'If colored icon is chosen from the list, regular icon will not be displayed', 'pawsitive' ), 'value' => $svg_icons_arr ),
				array( 'param_name' => 'colored_icon_color_scheme', 'type' => 'dropdown', 'group' => esc_html__( 'Design', 'pawsitive' ), 'heading' => esc_html__( 'Colored icon color scheme', 'pawsitive' ), 'value' => $color_scheme_arr ),
				
				array( 'param_name' => 'items', 'type' => 'textarea', 'heading' => esc_html__( 'Items', 'pawsitive' ), 'description' => __( 'Type sentences separated by new line. In order to show what is included in price add + before text (ex. +Free drinks).', 'pawsitive' ) ),
				array( 'param_name' => 'currency', 'type' => 'textfield', 'heading' => esc_html__( 'Currency', 'pawsitive' ), 'description' => __( 'Currency will display next to price value - on the left side.', 'pawsitive' ) ),
				array( 'param_name' => 'position', 'type' => 'dropdown', 'heading' => esc_html__( 'Currency position', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Left', 'pawsitive' ) 			=> '',
						esc_html__( 'Right', 'pawsitive' ) 			=> 'right'
					)
				),
				array( 'param_name' => 'price', 'type' => 'textfield', 'heading' => esc_html__( 'Price', 'pawsitive' ) ),
				array( 'param_name' => 'image', 'type' => 'attach_image', 'group' => esc_html__( 'Design', 'pawsitive' ), 'heading' => esc_html__( 'Background image', 'pawsitive' ), 'preview' => true ),
				array( 'param_name' => 'style', 'type' => 'dropdown', 'group' => esc_html__( 'Design', 'pawsitive' ), 'heading' => esc_html__( 'Style', 'pawsitive' ), 'preview' => true,
					'value' => array(
						esc_html__( 'Filled', 'pawsitive' ) 			=> '',
						esc_html__( 'Borderless', 'pawsitive' ) 		=> 'borderless',
						esc_html__( 'Outline', 'pawsitive' ) 			=> 'outline'
					) 
				),
				array( 'param_name' => 'shape', 'type' => 'dropdown', 'group' => esc_html__( 'Design', 'pawsitive' ), 'heading' => esc_html__( 'Shape', 'pawsitive' ), 
					'value' => array(
						esc_html__( 'Inherit', 'pawsitive' ) 			=> '',
						esc_html__( 'Square', 'pawsitive' ) 			=> 'square',
						esc_html__( 'Soft rounded', 'pawsitive' )		=> 'soft-rounded'
					)
				),
				array( 'param_name' => 'background_color', 'preview' => true, 'group' => esc_html__( 'Design', 'pawsitive' ), 'type' => 'colorpicker', 'heading' => esc_html__( 'Background color', 'pawsitive' ) ),
				array( 'param_name' => 'opacity', 'type' => 'textfield', 'group' => esc_html__( 'Design', 'pawsitive' ), 'heading' => esc_html__( 'Background color opacity (e.g. 0.4)', 'pawsitive' ) ),
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'group' => esc_html__( 'Design', 'pawsitive' ), 'heading' => esc_html__( 'Color scheme', 'pawsitive' ), 'value' => $color_scheme_arr, 'preview' => true ),
				array( 'param_name' => 'highlight', 'type' => 'dropdown', 'group' => esc_html__( 'Design', 'pawsitive' ), 'heading' => esc_html__( 'Highlight', 'pawsitive' ), 'preview' => true,
					'value' => array(
						esc_html__( 'No', 'pawsitive' ) 				=> '',
						esc_html__( 'Yes', 'pawsitive' ) 				=> 'highlight'
					) 
				),
			)
		) );
	}

	static function hex2rgb( $hex ) {
		$hex = str_replace( '#', '', $hex );
		if ( strlen( $hex ) == 3 ) {
			$r = hexdec( substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) );
			$g = hexdec( substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) );
			$b = hexdec( substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) );
		} else {
			$r = hexdec( substr( $hex, 0, 2 ) );
			$g = hexdec( substr( $hex, 2, 2 ) );
			$b = hexdec( substr( $hex, 4, 2 ) );
		}
		$rgb = array( $r, $g, $b );
		return $rgb;
	}
}