<?php

class bt_bb_masonry_post_grid extends BT_BB_Element {

	function __construct() {
		parent::__construct();
		add_action( 'wp_ajax_bt_bb_get_grid', array( __CLASS__, 'bt_bb_get_grid_callback' ) );
		add_action( 'wp_ajax_nopriv_bt_bb_get_grid', array( __CLASS__, 'bt_bb_get_grid_callback' ) );
	}

	static function bt_bb_get_grid_callback() {	
		check_ajax_referer( 'bt-bb-masonry-post-grid-nonce', 'bt-nonce' );
		bt_bb_masonry_post_grid::dump_grid( intval( $_POST['number'] ), intval( $_POST['offset'] ), $_POST['category'], $_POST['show'] );
		die();
	}

	
	static function dump_grid( $number, $offset, $category, $show ) {

		$show = unserialize( urldecode( $show ) );

		$date_design_format         = 'j M';
		$date_design_format_day     = 'j';
		$date_design_format_month   = 'M';


		$output = '';

		$posts = bt_bb_get_posts( $number, $offset, $category );

		foreach( $posts as $item ) {
			$post_thumbnail_id = get_post_thumbnail_id( $item['ID'] ); 
			$img = wp_get_attachment_image_src( $post_thumbnail_id, 'large' );
			$img_src = $img[0];
			$hw = 0;
			if ( $img_src != '' ) {
				$hw = $img[2] / $img[1];
			}
			$alt = get_post_meta( $post_thumbnail_id, '_wp_attachment_image_alt', true );
			$alt = $alt != '' ? $alt : $item['title'];
			


			$output .= '<div class="bt_bb_grid_item" data-hw="' . esc_attr( $hw ) . '" data-src="' . esc_url( $img_src ) . '" data-alt="' . esc_attr( $alt ) . '"><div class="bt_bb_grid_item_inner">';
				

				if ( $show['date'] ) {

					if ( $date_design_format_day != '' && $date_design_format_month != '' ) {
						
						$output .= '<div class="bt_bb_grid_item_date_box">';

							if ( $date_design_format_day != '' && $date_design_format_month != '' ){
								
								// DAY NUMBER
								$output .= '<span class="bt_bb_grid_item_date_day">';
									$output .= get_the_date( $date_design_format_day, $item['ID'] );
								$output .= '</span>';
								
								// MONTH
								$output .= '<span class="bt_bb_grid_item_date_month">';
									$output .= get_the_date( $date_design_format_month, $item['ID'] );
								$output .= '</span>';
							
							}

						$output .= '</div>';
					
					}
				}
				
				// IMAGE
				$output .= '<div class="bt_bb_grid_item_post_thumbnail">';
					$output .= '<a href="' . esc_url( $item['permalink'] ) . '" title="' . esc_attr( $item['title'] ) . '"></a>';
				$output .= '</div>';

				
				// CONTENT
				$output .= '<div class="bt_bb_grid_item_post_content">';

					// CATEGORY, COMMENTS, AUTHOR
					if ( $show['category'] || $show['author'] || $show['comments'] ) {
						
						$meta_output = '<div class="bt_bb_grid_item_meta">';

							if ( $show['author'] ) {
								$meta_output .= '<span class="bt_bb_grid_item_item_author">';
									$meta_output .= esc_html__( 'by', 'pawsitive' ) . ' ' . $item['author'];
								$meta_output .= '</span>';
							}

							if ( $show['comments'] && $item['comments'] != '' ) {
								$meta_output .= '<span class="bt_bb_grid_item_item_comments">';
									$meta_output .= $item['comments'];
								$meta_output .= '</span>';
							}

							if ( $show['category'] ) {
								$meta_output .= '<span class="bt_bb_grid_item_category">';
									$meta_output .= $item['category_list'];
								$meta_output .= '</span>';
							}
				
						$meta_output .= '</div>';
						$output .= $meta_output;
					}

					// TITLE
					$output .= '<h5 class="bt_bb_grid_item_post_title"><a href="' . esc_url( $item['permalink'] ) . '" title="' . esc_attr( $item['title'] ) . '">' . $item['title'] . '</a></h5>';


					// SHARE
					if ( $show['share'] ) {
						$output .= '<div class="bt_bb_grid_item_post_share">' . $item['share'] . '</div>';
					}


				$output .= '</div></div>';
			$output .= '</div>';
		}
		
		$allowed = array(
			'a' => array(
				'class'       => true,
				'data-ico-fa' => true,
				'href'        => true,
				'rel'         => true,
				'title'       => true,
				'target'      => true,
			),
			'div' => array(
				'class'    => true,
				'data-hw'  => true,
				'data-src' => true,
				'data-alt' => true,
				'style'    => true,
			),
			'span' => array(
				'class' => true,
			),
			'img' => array(
				'src' => true,
				'alt' => true,
			),
			'h1' => array(
				
			),
			'h2' => array(
				
			),
			'h3' => array(
				
			),
			'h4' => array(
				
			),
			'h5' => array(
				'class' => true,
			),
			'h6' => array(
				
			),
			'ul' => array(
				'class' => true,
			),
			'li' => array(
				
			)
		);
		
		echo wp_kses( $output, $allowed );
	}

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'number'          => '',
			'auto_loading'    => '',
			'columns'         => '',
			'gap'             => '',
			'category'        => '',
			'category_filter' => '',
			'show_category'   => '',
			'show_date'       => '',
			'show_author'     => '',
			'show_comments'   => '',
			'show_share'      => '',
			'shape'			  =>''
		) ), $atts, $this->shortcode ) );

		wp_enqueue_script( 'jquery-masonry' );

		$content_elements_path = get_template_directory_uri() . '/bold-page-builder/content_elements/bt_bb_masonry_post_grid/';

		wp_enqueue_script( 
			'bt_bb_post_grid',
			$content_elements_path . 'bt_bb_post_grid.js',
			array( 'jquery' ),
			'',
			true
		);
		
		wp_localize_script( 'bt_bb_post_grid', 'ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );

		$class = array( $this->shortcode, 'bt_bb_grid_container' );

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}	

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}

		if ( $columns != '' ) {
			$class[] = $this->prefix . 'columns' . '_' . $columns;
		}
		
		if ( $gap != '' ) {
			$class[] = $this->prefix . 'gap' . '_' . $gap;
		}

		if ( $shape != '' ) {
			$class[] = $this->prefix . 'shape' . '_' . $shape;
		}
		
		if ( $number > 1000 || $number == '' ) {
			$number = 1000;
		} else if ( $number < 1 ) {
			$number = 1;
		}

		$show = array( 'category' => false, 'author' => false, 'date' => false, 'comments' => false, 'share' => false );
		if ( $show_category == 'show_category' ) {
			$show['category'] = true;
		}
		if ( $show_author == 'show_author' ) {
			$show['author'] = true;
		}
		if ( $show_comments == 'show_comments' ) {
			$show['comments'] = true;
		}
		if ( $show_share == 'show_share' ) {
			$show['share'] = true;
		}

		if ( $show_date == 'show_date' ) {
			$show['date'] = true;
		}

		$output = '';
		
		if ( $category_filter == 'yes' ) {
			$cat_arr = get_categories();
			
			$cats = array();
			if ( $category != '' ) {
				$cat_slug_arr = explode( ',', $category );
				
				$cat_id_arr = get_terms( array( 'taxonomy' => 'category',  'fields' => 'ids' , 'slug' => $cat_slug_arr)  );
				foreach ( $cat_arr as $cat ) {					
					if ( in_array( $cat->slug, $cat_slug_arr ) || in_array( $cat->parent, $cat_id_arr ) ) {
						$cats[] = $cat;
					}
				}
			} else {
				$cats = $cat_arr;
			}
			$output .= '<div class="bt_bb_post_grid_filter">';
				$output .= '<span class="bt_bb_post_grid_filter_item active" data-category="">' . esc_html__( 'All', 'pawsitive' ) . '</span>';
				foreach ( $cats as $cat ) {
					$output .= '<span class="bt_bb_post_grid_filter_item" data-category="' . esc_attr( $cat->slug ) . '">' . $cat->name . '</span>';
				}
			$output .= '</div>';
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );

		$output .= '<div class="bt_bb_masonry_post_grid_content bt_bb_grid_hide" data-bt-nonce="' . esc_attr( wp_create_nonce( 'bt-bb-masonry-post-grid-nonce' ) ) . '" data-number="' . esc_attr( $number ) . '" data-category="' . esc_attr( $category ) . '" data-show="' . esc_attr( urlencode( serialize( $show ) ) ) . '" data-auto-loading="' . esc_attr( $auto_loading ) . '"><div class="bt_bb_grid_sizer"></div></div>';

		$output .= '<div class="bt_bb_post_grid_loader"></div>';

		$output = '<div' . $id_attr . ' class="' . esc_attr( implode( ' ', $class ) ) . '"' . $style_attr . ' data-columns="' . esc_attr( $columns ) . '">' . $output . '</div>';

		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Masonry Post Grid', 'pawsitive' ), 'description' => esc_html__( 'Masonry grid with posts', 'pawsitive' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'number', 'type' => 'textfield', 'heading' => esc_html__( 'Number of items', 'pawsitive' ), 'description' => esc_html__( 'Enter number of items or leave empty to show all (up to 1000)', 'pawsitive' ), 'preview' => true ),
				array( 'param_name' => 'auto_loading', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'pawsitive' ) => 'auto_loading' ), 'heading' => esc_html__( 'Load more items on scroll', 'pawsitive' ), 'preview' => true
				),
				array( 'param_name' => 'columns', 'type' => 'dropdown', 'heading' => esc_html__( 'Columns', 'pawsitive' ), 'preview' => true,
					'value' => array(
						esc_html__( '1', 'pawsitive' ) => '1',
						esc_html__( '2', 'pawsitive' ) => '2',
						esc_html__( '3', 'pawsitive' ) => '3',
						esc_html__( '4', 'pawsitive' ) => '4',
						esc_html__( '5', 'pawsitive' ) => '5',
						esc_html__( '6', 'pawsitive' ) => '6'
					)
				),
				array( 'param_name' => 'gap', 'type' => 'dropdown', 'heading' => esc_html__( 'Gap', 'pawsitive' ),
					'value' => array(
						esc_html__( 'No gap', 'pawsitive' ) 	=> 'no_gap',
						esc_html__( 'Small', 'pawsitive' ) 	=> 'small',
						esc_html__( 'Normal', 'pawsitive' ) 	=> 'normal',
						esc_html__( 'Large', 'pawsitive' ) 	=> 'large'
					)
				),
				array( 'param_name' => 'category', 'type' => 'textfield', 'heading' => esc_html__( 'Category', 'pawsitive' ), 'description' => esc_html__( 'Enter category slug or leave empty to show all', 'pawsitive' ), 'preview' => true ),
				array( 'param_name' => 'category_filter', 'type' => 'dropdown', 'heading' => esc_html__( 'Category filter', 'pawsitive' ),
					'value' => array(
						esc_html__( 'No', 'pawsitive' ) 		=> 'no',
						esc_html__( 'Yes', 'pawsitive' ) 		=> 'yes'
					)
				),
				array( 'param_name' => 'show_category', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'pawsitive' ) => 'show_category' ), 'heading' => esc_html__( 'Show category', 'pawsitive' ), 'preview' => true
				),
				array( 'param_name' => 'show_date', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'pawsitive' ) => 'show_date' ), 'heading' => esc_html__( 'Show date', 'pawsitive' ), 'preview' => true
				),
				array( 'param_name' => 'show_author', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'pawsitive' ) => 'show_author' ), 'heading' => esc_html__( 'Show author', 'pawsitive' ), 'preview' => true
				),
				array( 'param_name' => 'show_comments', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'pawsitive' ) => 'show_comments' ), 'heading' => esc_html__( 'Show number of comments', 'pawsitive' ), 'preview' => true
				),
				array( 'param_name' => 'show_share', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'pawsitive' ) => 'show_share' ), 'heading' => esc_html__( 'Show share icons', 'pawsitive' ), 'preview' => true 
				),
				array( 'param_name' => 'shape', 'type' => 'dropdown', 'default' => '', 'heading' => esc_html__( 'Shape', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Inherit', 'pawsitive' ) 		=> '',
						esc_html__( 'Square', 'pawsitive' ) 		=> 'square',
						esc_html__( 'Rounded', 'pawsitive' ) 		=> 'rounded'
					)
				)
			)
		) );
	} 
}