<?php

class bt_bb_latest_posts extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'rows'            	=> '',
			'columns'         	=> '',
			'gap'             	=> '',
			'category'        	=> '',
			'target'          	=> '',
			'image_shape'     	=> '',
			'show_category'   	=> '',
			'show_date'       	=> '',
			'show_author'     	=> '',
			'show_comments'   	=> '',
			'show_excerpt'    	=> '',
			'lazy_load'  		=> 'no',
			'style'				=> ''
		) ), $atts, $this->shortcode ) );
		
		$class = array( $this->shortcode );
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}	
		
		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}
		
		if ( $columns != '' ) {
			$class[] = $this->prefix . 'columns' . '_' . $columns;
		}
		
		if ( $gap != '' ) {
			$class[] = $this->prefix . 'gap' . '_' . $gap;
		}


		$date_design_format         = 'j M';
		$date_design_format_day     = 'j';
		$date_design_format_month   = 'M';


		if ( $style != '' ) {
			$class[] = $this->prefix . 'style' . '_' . $style;
		}
		
		if ( $image_shape != '' ) {
			$class[] = $this->prefix . 'image_shape' . '_' . $image_shape;
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		
		$number = $rows * $columns;
		
		$posts = bt_bb_get_posts( $number, 0, $category );
		
		$output = '';

		foreach( $posts as $post_item ) {

			$output .= '<div class="' . esc_attr( $this->shortcode ) . '_item">';
				$output .= '<div class="' . esc_attr( $this->shortcode ) . '_item_inner">';
					$post_thumbnail_id = get_post_thumbnail_id( $post_item['ID'] );

					if ( $post_thumbnail_id != '' ) {
						$img = wp_get_attachment_image_src( $post_thumbnail_id, $size = 'medium' );
						if ( $lazy_load == 'yes' ) {
							$img_src = BT_BB_Root::$path . 'img/blank.gif';
							$img_class = 'btLazyLoadImage';
							$data_img = ' data-image_src="' . esc_attr( $img[0] ) . '"';
						} else {
							$img_src = $img[0];
							$img_class = '';
							$data_img = '';
						}
						
						
						$output .= '<div class="' . esc_attr( $this->shortcode ) . '_item_media">';
							// IMAGE
							$output .= '<div class="' . esc_attr( $this->shortcode ) . '_item_image">';
								$output .= '<a href="' . esc_url( $post_item['permalink'] ) . '" target="' . esc_attr( $target ) . '">';
									$output .= '<img src="' . esc_url( $img_src ) . '" alt="' . esc_attr( $post_item['title'] ) . '" title="' . esc_attr( $post_item['title'] ) . '" class="' . esc_attr( $img_class ) . '" ' . $data_img .  '>';
								$output .= '</a>';
												
							$output .= '</div>';


							// DATE
							if ( $show_date == 'show_date' ) {
								$output .= '<span class="' . esc_attr( $this->shortcode ) . '_item_date">';
									
									if ( $date_design_format_day != '' && $date_design_format_month != '' ) {
										$output .= '<span class="' . esc_attr( $this->shortcode ) . '_item_date_day">';
											$output .= get_the_date( $date_design_format_day, $post_item['ID'] );
										$output .= '</span>';

										$output .= '<span class="' . esc_attr( $this->shortcode ) . '_item_date_month">';
											$output .= get_the_date( $date_design_format_month, $post_item['ID'] );
										$output .= '</span>';
									} else {
										$output .= get_the_date( $date_design_format, $post_item['ID'] );
									}  

								$output .= '</span>';
							}

						$output .= '</div>';
					}

					$output .= '<div class="' . esc_attr( $this->shortcode ) . '_item_content">';

						if ( $show_category == 'show_category' || $show_author == 'show_author' || $show_comments == 'show_comments' ) {
					
							$meta_output = '<div class="' . esc_attr( $this->shortcode ) . '_item_meta">';

								if ( $show_author == 'show_author' ) {
									$meta_output .= '<span class="' . esc_attr( $this->shortcode ) . '_item_author">';
										$meta_output .= esc_html__( 'by', 'pawsitive' ) . ' ' . $post_item['author'];
									$meta_output .= '</span>';
								}

								if ( $show_comments == 'show_comments' && $post_item['comments'] != '' ) {
									$meta_output .= '<span class="' . esc_attr( $this->shortcode ) . '_item_comments">';
										$meta_output .= $post_item['comments'];
									$meta_output .= '</span>';
								}

								if ( $show_category == 'show_category' ) {
									$meta_output .= '<div class="' . esc_attr( $this->shortcode ) . '_item_category">';
										$meta_output .= $post_item['category_list'];
									$meta_output .= '</div>';
								}
					
							$meta_output .= '</div>';
			
							$output .= $meta_output;
			
						}

						$output .= '<h5 class="' . esc_attr( $this->shortcode ) . '_item_title">';
							$output .= '<a href="' . esc_url( $post_item['permalink'] ) . '" target="' . esc_attr( $target ) . '">' . $post_item['title'] . '</a>';
						$output .= '</h5>';
						
						if ( $show_excerpt == 'show_excerpt' ) {
							$output .= '<div class="' . esc_attr( $this->shortcode ) . '_item_excerpt">';
								$output .= $post_item['excerpt'];
							$output .= '</div>';
						}
					$output .= '</div>';
				$output .= '</div>';
				
			$output .= '</div>';
		}

		$output = '<div' . $id_attr . ' class="' . esc_attr( implode( ' ', $class ) ) . '"' . $style_attr . '>' . $output . '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Latest Posts', 'pawsitive' ), 'description' => esc_html__( 'List of latest posts', 'pawsitive' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'rows', 'type' => 'textfield', 'value' => '1', 'heading' => esc_html__( 'Rows', 'pawsitive' ), 'preview' => true ),
				array( 'param_name' => 'columns', 'type' => 'dropdown', 'value' => '3', 'heading' => esc_html__( 'Columns', 'pawsitive' ), 'preview' => true,
					'value' => array(
						esc_html__( '1', 'pawsitive' ) 	=> '1',
						esc_html__( '2', 'pawsitive' ) 	=> '2',
						esc_html__( '3', 'pawsitive' ) 	=> '3',
						esc_html__( '4', 'pawsitive' ) 	=> '4',
						esc_html__( '6', 'pawsitive' ) 	=> '6'
					)
				),
				array( 'param_name' => 'gap', 'type' => 'dropdown', 'default' => 'normal', 'heading' => esc_html__( 'Gap', 'pawsitive' ), 'preview' => true,
					'value' => array(
						esc_html__( 'No gap', 'pawsitive' ) 	=> 'no_gap',
						esc_html__( 'Small', 'pawsitive' ) 	=> 'small',
						esc_html__( 'Normal', 'pawsitive' ) 	=> 'normal',
						esc_html__( 'Large', 'pawsitive' ) 	=> 'large'
					)
				),				
				array( 'param_name' => 'category', 'type' => 'textfield', 'heading' => esc_html__( 'Category', 'pawsitive' ), 'description' => esc_html__( 'Enter category slug or leave empty to show all', 'pawsitive' ), 'preview' => true ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'pawsitive' ) => '_self',
						esc_html__( 'Blank (open in new tab)', 'pawsitive' ) => '_blank',
					)
				),
				array( 'param_name' => 'image_shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Inherit', 'pawsitive' ) 	=> '',
						esc_html__( 'Square', 'pawsitive' ) 	=> 'square',
						esc_html__( 'Rounded', 'pawsitive' ) 	=> 'rounded'
					)
				),
				array( 'param_name' => 'show_category', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'pawsitive' ) => 'show_category' ), 'heading' => esc_html__( 'Show category', 'pawsitive' ), 'preview' => true
				),
				array( 'param_name' => 'show_date', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'pawsitive' ) => 'show_date' ), 'heading' => esc_html__( 'Show date', 'pawsitive' ), 'preview' => true
				),
				array( 'param_name' => 'show_author', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'pawsitive' ) => 'show_author' ), 'heading' => esc_html__( 'Show author', 'pawsitive' ), 'preview' => true
				),
				array( 'param_name' => 'show_comments', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'pawsitive' ) => 'show_comments' ), 'heading' => esc_html__( 'Show number of comments', 'pawsitive' ), 'preview' => true
				),
				array( 'param_name' => 'show_excerpt', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'pawsitive' ) => 'show_excerpt' ), 'heading' => esc_html__( 'Show excerpt', 'pawsitive' ), 'preview' => true
				),
				array( 'param_name' => 'lazy_load', 'type' => 'dropdown', 'default' => 'yes', 'heading' => esc_html__( 'Lazy load images', 'pawsitive' ),
					'value' => array(
						esc_html__( 'No', 'pawsitive' ) 		=> 'no',
						esc_html__( 'Yes', 'pawsitive' ) 		=> 'yes'
					)
				),
				array( 'param_name' => 'style', 'type' => 'dropdown', 'heading' => esc_html__( 'Style', 'pawsitive' ), 
					'value' => array(
						esc_html__( 'Borderless', 'pawsitive' ) 			=> '',
						esc_html__( 'Outline', 'pawsitive' ) 				=> 'outline'
					)
				)
			)
		) );
	} 
}