<?php

class bt_bb_image extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'image'  							=> '',
			'size'   							=> '',
			'shape'  							=> '',
			'lazy_load'  						=> 'no',
			'image_height'  					=> '',
			'align'  							=> '',
			'caption'    						=> '',
			'url'    							=> '',
			'target' 							=> '',
			'hover_style'  						=> '',
			'content_display'  					=> '',
			'content_background_color' 			=> '',
			'content_background_opacity'	    => '',
			'content_align'						=> ''
		) ), $atts, $this->shortcode ) );
		
		$class = array( $this->shortcode );
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}
		
		if ( $hover_style == 'scroll' ) {
			$el_id = 'bt_bb_random_id_' . rand();
		}

		$style_attr = '';
		
		if ( $image_height != '' ) {
			$el_style .= 'height:' . $image_height . '; overflow: hidden;';
		}
		
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}	
		
		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		
		if ( $shape != '' ) {
			$class[] = $this->prefix . 'shape' . '_' . $shape;
		}
		
		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'align',
				'value' => $align
			)
		);
		
		if ( $hover_style != '' ) {
			$class[] = $this->prefix . 'hover_style' . '_' . $hover_style;
		}
		
		if ( $content_display != '' ) {
			$class[] = $this->prefix . 'content_display' . '_' . $content_display;
		}

		if ( $content_align != '' ) {
			$class[] = $this->prefix . 'content_align' . '_' . $content_align;
		}
		

		$alt = $caption;
		$title = $caption;
			
		if ( $image != '' && is_numeric( $image ) ) {
			$post_image = get_post( $image );
			if ( $post_image == '' ) return;
			
			if ( $alt == '' ) {
				$alt = get_post_meta($post_image->ID, '_wp_attachment_image_alt', true);
			}
			if ( $alt == '' ) {
				$alt = $post_image->post_excerpt;
			}
			if ( $title == '' ) {
				$title = $post_image->post_title;
			}
			
			$image = wp_get_attachment_image_src( $image, $size );
			$image = isset($image[0]) ? $image[0] : '';
			if ( $alt == '' ) {
				$alt = $image;
			}
		}
		
		if ( $title != '' ) {
			$title = ' title="' . esc_attr( $title ) . '"';	
		}
		$content = do_shortcode( $content );
		
		if ( $content != '' ) {
			$class[] = $this->prefix . 'content_exists';
		}
		
		$output = '';
		
		if ( ! empty( $image ) ) {
			if ( $lazy_load == 'yes' ) {
				$output .= '<img src = "' . BT_BB_Root::$path . 'img/blank.gif" data-image_src="' . esc_url( $image ) . '"' . $title . ' alt="' . esc_attr( $alt ) . '" class="btLazyLoadImage">';
			} else {
				$output .= '<img src="' . esc_url( $image ) . '"' . $title . ' alt="' . esc_attr( $alt ) . '">';
			}
		}
		
		$link = bt_bb_get_url( $url );
		
		if ( ! empty( $link ) ) {
			$output = '<a href="' . esc_url( $link ) . '"  target="' . esc_attr( $target ) . '"' . $title . '>' . $output . '</a>';
		} else {
			$output = '<span>' . $output . '</span>';
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		
		$output = '<div' . $id_attr . ' class="' . esc_attr( implode( ' ', $class ) ) . '"' . $style_attr . ' data-bt-override-class="' . htmlspecialchars( json_encode( $data_override_class, JSON_FORCE_OBJECT ), ENT_QUOTES, 'UTF-8' ) . '">' . $output ;
		if ( $content != '' ) {
			$content_background_style = '';
			if ( $content_background_color != '' ) {
				if ( strpos( $content_background_color, '#' ) !== false ) {
					$content_background_color = bt_bb_image::hex2rgb( $content_background_color );
					if ( $content_background_opacity == '' ) {
						$content_background_opacity = 1;
					}
					$content_background_style .= ' style="background-color: rgba(' . $content_background_color[0] . ', ' . $content_background_color[1] . ', ' . $content_background_color[2] . ', ' . $content_background_opacity . ');"';
				}else{
					$content_background_style .= ' style="background-color:' . $content_background_color . ';"';
				}
			}
			$output .= '<div class="bt_bb_image_content"' . $content_background_style . '><div class="bt_bb_image_content_flex"><div class="bt_bb_image_content_inner">' . $content . '</div></div></div>';
		}
		$output .= '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );
		
		return $output;

	}

	function map_shortcode() {
		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Image', 'pawsitive' ), 'description' => esc_html__( 'Single image', 'pawsitive' ), 'container' => 'vertical', 'accept' => array( 'bt_bb_button' => true, 'bt_bb_icon' => true, 'bt_bb_text' => true, 'bt_bb_headline' => true, 'bt_bb_floating_image' => true, 'bt_bb_separator' => true ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'image', 'type' => 'attach_image', 'heading' => esc_html__( 'Image', 'pawsitive' ), 'preview' => true ),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'heading' => esc_html__( 'Size', 'pawsitive' ), 'preview' => true,
					'value' => bt_bb_get_image_sizes()
				),
				array( 'param_name' => 'image_height', 'type' => 'textfield', 'heading' => esc_html__( 'Image height', 'pawsitive' )),
				array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Square', 'pawsitive' ) 		=> 'square',
						esc_html__( 'Soft Rounded', 'pawsitive' ) => 'soft-rounded',
						esc_html__( 'Hard Rounded', 'pawsitive' ) => 'hard-rounded'
					)
				),
				array( 'param_name' => 'lazy_load', 'type' => 'dropdown', 'default' => 'yes', 'heading' => esc_html__( 'Lazy load this image', 'pawsitive' ),
					'value' => array(
						esc_html__( 'No', 'pawsitive' ) 	=> 'no',
						esc_html__( 'Yes', 'pawsitive' ) 	=> 'yes'
					)
				),
				array( 'param_name' => 'align', 'type' => 'dropdown', 'heading' => esc_html__( 'Alignment', 'pawsitive' ), 'responsive_override' => true,
					'value' => array(
						esc_html__( 'Inherit', 'pawsitive' ) 	=> 'inherit',
						esc_html__( 'Left', 'pawsitive' ) 	=> 'left',
						esc_html__( 'Right', 'pawsitive' ) 	=> 'right'
					)
				),
				array( 'param_name' => 'caption', 'type' => 'textfield', 'heading' => esc_html__( 'Caption', 'pawsitive' ) ),
				array( 'param_name' => 'url', 'type' => 'textfield', 'heading' => esc_html__( 'URL', 'pawsitive' ), 'group' => esc_html__( 'URL', 'pawsitive' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'pawsitive' ), 'group' => esc_html__( 'URL', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'pawsitive' ) => '_self',
						esc_html__( 'Blank (open in new tab)', 'pawsitive' ) => '_blank'
					)
				),
				array( 'param_name' => 'hover_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Mouse hover style', 'pawsitive' ), 'group' => esc_html__( 'URL', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Simple', 'pawsitive' ) 					=> 'simple',
						esc_html__( 'Rotate', 'pawsitive' ) 					=> 'rotate',
						esc_html__( 'Flip', 'pawsitive' ) 					=> 'flip',
						esc_html__( 'Zoom in', 'pawsitive' ) 					=> 'zoom-in',
						esc_html__( 'To grayscale', 'pawsitive' ) 			=> 'to-grayscale',
						esc_html__( 'From grayscale', 'pawsitive' ) 			=> 'from-grayscale',
						esc_html__( 'Zoom in to grayscale', 'pawsitive' ) 	=> 'zoom-in-to-grayscale',
						esc_html__( 'Zoom in from grayscale', 'pawsitive' ) 	=> 'zoom-in-from-grayscale',
						esc_html__( 'Scroll', 'pawsitive' ) 					=> 'scroll'
					)
				),
				array( 'param_name' => 'content_display', 'type' => 'dropdown', 'heading' => esc_html__( 'Show content', 'pawsitive' ), 'description' => esc_html__( 'Add selected elements and show them over the image', 'pawsitive' ), 'group' => esc_html__( 'Content', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Always', 'pawsitive' ) => 'always',
						esc_html__( 'Show on hover', 'pawsitive' ) => 'show-on-hover',
						esc_html__( 'Hide on hover', 'pawsitive' ) => 'hide-on-hover'
					)
				),
				array( 'param_name' => 'content_background_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Content background color', 'pawsitive' ), 'group' => esc_html__( 'Content', 'pawsitive' ) ),
				array( 'param_name' => 'content_background_opacity', 'type' => 'textfield', 'heading' => esc_html__( 'Content background opacity (deprecated)', 'pawsitive' ), 'group' => esc_html__( 'Content', 'pawsitive' ) ),
				array( 'param_name' => 'content_align', 'type' => 'dropdown', 'heading' => esc_html__( 'Content Alignment', 'pawsitive' ), 'group' => esc_html__( 'Content', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Middle', 'pawsitive' ) 	=> 'middle',
						esc_html__( 'Top', 'pawsitive' ) 		=> 'top',						
						esc_html__( 'Bottom', 'pawsitive' ) 	=> 'bottom'
					)
				)
			)
		) );
	}
	static function hex2rgb( $hex ) {
		$hex = str_replace( '#', '', $hex );
		if ( strlen( $hex ) == 3 ) {
			$r = hexdec( substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) );
			$g = hexdec( substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) );
			$b = hexdec( substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) );
		} else {
			$r = hexdec( substr( $hex, 0, 2 ) );
			$g = hexdec( substr( $hex, 2, 2 ) );
			$b = hexdec( substr( $hex, 4, 2 ) );
		}
		$rgb = array( $r, $g, $b );
		return $rgb;
	}
}