<?php

class bt_bb_icon extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'icon'         					=> '',
			'colored_icon'         			=> 'no_icon',
			'colored_icon_color_scheme' 	=> '',
			'text'         					=> '',
			'url'          					=> '',
			'url_title'    					=> '',
			'target'       					=> '',
			'title_weight' 					=> '',
			'title_size' 					=> '',
			'color_scheme' 					=> '',
			'style'        					=> '',
			'size'         					=> '',
			'shape'        					=> '',
			'align'        					=> ''
		) ), $atts, $this->shortcode ) );

		$class = array( $this->shortcode );

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}
		
		$color_scheme_id = NULL;
		if ( is_numeric ( $color_scheme ) ) {
			$color_scheme_id = $color_scheme;
		} else if ( $color_scheme != '' ) {
			$color_scheme_id = bt_bb_get_color_scheme_id( $color_scheme );
		}
		$color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $color_scheme_id - 1 );
		if ( $color_scheme_colors ) $el_style .= '; --icon-primary-color:' . $color_scheme_colors[0] . '; --icon-secondary-color:' . $color_scheme_colors[1] . ';';
		if ( $color_scheme != '' ) $class[] = $this->prefix . 'color_scheme_' .  $color_scheme_id;
		
		$colored_icon_color_scheme_id = NULL;
		if ( is_numeric ( $colored_icon_color_scheme ) ) {
			$colored_icon_color_scheme_id = $colored_icon_color_scheme;
		} else if ( $colored_icon_color_scheme != '' ) {
			$colored_icon_color_scheme_id = bt_bb_get_color_scheme_id( $colored_icon_color_scheme );
		}
		$colored_icon_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $colored_icon_color_scheme_id - 1 );
		if ( $colored_icon_color_scheme_colors ) $el_style .= '; --icon-colored-icon-primary-color:' . $colored_icon_color_scheme_colors[0] . '; --icon-colored-icon-secondary-color:' . $colored_icon_color_scheme_colors[1] . ';';
		if ( $colored_icon_color_scheme != '' ) $class[] = $this->prefix . 'colored_icon_color_scheme_' .  $colored_icon_color_scheme_id;

		if ( $style != '' ) {
			$class[] = $this->prefix . 'style' . '_' . $style;
		}		

		if ( $title_size != '' ) {
			$class[] = $this->prefix . 'title_size' . '_' . $title_size;
		}

		if ( $shape != '' ) {
			$class[] = $this->prefix . 'shape' . '_' . $shape;
		}

		if ( $title_weight != '' ) {
			$class[] = $this->prefix . 'title_weight' . '_' . $title_weight;
		}

		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'size',
				'value' => $size
			)
		);
		
		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'align',
				'value' => $align
			)
		);

		
		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );

		if ( $colored_icon == 'no_icon' || $colored_icon == '' ) {
			$output = $this->get_html( $icon, $text, $url, $url_title, $target );
		} else {
			$output = '';
			if ( $text != '' ) {
				if ( $url_title == '' ) $url_title = strip_tags( $text );
				$text = '<span class="bt_bb_icon_holder_text">' . $text . '</span>';
			}
			$link = bt_bb_get_url( $url );			
			if ( $link != '' ) {
				$output .= '<a href="' . esc_url( $link ) . '" target="' . esc_attr( $target ) . '" class="bt_bb_icon_holder" title="' . esc_attr( $url_title ) . '">';
					$output .= '<span class="bt_bb_icon_holder_inner">' . bt_bb_get_svg_icon_html( $colored_icon ) . '</span>';
					$output .= $text;
				$output .= '</a>';
			} else {
				$output .= '<span class="bt_bb_icon_holder">';
					$output .= '<span class="bt_bb_icon_holder_inner">' . bt_bb_get_svg_icon_html( $colored_icon ) . '</span>';
					$output .= $text;
				$output .= '</span>';
			}
		}
		
		$output = '<div' . $id_attr . ' class="' . implode( ' ', $class ) . '"' . $style_attr . ' data-bt-override-class="' . htmlspecialchars( json_encode( $data_override_class, JSON_FORCE_OBJECT ), ENT_QUOTES, 'UTF-8' ) . '">' . $output . '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	static function get_html( $icon, $text = '', $url = '', $url_title = '', $target = '' ) {

		$icon_set = substr( $icon, 0, -5 );
		$icon = substr( $icon, -4 );

		$link = bt_bb_get_url( $url );

		if ( $text != '' ) {
			if ( $url_title == '' ) $url_title = strip_tags($text);
			$text = '<span>' . $text . '</span>';
		}
		
		$url_title_attr = '';
		
		if ( $url_title != '' ) {
			$url_title_attr = ' title="' . esc_attr( $url_title ) . '"';
		}
		
		if ( $link == '' ) {
			$ico_tag = 'span' . ' ';
			$ico_tag_end = 'span';	
		} else {
			$target_attr = 'target="_self"';
			if ( $target != '' ) {
				$target_attr = ' ' . 'target="' . ( $target ) . '"';
			}
			$ico_tag = 'a href="' . esc_attr( $link ) . '"' . ' ' . $target_attr . ' ' . $url_title_attr . ' ';
			$ico_tag_end = 'a';
		}

		return '<' . $ico_tag . ' data-ico-' . esc_attr( $icon_set ) . '="&#x' . esc_attr( $icon ) . ';" class="bt_bb_icon_holder">' . $text . '</' . $ico_tag_end . '>';
	}

	function map_shortcode() {

		$color_scheme_arr = bt_bb_get_color_scheme_param_array();
		$svg_icons_arr = bt_bb_get_svg_icons_param_array();


		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Icon', 'pawsitive' ), 'description' => esc_html__( 'Single icon with link', 'pawsitive' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'icon', 'type' => 'iconpicker', 'heading' => esc_html__( 'Icon', 'pawsitive' ), 'preview' => true ),
				array( 'param_name' => 'colored_icon', 'type' => 'dropdown', 'default' => 'no_icon', 'heading' => esc_html__( 'Colored Icon', 'pawsitive' ), 'description' => esc_html__( 'If colored icon is chosen from the list, regular icon will not be displayed', 'pawsitive' ), 'value' => $svg_icons_arr ),
				array( 'param_name' => 'text', 'type' => 'textfield', 'heading' => esc_html__( 'Text', 'pawsitive' ) ),
				array( 'param_name' => 'url', 'type' => 'textfield', 'heading' => esc_html__( 'URL', 'pawsitive' ), 'description' => esc_html__( 'Enter full or local URL (eg. https://www.bold-themes.com or /pages/about-us) or post slug (eg. about-us)', 'pawsitive' ) ),
				array( 'param_name' => 'url_title', 'type' => 'textfield', 'heading' => esc_html__( 'Mouse hover title', 'pawsitive' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'pawsitive' ) 	=> '_self',
						esc_html__( 'Blank (open in new tab)', 'pawsitive' ) 	=> '_blank',
					)
				),
				array( 'param_name' => 'align', 'type' => 'dropdown', 'heading' => esc_html__( 'Alignment', 'pawsitive' ), 'responsive_override' => true,
					'value' => array(
						esc_html__( 'Inherit', 'pawsitive' ) 				=> 'inherit',
						esc_html__( 'Left', 'pawsitive' ) 				=> 'left',
						esc_html__( 'Right', 'pawsitive' ) 				=> 'right'
					)
				),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'default' => 'small', 'heading' => esc_html__( 'Icon size', 'pawsitive' ), 'preview' => true, 'group' => esc_html__( 'Design', 'pawsitive' ), 'responsive_override' => true,
					'value' => array(
						esc_html__( 'Extra small', 'pawsitive' ) 			=> 'xsmall',
						esc_html__( 'Small', 'pawsitive' ) 				=> 'small',
						esc_html__( 'Normal', 'pawsitive' ) 				=> 'normal',
						esc_html__( 'Large', 'pawsitive' ) 				=> 'large',
						esc_html__( 'Extra large', 'pawsitive' ) 			=> 'xlarge'
					)
				),
				array( 'param_name' => 'style', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon style', 'pawsitive' ), 'preview' => true, 'group' => esc_html__( 'Design', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Outline', 'pawsitive' ) 				=> 'outline',
						esc_html__( 'Filled', 'pawsitive' ) 				=> 'filled',
						esc_html__( 'Borderless', 'pawsitive' ) 			=> 'borderless'
					)
				),
				array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon shape', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Circle', 'pawsitive' ) 				=> 'circle',
						esc_html__( 'Square', 'pawsitive' ) 				=> 'square',
						esc_html__( 'Rounded Square', 'pawsitive' ) 		=> 'round'
					)
				),
				array( 'param_name' => 'title_size', 'type' => 'dropdown', 'default' => '', 'heading' => esc_html__( 'Title size', 'pawsitive' ), 'preview' => true, 'group' => esc_html__( 'Design', 'pawsitive' ),
					'value' => array(
						esc_html__( 'Inherit', 'pawsitive' ) 				=> 'xsmall',
						esc_html__( 'Extra small', 'pawsitive' ) 			=> 'xsmall',
						esc_html__( 'Small', 'pawsitive' ) 				=> 'small',
						esc_html__( 'Normal', 'pawsitive' ) 				=> 'normal',
						esc_html__( 'Large', 'pawsitive' ) 				=> 'large',
						esc_html__( 'Extra large', 'pawsitive' ) 			=> 'xlarge'
					)
				),
				array( 'param_name' => 'title_weight', 'type' => 'dropdown', 'preview' => true, 'heading' => esc_html__( 'Title weight', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ), 
					'value' => array(
						esc_html__( 'Inherit', 'pawsitive' ) 				=> '',
						esc_html__( 'Thin', 'pawsitive' ) 				=> 'thin',
						esc_html__( 'Lighter', 'pawsitive' ) 				=> 'lighter',
						esc_html__( 'Light', 'pawsitive' ) 				=> 'light',
						esc_html__( 'Normal', 'pawsitive' ) 				=> 'normal',
						esc_html__( 'Medium', 'pawsitive' ) 				=> 'medium',
						esc_html__( 'Semi bold', 'pawsitive' ) 			=> 'semi-bold',
						esc_html__( 'Bold', 'pawsitive' ) 				=> 'bold',
						esc_html__( 'Bolder', 'pawsitive' ) 				=> 'bolder',
						esc_html__( 'Black', 'pawsitive' ) 				=> 'black'
					)
				),
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'pawsitive' ), 'value' => $color_scheme_arr, 'preview' => true, 'group' => esc_html__( 'Design', 'pawsitive' ) ),
				array( 'param_name' => 'colored_icon_color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Colored icon color scheme', 'pawsitive' ), 'value' => $color_scheme_arr, 'group' => esc_html__( 'Design', 'pawsitive' ) )
			)
		) );
	}
}