<?php

class bt_bb_floating_image extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
			'image'      					=> '',
			'horizontal_position'  			=> 'left',
			'vertical_position'  			=> 'top',
			'animation_style'  				=> 'ease_out',
			'animation_delay'  				=> 'default',
			'animation_duration'  			=> '',
			'animation_speed'  				=> '1.0',
			'lazy_load'  					=> 'no'
		) ), $atts, $this->shortcode ) );
		
		wp_enqueue_script(
			'bt_bb_floating_image',
			get_template_directory_uri() . '/bold-page-builder/content_elements/bt_bb_floating_image/bt_bb_floating_image.js',
			array( 'jquery' ),
			'',
			true
		);

		$class = array( $this->shortcode );

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}
		if ( $horizontal_position != '' ) {
			$class[] = $this->shortcode . '_horizontal_position' . '_' . $horizontal_position;
		}
		if ( $vertical_position != '' ) {
			$class[] = $this->shortcode . '_vertical_position' . '_' . $vertical_position;
		}
		if ( $animation_delay != '' ) {
			$class[] = $this->shortcode . '_animation_delay' . '_' . $animation_delay;
		}
		if ( $animation_duration != '' ) {
			$class[] = $this->shortcode . '_animation_duration' . '_' . $animation_duration;
		}
		if ( $animation_style != '' ) {
			$class[] = $this->shortcode . '_animation_style' . '_' . $animation_style;
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );		
		$class_attr = implode( ' ', $class );
		
		if ( $el_class != '' ) {
			$class_attr = $class_attr . ' ' . $el_class;
		}
	
		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}


		$output = '';

		
		if ( $image != '' ) {
			$output .=  '<div class="' . esc_attr( $this->shortcode . '_image') . '" data-speed="' . esc_attr( $animation_speed ) . '">' . do_shortcode( '[bt_bb_image image="' . esc_attr( $image ) . '" size="full" lazy_load="' . esc_attr( $lazy_load ) . '" ignore_fe_editor="true"]' ) . '</div>';	
		}
		

		$output = '<div' . $id_attr . ' class="' . esc_attr( implode( ' ', $class ) ) . '"' . $style_attr . ' data-speed="' . esc_attr( $animation_speed ) . '">' . ( $output ) . '</div>';

		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Floating image', 'pawsitive' ), 'description' => esc_html__( 'Absolute positioned floating image', 'pawsitive' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'image', 'type' => 'attach_image', 'preview' => true, 'heading' => esc_html__( 'Image', 'pawsitive' ) 
				),
				array( 'param_name' => 'vertical_position', 'preview' => true, 'default' => '', 'type' => 'dropdown', 'heading' => esc_html__( 'Vertical position', 'pawsitive' ), 
					'value' => array(
						esc_html__( 'Default', 'pawsitive' ) 				=> 'default',
						esc_html__( 'Top (absolute)', 'pawsitive' ) 		=> 'top',
						esc_html__( 'Middle (absolute)', 'pawsitive' ) 	=> 'middle',
						esc_html__( 'Bottom (absolute)', 'pawsitive' ) 	=> 'bottom'
					)
				),
				array( 'param_name' => 'horizontal_position', 'preview' => true, 'default' => '', 'type' => 'dropdown', 'heading' => esc_html__( 'Horizontal position', 'pawsitive' ), 
					'value' => array(
						esc_html__( 'Default', 'pawsitive' ) 				=> 'default',
						esc_html__( 'Left (absolute)', 'pawsitive' ) 		=> 'left',
						esc_html__( 'Center (absolute)', 'pawsitive' ) 	=> 'center',
						esc_html__( 'Right (absolute)', 'pawsitive' ) 	=> 'right'
					)
				),
				array( 'param_name' => 'lazy_load', 'type' => 'dropdown', 'default' => 'no', 'heading' => esc_html__( 'Lazy load this image', 'pawsitive' ),
					'value' => array(
						esc_html__( 'No', 'pawsitive' ) 	=> 'no',
						esc_html__( 'Yes', 'pawsitive' ) 	=> 'yes'
					)
				),
				array( 'param_name' => 'animation_style', 'preview' => true, 'default' => 'ease_out', 'type' => 'dropdown', 'group' => esc_html__( 'Animation', 'pawsitive' ), 'heading' => esc_html__( 'Animation style (check https://easings.net/en)', 'pawsitive' ), 
					'value' => array(
						esc_html__( 'Ease out (default)', 'pawsitive' ) 		=> 'ease_out',
						esc_html__( 'Ease out sine', 'pawsitive' ) 			=> 'ease_out_sine',
						esc_html__( 'Ease in', 'pawsitive' ) 					=> 'ease_in',
						esc_html__( 'Ease in sine', 'pawsitive' ) 			=> 'ease_in_sine',
						esc_html__( 'Ease in out', 'pawsitive' ) 				=> 'ease_in_out',
						esc_html__( 'Ease in out sine', 'pawsitive' ) 		=> 'ease_in_out_sine',
						esc_html__( 'Ease in out bounce', 'pawsitive' ) 		=> 'ease_in_out_back'
					)
				),
				array( 'param_name' => 'animation_delay', 'default' => '', 'type' => 'dropdown', 'group' => esc_html__( 'Animation', 'pawsitive' ), 'heading' => esc_html__( 'Animation delay', 'pawsitive' ), 
					'value' => array(
						esc_html__( 'Default', 'pawsitive' ) 				=> 'default',
						esc_html__( '0ms', 'pawsitive' ) 					=> '0',
						esc_html__( '100ms', 'pawsitive' ) 				=> '100',
						esc_html__( '200ms', 'pawsitive' ) 				=> '200',
						esc_html__( '300ms', 'pawsitive' ) 				=> '300',
						esc_html__( '400ms', 'pawsitive' ) 				=> '400',
						esc_html__( '500ms', 'pawsitive' ) 				=> '500',
						esc_html__( '600ms', 'pawsitive' ) 				=> '600',
						esc_html__( '700ms', 'pawsitive' ) 				=> '700',
						esc_html__( '800ms', 'pawsitive' ) 				=> '800',
						esc_html__( '900ms', 'pawsitive' ) 				=> '900',
						esc_html__( '1000ms', 'pawsitive' ) 				=> '1000'
					)
				),
				array( 'param_name' => 'animation_duration', 'preview' => true, 'default' => '', 'type' => 'dropdown', 'group' => esc_html__( 'Animation', 'pawsitive' ), 'heading' => esc_html__( 'Animation duration', 'pawsitive' ), 
					'value' => array(
						esc_html__( 'Default', 'pawsitive' ) 				=> 'default',
						esc_html__( '0ms', 'pawsitive' ) 					=> '0',
						esc_html__( '100ms', 'pawsitive' ) 				=> '100',
						esc_html__( '200ms', 'pawsitive' ) 				=> '200',
						esc_html__( '300ms', 'pawsitive' ) 				=> '300',
						esc_html__( '400ms', 'pawsitive' ) 				=> '400',
						esc_html__( '500ms', 'pawsitive' ) 				=> '500',
						esc_html__( '600ms', 'pawsitive' ) 				=> '600',
						esc_html__( '700ms', 'pawsitive' ) 				=> '700',
						esc_html__( '800ms', 'pawsitive' ) 				=> '800',
						esc_html__( '900ms', 'pawsitive' ) 				=> '900',
						esc_html__( '1000ms', 'pawsitive' ) 				=> '1000',
						esc_html__( '1100ms', 'pawsitive' ) 				=> '1100',
						esc_html__( '1200ms', 'pawsitive' ) 				=> '1200',
						esc_html__( '1300ms', 'pawsitive' ) 				=> '1300',
						esc_html__( '1400ms', 'pawsitive' ) 				=> '1400',
						esc_html__( '1500ms', 'pawsitive' ) 				=> '1500',
						esc_html__( '2000ms', 'pawsitive' ) 				=> '2000',
						esc_html__( '2500ms', 'pawsitive' ) 				=> '2500',
						esc_html__( '3000ms', 'pawsitive' ) 				=> '3000',
						esc_html__( '3500ms', 'pawsitive' ) 				=> '3500',
						esc_html__( '4000ms', 'pawsitive' ) 				=> '4000',
						esc_html__( '5000ms', 'pawsitive' ) 				=> '5000',
						esc_html__( '6000ms', 'pawsitive' ) 				=> '6000'
					)
				),
				array( 'param_name' => 'animation_speed', 'preview' => true, 'default' => '1.0', 'type' => 'dropdown', 'group' => esc_html__( 'Animation', 'pawsitive' ), 'heading' => esc_html__( 'Animation s', 'pawsitive' ), 
					'value' => array(
						esc_html__( '0.4 (very short)', 'pawsitive' ) 		=> '0.4',
						esc_html__( '0.6', 'pawsitive' ) 						=> '0.6',
						esc_html__( '0.8', 'pawsitive' ) 						=> '0.8',
						esc_html__( '1.0', 'pawsitive' ) 						=> '1.0',
						esc_html__( '1.2 (default)', 'pawsitive' ) 			=> '1.2',
						esc_html__( '1.4', 'pawsitive' ) 						=> '1.4',
						esc_html__( '1.6 (long)', 'pawsitive' ) 				=> '1.6',
						esc_html__( '1.8', 'pawsitive' ) 						=> '1.8',
						esc_html__( '2.0 (very long)', 'pawsitive' ) 			=> '2.0',
						esc_html__( '2.5 (very very long)', 'pawsitive' ) 	=> '2.5'
					)
				)
			)
		) );
	}
}