<?php

class bt_bb_card extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
			'icon'      					=> '',
			'colored_icon'         			=> 'no_icon',
			'colored_icon_color_scheme' 	=> '',
			'title'							=> '',
			'html_tag'      				=> 'h3',
			'text'							=> '',
			'background_image'				=> '',
			'shape'							=> '',
			'color_scheme' 					=> ''
		) ), $atts, $this->shortcode ) );

		$title = html_entity_decode( $title, ENT_QUOTES, 'UTF-8' );
		$text = html_entity_decode( $text, ENT_QUOTES, 'UTF-8' );


		$class = array( $this->shortcode );

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		$size = '';
		if ( $background_image != '' && is_numeric( $background_image ) ) {
			$post_image = get_post( $background_image );
			if ( $post_image == '' ) return;
			$size = " boldthemes_large_rectangle";
			$background_image = wp_get_attachment_image_src( $background_image, $size );
			$background_image = $background_image[0];
			
			$class[] = "btHasBgImage";
			$el_style .= 'background-image: url(' . $background_image . ')';
		}

		$text = nl2br( $text );
		$title = nl2br( $title );

		if ( $shape != '' ) {
			$class[] = $this->prefix . 'shape' . '_' . $shape;
		}

		$color_scheme_id = NULL;
		if ( is_numeric ( $color_scheme ) ) {
			$color_scheme_id = $color_scheme;
		} else if ( $color_scheme != '' ) {
			$color_scheme_id = bt_bb_get_color_scheme_id( $color_scheme );
		}
		$color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $color_scheme_id - 1 );
		if ( $color_scheme_colors ) $el_style .= '; --card-primary-color:' . $color_scheme_colors[0] . '; --card-secondary-color:' . $color_scheme_colors[1] . ';';
		if ( $color_scheme != '' ) $class[] = $this->prefix . 'color_scheme_' .  $color_scheme_id;
		
		$colored_icon_color_scheme_id = NULL;
		if ( is_numeric ( $colored_icon_color_scheme ) ) {
			$colored_icon_color_scheme_id = $colored_icon_color_scheme;
		} else if ( $colored_icon_color_scheme != '' ) {
			$colored_icon_color_scheme_id = bt_bb_get_color_scheme_id( $colored_icon_color_scheme );
		}
		$colored_icon_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $colored_icon_color_scheme_id - 1 );
		if ( $colored_icon_color_scheme_colors ) $el_style .= '; --card-colored-icon-primary-color:' . $colored_icon_color_scheme_colors[0] . '; --card-colored-icon-secondary-color:' . $colored_icon_color_scheme_colors[1] . ';';
		if ( $colored_icon_color_scheme != '' ) $class[] = $this->prefix . 'colored_icon_color_scheme_' .  $colored_icon_color_scheme_id;
		
		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}

		$class = apply_filters( $this->shortcode . '_class', $class, $atts );		
		$class_attr = implode( ' ', $class );
		
		if ( $el_class != '' ) {
			$class_attr = $class_attr . ' ' . $el_class;
		}
		
		$content = do_shortcode( $content );
		$icon_html = bt_bb_icon::get_html( $icon, '' );


		$output = '<div' . $id_attr . ' class="' . esc_attr( $class_attr ) . '"' . $style_attr . '>';
		
			// TITLE, TEXT
			$output .= '<div class="' . esc_attr( $this->shortcode . '_content' ) . '">';
				
				// ICON
				if ( $icon != '' && $colored_icon == '' || $colored_icon == 'no_icon'  ) $output .= '<div class="' . esc_attr( $this->shortcode . '_icon' ) . '">' . $icon_html . '</div>';


				// COLORED ICON
				if ( $colored_icon != '' && $colored_icon != 'no_icon' ) {
					$output .= '<div class="' . esc_attr( $this->shortcode . '_colored_icon' ) . '">';
						$output .= bt_bb_get_svg_icon_html( $colored_icon );
					$output .= '</div>';
				}


				if ( $title != '' ) $output .= '<'. $html_tag . ' class="' . esc_attr( $this->shortcode . '_title' ) . '">' . wp_kses_post( $title ) . '</' . $html_tag . '>';
				if ( $text != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_text' ) . '">' . wp_kses_post( $text ) . '</div>';
			
			$output .= '</div>';

			// INNER CONTENT
			if ( $content != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_inner_content' ) . '">' . ( $content ) . '</div>';

		$output .= '</div>';


		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {

		$color_scheme_arr = bt_bb_get_color_scheme_param_array();
		$svg_icons_arr = bt_bb_get_svg_icons_param_array();

		
		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Card', 'pawsitive' ), 'description' => esc_html__( 'Card with icon, title and text', 'pawsitive' ), 'container' => 'vertical', 'accept' => array( 'bt_bb_button' => true, 'bt_bb_icon' => true, 'bt_bb_separator' => true ),
			'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'icon', 'type' => 'iconpicker', 'heading' => esc_html__( 'Icon', 'pawsitive' ), 'preview' => true ),
				array( 'param_name' => 'colored_icon', 'type' => 'dropdown', 'default' => 'no_icon', 'heading' => esc_html__( 'Colored Icon', 'pawsitive' ), 'description' => esc_html__( 'If colored icon is chosen from the list, regular icon will not be displayed', 'pawsitive' ), 'value' => $svg_icons_arr ),
				array( 'param_name' => 'colored_icon_color_scheme', 'type' => 'dropdown', 'group' => esc_html__( 'Design', 'pawsitive' ), 'heading' => esc_html__( 'Colored icon color scheme', 'pawsitive' ), 'value' => $color_scheme_arr ),

				array( 'param_name' => 'title', 'type' => 'textarea', 'preview' => true, 'heading' => esc_html__( 'Title', 'pawsitive' ) 
				),
				array( 'param_name' => 'text', 'type' => 'textarea', 'heading' => esc_html__( 'Text', 'pawsitive' ) ),
				array( 'param_name' => 'html_tag', 'type' => 'dropdown', 'default' => 'h3', 'heading' => esc_html__( 'HTML tag', 'pawsitive' ),
					'value' => array(
						esc_html__( 'h1', 'pawsitive' ) => 'h1',
						esc_html__( 'h2', 'pawsitive' ) => 'h2',
						esc_html__( 'h3', 'pawsitive' ) => 'h3',
						esc_html__( 'h4', 'pawsitive' ) => 'h4',
						esc_html__( 'h5', 'pawsitive' ) => 'h5',
						esc_html__( 'h6', 'pawsitive' ) => 'h6'
				) ),

				
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ), 'value' => $color_scheme_arr, 'preview' => true ),
				array( 'param_name' => 'background_image', 'type' => 'attach_image', 'group' => esc_html__( 'Design', 'pawsitive' ), 'heading' => esc_html__( 'Background image', 'pawsitive' ), 'preview' => true ),
				array( 'param_name' => 'shape', 'group' => esc_html__( 'Design', 'pawsitive' ), 'default' => '', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'pawsitive' ), 
					'value' => array(
						esc_html__( 'Inherit', 'pawsitive' ) 			=> '',
						esc_html__( 'Square', 'pawsitive' ) 			=> 'square',
						esc_html__( 'Soft rounded', 'pawsitive' )		=> 'soft-rounded'
					)
				))
			)
		);
	}
}