<?php

/*************************************************
## Scripts
*************************************************/
function partdo_newsletter_scripts() {
	wp_register_style( 'klb-newsletter',   plugins_url( 'css/newsletter.css', __FILE__ ), false, '1.0');
	wp_register_script( 'klb-newsletter',  plugins_url( 'js/newsletter.js', __FILE__ ), true );

}
add_action( 'wp_enqueue_scripts', 'partdo_newsletter_scripts' );

add_action('wp_footer', 'partdo_newsletter_filter'); 
function partdo_newsletter_filter() { 

	if ( ! apply_filters( 'partdo_newsletter_filter', true ) ) {
		return;
	}

	if(get_theme_mod('partdo_newsletter_popup_toggle',0) == 1){
		wp_enqueue_script('jquery-cookie');
		wp_enqueue_script('klb-newsletter');
		wp_enqueue_style('klb-newsletter');

		$newsletter  = isset( $_COOKIE['newsletter-popup-visible'] ) ? $_COOKIE['newsletter-popup-visible'] : 'hide';
		
		if($newsletter == 'disable'){
			return;
		}

		?>
		
		  <div id="newsletter-popup" class="klb-site-newsletter" style="opacity:0;" data-expires="<?php echo esc_attr(get_theme_mod('partdo_newsletter_popup_expire_date')); ?>">
			<div class="newsletter-wrapper">
			<?php if (get_theme_mod( 'partdo_newsletter_image' )) { ?>
				<div class="newsletter-image">
					<img src="<?php echo plugins_url( 'img/colored-border.png', __FILE__ ); ?>" class="colored-border">
					<img src="<?php echo esc_url( wp_get_attachment_url(get_theme_mod( 'partdo_newsletter_image' )) ); ?>">
				</div>
			<?php } ?>
			  <div class="newsletter-inner">

				<div class="newsletter-close">
				  <i class="klbth-icon-xmark"></i>
				</div><!-- newsletter-close -->

				<h5 class="entry-title"><?php echo esc_html(get_theme_mod('partdo_newsletter_popup_title')); ?></h5>

				<div class="entry-desc">
				  <p><?php echo partdo_sanitize_data(get_theme_mod('partdo_newsletter_popup_subtitle')); ?></p>
				</div><!-- entry-desc -->

				<div class="klb-site-newsletter-form">
					<?php echo do_shortcode('[mc4wp_form id="'.get_theme_mod('partdo_newsletter_popup_formid').'"]'); ?>
				</div>
				
				<p>
					<label class="form-checkbox privacy_policy">
						<input type="checkbox" name="dontshow" class="dontshow" value="1">
						<span><?php esc_html_e('Don\'t show this popup again.','partdo-core'); ?></span>
					</label>
				</p>


			  </div><!-- newsletter-inner -->
			  <div class="newsletter-popup-overlay"></div>
			</div><!-- newsletter-wrapper -->
			
		  </div><!-- klb-site-newsletter -->

		<?php
	}
}