<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woothemes.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
global $product;
?>

<div <?php post_class(); ?>>
    <div class="row single-product-info clearfix">
        <div class="product-single-bg-color column-equal-height">
            <div class=" col-md-6 col-sm-12 sm-mg-bottom-25 clearfix">
                <div class="single-product-image clearfix">
                    <?php
                    do_action( 'g5plus_woocommerce_shortcode_single_image' );
                    ?>
                </div>
            </div>
            <div class="col-md-6 col-sm-12 clearfix">
                <div class="content-middle">
                    <div class="content-middle-inner">
                        <div class="summary-product entry-summary clearfix">
                            <?php
                            $product_add_to_cart_enable = g5plus_get_option('product_add_to_cart_enable');
                            if (!$product_add_to_cart_enable) {
                                remove_action('g5plus_woocommerce_shortcode_single','woocommerce_template_single_add_to_cart',30);
                            }
                            do_action('g5plus_woocommerce_shortcode_single');
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
