<?php
/**
 * The template for displaying content large image
 *
 * @package WordPress
 * @subpackage Theme_Name
 * @since Theme_Version 1.0
 */
$size = 'large-image';
$excerpt = get_the_excerpt();
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('post-large-image clearfix'); ?>>
    <?php g5plus_get_post_thumbnail($size); ?>
    <div class="entry-content-wrap">
        <h3 class="entry-post-title"><a title="<?php the_title(); ?>"
                                        href="<?php echo get_permalink(); ?>"><?php the_title(); ?></a></h3>
        <div class="entry-post-meta">
            <div class="entry-meta-author">
                <i class="fa fa-user"></i> <?php printf('<a href="%1$s">%2$s</a>',esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),esc_html( get_the_author() )); ?>
            </div>
            <?php if (has_category()): ?>
                <div class="entry-meta-cat"><i class="fa fa-folder-open"></i><?php the_category(); ?></div>
            <?php endif; ?>
            <div class="entry-meta-date"><i class="fa fa-history"></i>
                <a title="<?php the_title(); ?>"
                   href="<?php echo get_permalink(); ?>"><?php date_i18n(the_time(get_option('date_format'))); ?></a>
            </div>
            <?php if ( comments_open() || get_comments_number() ) : ?>
                <div class="entry-meta-comment">
                    <?php comments_popup_link( wp_kses_post(__('<i class="fa fa-comment-o"></i> 0 Comments','g5-organiz')), wp_kses_post(__('<i class="fa fa-comment-o"></i> 1 Comment','g5-organiz')), wp_kses_post(__('<i class="fa fa-comment-o"></i> % Comments','g5-organiz')), '', ''); ?>
                </div>
            <?php endif; ?>
        </div>
        <?php if (!empty($excerpt)) { ?>
            <div class="entry-excerpt">
                <?php the_excerpt(); ?>
            </div>
        <?php } ?>
        <a href="<?php echo get_permalink() ?>" class="blog-read-more">
            <?php esc_html_e('Read More', 'g5-organiz'); ?>
            <i class="fa fa-long-arrow-right"></i>
        </a>
    </div>
</article>