<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

class Elementor_Olympus_Title extends \Elementor\Widget_Base {

	public function get_name() {
		return 'olympus_title';
	}

	public function get_title() {
		return esc_html__( 'Block Title', 'elementor-olympus' );
	}

	public function get_icon() {
		return 'crum-el-w-title';
	}

	public function get_categories() {
		return [ 'elementor-olympus' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'olympus_title',
			[
				'label' => esc_html__( 'Block title', 'elementor-olympus' ),
			]
		);

		$this->add_control(
			'suptitle',
			[
				'type'      => \Elementor\Controls_Manager::TEXT,
				'label'     => esc_html__( 'Sup-title',  'elementor-olympus' ),
				'separator' => 'before'
			]
		);

		$this->add_control(
			'post_title',
			[
				'type'        => \Elementor\Controls_Manager::SWITCHER,
				'label'       => esc_html__( 'Use post title?', 'elementor-olympus' ),
                'description' => esc_html__( 'Use the title of current post/page as content element instead of text input value.', 'elementor-olympus' ),
                'default'     => 'no',
			]
        );
        
        $this->add_control(
            'title',
            [
				'type'      => \Elementor\Controls_Manager::TEXTAREA,
				'label'     => esc_html__( 'Title', 'elementor-olympus'),
				'default'   => 'The Title',
				'condition' => [
                    'post_title!' => 'yes',
                ],
                'separator' => 'before'
            ]
		);
		
		$this->add_control(
			'type',
			[
				'type'      => \Elementor\Controls_Manager::SELECT,
				'label'     => esc_html__( 'Title Tag', 'elementor-olympus' ),
				'options'   => [
					'h1'   => 'H1',
					'h2'   => 'H2',
					'h3'   => 'H3',
					'h4'   => 'H4',
					'h5'   => 'H5',
					'h6'   => 'H6',
					'div'  => 'div',
					'span' => 'Span',
					'p'    => 'P'
				],
                'default'   => 'h1',
                'separator' => 'before'
			]
		);

		$this->add_control(
			'el_class',
			[
				'type'        => \Elementor\Controls_Manager::TEXT,
				'label'       => esc_html__( 'Tag class', 'elementor-olympus' ),
				'description' => esc_html__( 'Add class name for title tag only', 'elementor-olympus' ),
				'separator'   => 'before'
			]
		);

		$this->add_control(
			'title_delim',
			[
				'type'        => \Elementor\Controls_Manager::SWITCHER,
				'label'       => esc_html__( 'Title decoration', 'elementor-olympus' ),
				'description' => esc_html__( 'Visual decoration lines below title text', 'elementor-olympus' ),
                'default'     => 'no',
                'separator'   => 'before'
			]
		);


		$this->add_control(
            'align', 
            [
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'label'     => esc_html__( 'Content align', 'elementor-olympus' ),
                'options'   => [
					'align-left'   => [
						'title' => esc_html__( 'Left', 'elementor-olympus' ),
						'icon'  => 'fa fa-align-left',
                    ],
                    'align-center' => [
						'title' => esc_html__( 'Centered', 'elementor-olympus' ),
						'icon'  => 'fa fa-align-center',
                    ],
					'align-right'  => [
						'title' => esc_html__( 'Right', 'elementor-olympus' ),
						'icon'  => 'fa fa-align-right',
					]
                ],
                'default'   => 'align-center',
                'condition' => [
                    'inline_link!' => 'yes',
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'class',
            [
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label'       => esc_html__( 'Extra class', 'elementor-olympus' ),
                'description' => esc_html__( 'If you wish to style a particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'elementor-olympus' ),
                'separator'   => 'before'
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'box-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Box Style', 'elementor-olympus' ),
			]
		);

		$this->add_control(
			'box-align',
			[
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'label'   => esc_html__( 'Align', 'elementor-olympus' ),
				'options' => [
					'left'    => [
						'title' => esc_html__( 'Left', 'elementor-olympus' ),
						'icon'  => 'fa fa-align-left',
					],
					'center'  => [
						'title' => esc_html__( 'Centered', 'elementor-olympus' ),
						'icon'  => 'fa fa-align-center',
					],
					'right'   => [
						'title' => esc_html__( 'Right', 'elementor-olympus' ),
						'icon'  => 'fa fa-align-right',
					]
				],
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};'
				],
				'default' => 'center'
			]
		);

		$this->add_control(
			'box-padding',
			[
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'label'      => __( 'Padding', 'elementor-olympus' ),
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}}' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before'
			]
		);

		$this->add_control(
			'box-margin',
			[
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'label'      => __( 'Margin', 'elementor-olympus' ),
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Title', 'elementor-olympus' ),
			]
        );

		$this->add_control(
			'title-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'elementor-olympus' ),
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_TEXT,
				],
				'selectors' => [
					'{{WRAPPER}} .heading-title' => 'color: {{SCHEME}};'
				],
				'separator' => 'after'
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'global' => [
								'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_ACCENT,
							],
				'selector' => '{{WRAPPER}} .heading-title',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'sub-title-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Suptitle', 'elementor-olympus' ),
			]
        );

		$this->add_control(
			'sub-title-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'elementor-olympus' ),
				'selectors' => [
					'{{WRAPPER}} .heading-text' => 'color: {{SCHEME}};'
				],
				'separator' => 'after'
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'sub-title_typography',
				'selector' => '{{WRAPPER}} .heading-text'
			]
		);

		$this->add_control(
            'sub-title-opacity',
            [
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'label'      => __( 'Opacity', 'elementor-olympus' ),
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1,
                        'step' => 0.01,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .heading-text' => 'opacity: {{SIZE}};',
                ],
                'separator'  => 'before'
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'decoration-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Decoration', 'elementor-olympus' ),
			]
        );

		$this->add_control(
			'decoration-color',
			[
				'label'     => esc_html__( 'Color', 'elementor-olympus' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .heading-decoration' => 'color: {{SCHEME}};'
				]
			]
		);

		$this->add_control(
			'decoration-margin',
			[
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'label'      => __( 'Margin', 'elementor-olympus' ),
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before'
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		global $allowedposttags;

		$link_html = '';

		$settings = $this->get_settings_for_display();

		$type  = ! empty( $settings['type'] ) ? $settings['type'] : 'h1';
		$title = ! empty( $settings['title'] ) ? $settings['title'] : '';
		
		$wrap_class = [ 'crumina-module', 'crumina-heading' ];
		$wrap_class[] = ! empty( $settings['align'] ) ? $settings['align'] : '';
		$wrap_class[] = ! empty( $settings['align'] ) ? '' : $settings['box-align'];

		if ( ! empty( $settings['class'] ) ) {
			$wrap_class[] = $settings['class'];
		}

		if ( ! empty( $settings['post_title'] ) && $settings['post_title'] == 'yes' ) {
			$text_title = get_the_title();
			if ( ! empty( $text_title ) ) {
				$title = $text_title;
			}
		}

		$el_class = 'heading-title';
		if ( ! empty( $settings['el_class'] ) ) {
			$el_class.= ' ' . $settings['el_class'];
		}

		?>
		<header class="<?php echo esc_attr( implode( ' ', $wrap_class ) ); ?>">
			<?php if ( ! empty( $settings['suptitle'] ) ) { ?>
				<div class="heading-sup-title"><?php echo html_entity_decode( wp_kses( $settings['suptitle'], $allowedposttags ) ); ?></div>
			<?php } ?>
		    <div class="title-text-wrap">
		    	<<?php echo esc_attr( $type ) ?> class="<?php echo esc_attr( $el_class ); ?>">
					<?php echo html_entity_decode( wp_kses( $title, $allowedposttags ) ); ?>
				</<?php echo esc_attr( $type ) ?>>
		    </div>
			<?php if ( ! empty( $settings['title_delim'] ) && $settings['title_delim'] == 'yes' ) { ?>
		        <div class="heading-decoration"></div>
			<?php } ?>
		</header>
		<?php
	}
}