<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Olympus_Testimonial extends \Elementor\Widget_Base {

	public function get_name() {
		return 'olympus_testimonial';
	}

	public function get_title() {
		return esc_html__( 'Testimonial', 'elementor-olympus' );
	}

	public function get_icon() {
		return 'crum-el-w-testimonial';
	}

	public function get_categories() {
		return [ 'elementor-olympus' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'olympus_testimonial',
			[
				'label' => esc_html__( 'Testimonial', 'elementor-olympus' )
			]
		);

		$this->add_control(
			'title',
			[
				'type'      => \Elementor\Controls_Manager::TEXT,
				'label'     => esc_html__( 'Title', 'elementor-olympus' ),
				'default'   => '',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'description',
			[
				'type'      => \Elementor\Controls_Manager::TEXTAREA,
				'label'     => esc_html__( 'Description', 'elementor-olympus' ),
				'separator' => 'before'
			]
		);

		$this->add_control(
			'image',
			[
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'label'     => esc_html__( 'Photo of author', 'elementor-olympus' ),
				'separator' => 'before'
			]
		);

		$this->add_control(
			'name',
			[
				'type'      => \Elementor\Controls_Manager::TEXT,
				'label'     => esc_html__( 'Name', 'elementor-olympus' ),
				'default'   => 'Jonathan Simpson',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'position',
			[
				'type'      => \Elementor\Controls_Manager::TEXT,
				'label'     => esc_html__( 'Position', 'elementor-olympus' ),
				'default'   => 'Lead Manager',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'author_link',
			[
				'type'        => \Elementor\Controls_Manager::URL,
				'label'       => esc_html__( 'Author link', 'elementor-olympus' ),
				'description' => esc_html__( 'Link to author blog, page, etc.', 'elementor-olympus' )
			]
		);

		$this->add_control(
			'stars',
			[
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'label'      => __( 'Stars', 'elementor-olympus' ),
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 5,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 0
				],
				'separator'  => 'before'
			]
		);

		$this->add_control(
			'custom_class',
			[
				'type'        => \Elementor\Controls_Manager::TEXT,
				'label'       => esc_html__( 'Custom class', 'elementor-olympus' ),
				'description' => esc_html__( 'Enter extra custom class', 'elementor-olympus' ),
				'separator'   => 'before'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Title', 'elementor-olympus' )
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'title-typography',
				'selector' => '{{WRAPPER}} .testimonial-title',
			]
		);

		$this->add_control(
			'title-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'elementor-olympus' ),
				'selectors' => [
					'{{WRAPPER}} .testimonial-title' => 'color: {{SCHEME}};'
				],
				'separator' => 'before'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'sub-title-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Author Info', 'elementor-olympus' )
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'sub-title-typography',
				'selector' => '{{WRAPPER}} .author-content *',
			]
		);

		$this->add_control(
			'sub-title-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'elementor-olympus' ),
				'selectors' => [
					'{{WRAPPER}} .author-content *' => 'color: {{SCHEME}};'
				],
				'separator' => 'before'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'text-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Text', 'elementor-olympus' )
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'text-typography',
				'selector' => '{{WRAPPER}} .testimonial-message',
			]
		);

		$this->add_control(
			'text-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'elementor-olympus' ),
				'selectors' => [
					'{{WRAPPER}} .testimonial-message' => 'color: {{SCHEME}};'
				],
				'separator' => 'before'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'box-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Box style', 'elementor-olympus' )
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name'     => 'box-background-color',
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .ui-block',
			]
		);

		$this->add_group_control(
			'border',
			[
				'name'      => 'box-border',
				'label'     => esc_html__( 'Border', 'elementor-olympus' ),
				'selector'  => '{{WRAPPER}} .ui-block',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'box-border-radius',
			[
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'label'      => __( 'Border Radius', 'elementor-olympus' ),
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ui-block' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'box-border_border!' => '',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'image-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Image box', 'elementor-olympus' )
			]
		);

		$this->add_control(
			'image-width',
			[
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'label'      => __( 'Width', 'elementor-olympus' ),
				'size_units' => [ 'px', 'em', '%' ],
				'range'      => [
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
					'em' => [
						'min' => 1,
						'max' => 100,
					],
					'%'  => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .author-thumb' => 'width: {{SIZE}}{{UNIT}};',
				],
				'separator'  => 'before'
			]
		);

		$this->add_control(
			'image-height',
			[
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'label'      => __( 'Height', 'elementor-olympus' ),
				'size_units' => [ 'px', 'em', '%' ],
				'range'      => [
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
					'em' => [
						'min' => 1,
						'max' => 100,
					],
					'%'  => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .author-thumb, .testimonial-header-thumb' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .testimonial-header-thumb' => 'margin-bottom: calc( {{SIZE}}{{UNIT}} / 2 );',
				],
				'separator'  => 'before'
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name'      => 'image-background-color',
				'types'     => [ 'classic', 'gradient' ],
				'selector'  => '{{WRAPPER}} .author-thumb',
				'separator' => 'before'
			]
		);

		$this->add_group_control(
			'border',
			[
				'name'      => 'image-border',
				'label'     => esc_html__( 'Border', 'elementor-olympus' ),
				'selector'  => '{{WRAPPER}} .author-thumb',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'image-border-radius',
			[
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'label'      => __( 'Border Radius', 'elementor-olympus' ),
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .author-thumb, {{WRAPPER}} .author-thumb img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'image-border_border!' => '',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {

		global $allowedtags;

		$settings = $this->get_settings_for_display();

		$name     = ! empty( $settings['name'] ) ? $settings['name'] : '';
		$position = ! empty( $settings['position'] ) ? $settings['position'] : '';

		$stars = ! empty( $settings['stars']['size'] ) ? $settings['stars']['size'] : '';

		$wrap_class = [ 'crumina-module', 'crumina-testimonial-item', 'ui-block' ];
		if ( ! empty( $settings['custom_class'] ) ) {
			$wrap_class[] = $settings['custom_class'];
		} ?>

		<div class="<?php echo implode( ' ', $wrap_class ); ?>">

			<?php  if ( ! empty( $settings['image']['url'] ) ) { ?>
				<div class="testimonial-header-thumb crumina-lazy-bg">
					<div class="testimonial-header-thumb-overlay"></div>
						<div class="author-thumb crumina-lazy-bg" style="background-image: url(<?php echo esc_attr( $settings['image']['url'] ); ?>)">
					</div>
				</div>
			<?php } ?>

			<div class="testimonial-item-content">

				<?php if ( $settings['title'] ) { ?>
					<h3 class="testimonial-title"><?php echo esc_html( $settings['title'] ); ?></h3>
				<?php } ?>

				<?php if ( $stars ) { ?>
					<ul class="rait-stars">
						<?php for ( $i = 0; $i < 5; $i++ ) { ?>
							<li>
								<i class="<?php echo( $i < $stars ? 'fas' : ' far' ); ?> fa-star star-icon"></i>
							</li>
						<?php } ?>
					</ul>
				<?php } ?>

				<?php if ( $settings['description'] ) { ?>
					<p class="testimonial-message"><?php echo wp_kses( $settings['description'], $allowedtags ); ?></p>
				<?php } ?>

				<div class="author-content">
					<?php
					if ( ! empty( $settings['author_link']['url'] ) ) {
						$rel = ! empty( $settings['author_link']['nofollow'] ) ? ' rel="' . esc_attr( trim( $settings['author_link']['nofollow'] ) ) . '"' : '';
						?>
						<a href="<?php echo esc_attr( $settings['author_link']['url'] ); ?>" title="<?php esc_attr( $name ); ?>" target="<?php echo esc_attr( trim( $settings['author_link']['is_external'] ) ); ?>" class="h6 author-name" <?php echo( $rel ); ?>>
							<?php echo esc_html( $settings['name'] ); ?>
						</a>
					<?php } else { ?>
						<div class="h6 author-name"><?php echo esc_html( $name ); ?></div>
					<?php } ?>

					<?php if ( $position ) { ?>
						<div class="author-company"><?php echo esc_html( $position ); ?></div>
					<?php } ?>
				</div>

			</div>

		</div>
		<?php
	}
}