<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


class Elementor_Olympus_Register_Form extends \Elementor\Widget_Base {

	public function get_name() {
		return 'olympus_register_form';
	}

	public function get_title() {
		return esc_html__( 'Login / Register form', 'elementor-olympus' );
	}

	public function get_icon() {
		return 'eicon-lock-user';
	}

	public function get_categories() {
		return [ 'elementor-olympus' ];
	}

  protected function register_controls(){
	$descr_text = sprintf( esc_html__( 'You can use [%s text="" url=""] shortcode', 'crum-ext-sign-form' ), 'register-link' );
    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );

	$this->add_control(
		'forms',
		[
			'label' => __( 'Display', 'elementor-olympus' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'login',
			'options' => [
				'both' => __( 'Both', 'elementor-olympus' ),
				'login' => __( 'Login', 'elementor-olympus' ),
				'register' => __( 'Register', 'elementor-olympus' )
			],
		]
	);

	$this->add_control(
		'form_type_login',
		[
			'label' => __( 'From login', 'elementor-olympus' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'native',
			'options' => [
				'native' => __( 'Olympus form', 'elementor-olympus' ),
				'youzer' => __( 'Youzer plugin form', 'elementor-olympus' ),
				'custom' => __( 'Custom shortcode', 'elementor-olympus' ),
			],
			'condition' => [
				'forms' => [ 'both', 'login' ],
			]
		]
	);

	$this->add_control(
		'form_type_register',
		[
			'label' => __( 'From register', 'elementor-olympus' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'native',
			'options' => [
				'native' => __( 'Olympus form', 'elementor-olympus' ),
				'youzer' => __( 'Youzer plugin form', 'elementor-olympus' ),
				'custom' => __( 'Custom shortcode', 'elementor-olympus' ),
			],
			'condition' => [
				'forms' => [ 'both', 'register' ],
			]
		]
	);

	$this->add_control(
		'login_shortcode',
		[
			'label' => __( 'Login form shortcode', 'elementor-olympus' ),
			'type' => \Elementor\Controls_Manager::TEXTAREA,
			'condition' => [
				'forms' => [ 'both', 'login' ],
				'form_type_login' => 'custom',
			]
		]
	);

	$this->add_control(
		'register_shortcode',
		[
			'label' => __( 'Register form shortcode', 'elementor-olympus' ),
			'type' => \Elementor\Controls_Manager::TEXTAREA,
			'condition' => [
				'forms' => [ 'both', 'register' ],
				'form_type_register' => 'custom',
			]
		]
	);

	$this->add_control(
		'redirect',
		[
			'label' => __( 'Login redirect to', 'elementor-olympus' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'current',
			'options' => [
				'current' => __( 'Current page', 'elementor-olympus' ),
				'home' => __( 'Home page', 'elementor-olympus' ),
				'profile' => __( 'Profile page', 'elementor-olympus' ),
				'activity' => __( 'Activity page', 'elementor-olympus' ),
				'custom' => __( 'Custom page', 'elementor-olympus' )
			],
			'condition' => [
				'forms' => [ 'both', 'login' ],
				'form_type_login' => 'native',
			]
		]
	);

	$this->add_control(
		'redirect_to',
		[
			'label' => __( 'Login redirect URL', 'elementor-olympus' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'condition' => [
				'forms' => [ 'both', 'login' ],
				'form_type_login' => 'native',
				'redirect' => 'custom'
			]
		]
	);

	$this->add_control(
		'register_redirect',
		[
			'label' => __( 'Register redirect to', 'elementor-olympus' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'current',
			'options' => [
				'current' => __( 'Current page', 'elementor-olympus' ),
				'home' => __( 'Home page', 'elementor-olympus' ),
				'profile' => __( 'Profile page', 'elementor-olympus' ),
				'activity' => __( 'Activity page', 'elementor-olympus' ),
				'custom' => __( 'Custom page', 'elementor-olympus' )
			],
			'condition' => [
				'forms' => [ 'both', 'register' ],
				'form_type_register' => 'native',
			]
		]
	);

	$this->add_control(
		'register_redirect_to',
		[
			'label' => __( 'Register redirect URL', 'elementor-olympus' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'condition' => [
				'forms' => [ 'both', 'register' ],
				'form_type_register' => 'native',
				'register_redirect' => 'custom'
			]
		]
	);

	$this->add_control(
		'login_descr',
		[
			'label' => __( 'Login form description', 'elementor-olympus' ),
			'type' => \Elementor\Controls_Manager::TEXTAREA,
			'condition' => ['form_type_login' => 'native'],
			'description' => $descr_text
		]
	);

	$this->add_control(
		'vcard_title',
		[
			'label' => __( 'Welcome Back title', 'elementor-olympus' ),
			'type' => \Elementor\Controls_Manager::TEXT,
		]
	);

	$this->add_control(
		'vcard_subtitle',
		[
			'label' => __( 'Welcome Back subtitle', 'elementor-olympus' ),
			'type' => \Elementor\Controls_Manager::TEXT,
		]
	);

	$this->add_control(
		'vcard_profile_btn',
		[
			'label' => __( 'Welcome Back button', 'elementor-olympus' ),
			'type' => \Elementor\Controls_Manager::TEXT,
		]
	);

	$this->add_control(
		'important_note',
		[
			'type' => \Elementor\Controls_Manager::RAW_HTML,
			'raw' => __( '<p>These settings override Customize > Sign-in | Register form settings</p>', 'elementor-olympus'  ),
			'content_classes' => 'c-secondary',
		]
	);

    $this->end_controls_section();
  }
  
  protected function render(){
    $settings = $this->get_settings_for_display();
	
	$wrapper_attributes = array();

	  $wrap_class = [ 'crumina-module', 'crumina-login-form' ];
	  if ( ! empty( $settings['custom_class'] ) ) {
		  $wrap_class[] = $settings['custom_class'];
	  }

	$wrapper_attributes[] = 'class=" ' . esc_attr( implode( ' ', $wrap_class ) ) . '"';
?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
    <?php
		if ( function_exists( 'crumina_get_reg_form_html' ) ) {
			global $wp;
			$redirect_to = filter_var( $settings['redirect_to'], FILTER_VALIDATE_URL );
			$redirect_to = ($redirect_to && $settings['redirect'] === 'custom') ? $redirect_to : home_url( $wp->request );

			$register_redirect_to = filter_var( $settings['register_redirect_to'], FILTER_VALIDATE_URL );
			$register_redirect_to = ($register_redirect_to && $settings['register_redirect'] === 'custom') ? $register_redirect_to : home_url( $wp->request );

			echo crumina_get_reg_form_html('', array(
				'forms' => $settings['forms'],
				'form_type_login' => $settings['form_type_login'],
				'form_type_register' => $settings['form_type_register'],
				'redirect_to' => $redirect_to,
				'redirect' => $settings['redirect'],
				'register_redirect_to' => $register_redirect_to,
				'register_redirect' => $settings['register_redirect'],
				'login_descr' => $settings['login_descr'],
				'login_shortcode' => $settings['login_shortcode'],
				'register_shortcode' => $settings['register_shortcode'],
				'vcard_title' => $settings['vcard_title'],
				'vcard_subtitle' => $settings['vcard_subtitle'],
				'vcard_profile_btn' => $settings['vcard_profile_btn']
			));
		} else {
			$no_ext_text = esc_html__( 'Crumina Sign in Form extension required', 'olympus' );
			echo sprintf( '<h2>%s</h2>', $no_ext_text );
		}
    ?>
</div>
<?php
  }
}