<?php
if ( ! olympus_is_left_panel_visible() ) {
	return;
}

$olympus         = Olympus_Options::get_instance();
$left_panel_icon = $olympus->get_option( 'left-panel-options-icon', '', $olympus::SOURCE_CUSTOMIZER );

if ( is_array( $left_panel_icon ) && $left_panel_icon['type'] !== 'none' ) {
	$open_menu_icon = olympus_generate_icon_html( $left_panel_icon, 'universal-olympus-icon open-state' );
} else {
	$open_menu_icon = '<svg class="open-state universal-olympus-icon"><use xlink:href="#olymp-popup-right-arrow"></use></svg>';
}

$menu_items  = array();
$sortedItems = array();
$menu_name   = 'fixed-left';
$locations   = get_nav_menu_locations();

if ( $locations && isset( $locations[ $menu_name ] ) ) {
	$menu        = wp_get_nav_menu_object( $locations[ $menu_name ] );
	$menu_items  = wp_get_nav_menu_items( $menu );
	$sortedItems = olympus_wpse_nav_menu_2_tree( $menu );
}

?>
<div id="fixed-sidebar-left"
	 class="fixed-sidebar left"

>
	<div
		class="side-menu-open js-sidebar-open olymp-menu-icon"
		>
		<span data-balloon-pos="right" data-balloon="<?php esc_attr_e( 'Open menu', 'olympus' ); ?>">
			<?php olympus_render( $open_menu_icon ); ?>
		</span>
		<span data-balloon-pos="right" data-balloon="<?php esc_attr_e( 'Close menu', 'olympus' ); ?>">
			<i class="olymp-close-icon olympus-icon-Close-Icon"></i>
		</span>
	</div>

	<div class="fixed-sidebar-left sidebar--small" id="sidebar-left">
		<div class="mCustomScrollbar" data-mcs-theme="dark">
			<ul class="left-menu">
				<?php
				if ( ! empty( $sortedItems ) ) {
					foreach ( $sortedItems as $idx => $item ) {
						if ( function_exists( 'fw_ext_mega_menu_get_meta' ) ) {
							$meta = fw_ext_mega_menu_get_meta( $item['id'], "icon" );
						} else {
							$meta = '';
						}
						$icon = olympus_generate_icon_html( $meta, 'universal-olympus-icon' );
						$class = $item['classes'];
						?>
						<li <?php echo olympus_attr_to_html(array('class' => $class)); ?>>
							<a <?php if ( $item['target'] == '_blank' ) {
								echo 'target="_blank"';
							} ?> href="<?php echo esc_attr( $item['url'] ); ?>">
								<span data-balloon-pos="right" data-balloon="<?php echo esc_attr( $item['title'] ); ?>">
									<?php olympus_render( $icon ); ?>
								</span>
							</a>
						</li>
						<?php
					}
				}
				?>
			</ul>
		</div>
	</div>

	<div class="fixed-sidebar-left sidebar--large" id="sidebar-left-1">
		<div class="mCustomScrollbar" data-mcs-theme="dark">
			<ul class="left-menu">
				<?php
				if ( ! empty( $sortedItems ) ) {
					foreach ( $sortedItems as $item ) {
						if ( function_exists( 'fw_ext_mega_menu_get_meta' ) ) {
							$meta = fw_ext_mega_menu_get_meta( $item['id'], "icon" );
						} else {
							$meta = '';
						}
						$icon = olympus_generate_icon_html( $meta, 'universal-olympus-icon' );
						?>
						<li>
							<a <?php if ( $item['target'] == '_blank' ) {
								echo 'target="_blank"';
							} ?> href="<?php echo esc_attr( $item['url'] ); ?>">
								<?php olympus_render( $icon ); ?>
								<span class="left-menu-title"><?php echo esc_html( $item['title'] ); ?></span>
							</a>
							<?php if ( isset( $item['children'] ) ) { ?>
								<ul class="sub-menu">
									<?php foreach ( $item['children'] as $child ) {
										if ( function_exists( 'fw_ext_mega_menu_get_meta' ) ) {
											$meta_child = fw_ext_mega_menu_get_meta( $child['id'], "icon" );
										} else {
											$meta_child = '';
										}
										$icon_child = olympus_generate_icon_html( $meta_child, 'universal-olympus-icon' );
										?>
										<li>
											<a <?php if ( $child['target'] == '_blank' ) {
												echo 'target="_blank"';
											} ?> href="<?php echo esc_attr( $child['url'] ); ?>">
												<?php olympus_render( $icon_child ); ?>
												<span class="left-menu-title"><?php echo esc_html( $child['title'] ); ?></span>
											</a>
										</li>
									<?php } ?>
								</ul>
							<?php } ?>
						</li>
						<?php
					}
				} else {
					olympus_menu_fallback( esc_html__( 'Left Menu Panel', 'olympus' ) );
				}
				?>
			</ul>
		</div>
	</div>
</div>
