<?php

/**
 * Scripts to include on front pages
 *
 * @package olympus-wp
 */
$theme_version = olympus_get_theme_version();
$enqueue_scripts_array = array();

/* ==============
 * REGISTER
 * 3-rd party plugins
  =============== */

wp_register_script( 'purecounter', get_template_directory_uri() . '/js/plugins/purecounter.min.js', array(), '1.0.0', true );

wp_enqueue_script( 'bp-nouveau-magnific-popup', get_template_directory_uri() . '/js/plugins/magnific-popup.min.js', array( 'jquery' ), '1.1.0', true );

wp_enqueue_style( 'magnific-popup', get_template_directory_uri() . '/css/magnific-popup.css', false, '1.1.0' );

array_push($enqueue_scripts_array, 'magnific-popup-css');

wp_enqueue_script( 'perfect-scrollbar', get_template_directory_uri() . '/js/plugins/perfect-scrollbar.min.js', array( 'jquery' ), '1.5.0', true );

wp_enqueue_script( 'materialize', get_template_directory_uri() . '/js/plugins/material-forms.min.js', array( 'jquery' ), '1.0.0', true );

wp_register_script( 'isotope', get_template_directory_uri() . '/js/plugins/isotope.pkgd.js', array( 'imagesloaded' ), '3.0.4', true );

wp_register_script( 'jquery-mousewheel', get_template_directory_uri() . '/js/plugins/jquery-mousewheel.js', array( 'jquery' ), '3.1.13', true );

wp_register_script( 'smooth-scroll', get_template_directory_uri() . '/js/plugins/smooth-scroll.js', array( 'jquery' ), '2.1.5', true );


if ( is_page_template( 'blog-template.php' ) || ( function_exists( 'bp_is_friends' ) && bp_is_friends() ) ) {
	wp_enqueue_script( 'swiper', get_template_directory_uri() . '/js/plugins/swiper.min.js', array( 'jquery', 'olympus-main' ), '5.3.6', true );
	wp_add_inline_script( 'swiper', 'jQuery(document).ready(function () {CRUMINA.Swiper.init(jQuery(\'.swiper-container\'));});' );
}



/* ======================
 *  THEME CSS COMPONENTS
  ==================== */
//Unyson
if ( function_exists( 'fw' ) ) {
	$enqueue_packs_array = array();
	$packs_icons = get_transient( 'transient_packs_icons' );
	if ( false === $packs_icons ) {
		$packs_icons = olympus_load_icons_css();
		set_transient( 'transient_packs_icons', $packs_icons );
	}

	if( !empty($packs_icons) ){
		foreach( $packs_icons as $packs_icon_k => $packs_icon_v ){
			wp_enqueue_style( 'olympus-icon-packs-' . $packs_icon_k, $packs_icon_v, array(), fw()->manifest->get_version() );
			array_push( $enqueue_packs_array, 'olympus-icon-packs-' . $packs_icon_k );
		}
	}

	// Minify css
	$minify_theme_css = fw_get_db_customizer_option( 'minify-theme-css' );
	if($minify_theme_css == 'enable'){
		olympus_minify_css($enqueue_packs_array, '/minify-icon-packs.css');
		wp_enqueue_style( 'olympus-minify-icon-packs', trailingslashit( wp_upload_dir()['baseurl'] ) . 'olympus-minify/minify-icon-packs.css' );
	}
}

//Font awesome
wp_enqueue_style( 'yz-icons', get_template_directory_uri() . '/css/fontawesome.min.css', array(), '5.12.1' );
array_push($enqueue_scripts_array, 'yz-icons');


// Add font, used in the main stylesheet.
$olympus_fonts = olympus_font_url();
if( $olympus_fonts == 'roboto' ){
	wp_enqueue_style( 'olympus-theme-font', get_template_directory_uri() . '/css/olympus-fonts.css', array(), $theme_version );
	add_action( 'wp_head', 'olympus_preload_webfonts' );
} else {
	wp_enqueue_style( 'olympus-theme-font', olympus_font_url(), array(), $theme_version );
}


if ( ! function_exists( 'olympus_preload_webfonts' ) ) :

	/**
	 * Preloads the main web font to improve performance.
	 *
	 * Only the main web font (font-style: normal) is preloaded here since that font is always relevant (it is used
	 * on every heading, for example). The other font is only needed if there is any applicable content in italic style,
	 * and therefore preloading it would in most cases regress performance when that font would otherwise not be loaded
	 * at all.
	 *
	 * @since Twenty Twenty-Two 1.0
	 *
	 * @return void
	 */
	function olympus_preload_webfonts() {
		?>
		<link rel="preload" href="<?php echo esc_url( get_theme_file_uri( 'fonts/roboto-v18-latin_latin-ext-regular.woff2' ) ); ?>" as="font" type="font/woff2" crossorigin>
		<link rel="preload" href="<?php echo esc_url( get_theme_file_uri( 'fonts/roboto-v18-latin_latin-ext-500.woff2' ) ); ?>" as="font" type="font/woff2" crossorigin>
		<link rel="preload" href="<?php echo esc_url( get_theme_file_uri( 'fonts/roboto-v18-latin_latin-ext-700.woff2' ) ); ?>" as="font" type="font/woff2" crossorigin>
		<link rel="preload" href="<?php echo esc_url( get_theme_file_uri( 'fonts/roboto-v18-latin_latin-ext-300.woff2' ) ); ?>" as="font" type="font/woff2" crossorigin>
		<?php
	}

endif;

if ( is_page_template( 'blog-template.php' ) ) {
	wp_enqueue_style( 'swiper', get_template_directory_uri() . '/css/swiper.css', array(), $theme_version);
	array_push($enqueue_scripts_array, 'swiper');
}

wp_register_style( 'olympus-widgets', get_template_directory_uri() . '/css/widgets.css', array(), '5.0.6' );

// Tooltips
wp_enqueue_style( 'tooltips', get_template_directory_uri() . '/css/plugins/balloon.css', array(), '1.0' );

// Bootstrap.
wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/Bootstrap/dist/css/bootstrap.css', array(), '4.4.0' );

// Theme.
wp_enqueue_style( 'olympus-main', get_template_directory_uri() . '/css/main.css', array('olympus-widgets' ), $theme_version );
array_push($enqueue_scripts_array, 'olympus-main');

// Add icons font, used in the main stylesheet.
wp_enqueue_style( 'olympus-icons-font', get_template_directory_uri() . '/css/olympus-icons-font.css', array(), $theme_version);


/* ======================
 *  3-D Plugin Styles Integration
  ==================== */

if ( class_exists( 'LearnPress' ) ) {
	wp_enqueue_style( 'olympus-learn-press', get_template_directory_uri() . '/css/learn-press-customization.css', array( 'learn-press' ), $theme_version );
	array_push($enqueue_scripts_array, 'olympus-learn-press');
}
if( class_exists( 'wpForo' ) ) {
	wp_enqueue_style( 'olympus-wp-foro', get_template_directory_uri() . '/css/wp-foro-customization.css', array( 'wpforo-style' ), $theme_version );
	array_push($enqueue_scripts_array, 'olympus-wp-foro');
}
if ( class_exists('Tutor')){
	wp_enqueue_style( 'olympus-tutor-lms', get_template_directory_uri() . '/css/tutor-lms-customization.css', array( 'tutor-frontend' ), $theme_version );
	array_push($enqueue_scripts_array, 'olympus-tutor-lms');
}
if ( class_exists('Adverts')){
	wp_enqueue_style( 'olympus-wpadverts', get_template_directory_uri() . '/css/wpadverts-customization.css', array( 'adverts-frontend' ), $theme_version );
	array_push($enqueue_scripts_array, 'olympus-wpadverts');
}
if( class_exists('myCRED_Core') ){
	wp_enqueue_style( 'olympus-mycred', get_template_directory_uri() . '/css/mycred-customization.css', array(), $theme_version );
	array_push($enqueue_scripts_array, 'olympus-mycred');
}


/* ======================
 *  THEME JS COMPONENTS
  ==================== */
if ( is_singular() ) {
    wp_enqueue_script( 'comment-reply' );
}

wp_register_script( 'olympus-mega-menu', get_template_directory_uri() . '/js/crum-mega-menu.js', array( 'jquery' ), $theme_version, true );

wp_enqueue_script( 'bootstrap-tabs', get_template_directory_uri() . '/js/bootstrap/tab.js', array(), '5.2.1', true );

wp_enqueue_script( 'jquery-scroll-to', get_template_directory_uri() . '/js/plugins/jquery.scrollTo.min.js', array( 'jquery', 'olympus-mega-menu' ), '2.1.2', true );

wp_enqueue_script( 'olympus-main', get_template_directory_uri() . '/js/theme-main.js', array( 'imagesloaded', 'smooth-scroll', 'olympus-mega-menu' ), $theme_version, true );
wp_localize_script( 'olympus-main', 'themeStrings', array(
    'ajaxUrl' => admin_url( 'admin-ajax.php' ),
    'uploadBtnText' => esc_html__( 'Upload', 'olympus' ),
    'uploadCommentBtnText' => esc_html__( 'Comment', 'olympus' )
) );

$custom_js = ( function_exists( 'fw_get_db_customizer_option' ) ) ? fw_get_db_customizer_option( 'custom-js', '' ) : '';
if ( ! empty( $custom_js ) ) {
	$custom_js = 'jQuery( document ).ready(function($) {  ' . $custom_js . '  });';
	wp_add_inline_script( 'olympus-main', $custom_js );
}

wp_enqueue_script( 'olympus-svg-icons', get_template_directory_uri() . '/js/svg-loader.js', array(), $theme_version,true );
wp_script_add_data( 'olympus-svg-icons', 'async', true );

//wp_enqueue_style( 'olympus-dark', get_template_directory_uri() . '/css/dark.css', false, $theme_version );

/* ======================
 *  Plugins customization
  ==================== */


if ( ! class_exists( 'Youzify' ) && function_exists( 'is_bbpress' ) ) {
	if ( is_bbpress() || is_singular() || is_search() ) {
		wp_enqueue_style( 'ol-bbpress', get_theme_file_uri( 'css/bbp-customization.css' ), array(), $theme_version );
		array_push($enqueue_scripts_array, 'ol-bbpress');
	}
}
if ( ! class_exists( 'Youzify' ) && function_exists( 'is_buddypress' ) ) {
	$active_buddypress = property_exists( 'BuddyPress', 'buddypress' ) ? BuddyPress()->buddypress : false;
	if ($active_buddypress){
		wp_enqueue_style( 'ol-buddypress', get_theme_file_uri( 'css/buddypress-customization.css' ), array(), $theme_version );
		array_push($enqueue_scripts_array, 'ol-buddypress');
	} else {
		wp_enqueue_style( 'ol-buddypress', get_theme_file_uri( 'css/buddypress-customization.css' ), array(), $theme_version );
		array_push($enqueue_scripts_array, 'ol-buddypress');
	}


}


// Minify css
if(function_exists('fw_get_db_customizer_option')){
	$minify_theme_css = fw_get_db_customizer_option( 'minify-theme-css' );
	if($minify_theme_css == 'enable'){
		olympus_minify_css($enqueue_scripts_array, '/minify.css');
		wp_enqueue_style( 'olympus-minify', trailingslashit( wp_upload_dir()['baseurl'] ) . 'olympus-minify/minify.css' );
	}
}