<?php
$options                 = get_theme_mod( 'fw_options' );
$youzer_styles_customize = olympus_akg( 'enable_youzer_styles', $options, 'yes' );
$youzer_icons_customize  = olympus_akg( 'enable_youzer_icons', $options, 'yes' );

if ( 'yes' === $youzer_styles_customize ) {
	add_action( 'wp_enqueue_scripts', '_action_olympus_yz_styles', 999 );
}
if ( 'yes' === $youzer_icons_customize ) {
	add_action( 'wp_enqueue_scripts', '_action_olympus_yz_icons', 999 );
}

//Register Public Scripts .

function _action_olympus_yz_styles() {

	global $Youzify;

	if ( ! $Youzify ) {
		return;
	}

	$theme_version   = olympus_get_theme_version();
	$enqueued_styles = olympus_enqueued_styles_handle();
	$post_content    = get_post_field( 'post_content', get_the_ID() );

	$youzer_activity_shortcode = has_shortcode( $post_content, 'youzer_activity' ) ? true : false;

	/* ---------------------------------- */
	$enqueue_scripts_array = array('olympus-youzer', 'youzer-customization');

	wp_enqueue_style( 'olympus-youzer', get_theme_file_uri( 'css/youzer/youzer.css' ), 'youzer', $theme_version );
	wp_enqueue_style( 'youzer-customization', get_template_directory_uri() . '/css/youzer-customization.css', false, $theme_version );

	if ( has_shortcode( $post_content, 'youzify_members' ) ) {
		wp_enqueue_style( 'olympus-yz-directories', get_theme_file_uri( 'css/youzer/yz-directories.css' ), 'youzify-directories', $theme_version );
		array_push($enqueue_scripts_array, 'olympus-yz-directories');
	}

	if ( in_array( 'youzify-wall', $enqueued_styles ) || true === $youzer_activity_shortcode ) {
		wp_enqueue_style( 'olympus-yz-wall', get_theme_file_uri( 'css/youzer/yz-wall.css' ), 'youzify-wall', $theme_version );
		array_push($enqueue_scripts_array, 'olympus-yz-wall');
	}

	if ( in_array( 'youzify-profile', $enqueued_styles ) ) {
		wp_enqueue_style( 'olympus-yz-profile', get_theme_file_uri( 'css/youzer/yz-profile-style.css' ), 'youzify-profile', $theme_version );
		array_push($enqueue_scripts_array, 'olympus-yz-profile');
	}

	if ( in_array( 'youzify-iconpicker', $enqueued_styles ) ) {
		wp_enqueue_style( 'olympus-yz-iconpicker', get_theme_file_uri( 'css/youzer/yz-iconpicker.css' ), 'youzify-iconpicker', $theme_version );
		array_push($enqueue_scripts_array, 'olympus-yz-iconpicker');
	}

	if ( in_array( 'youzify-headers', $enqueued_styles ) ) {
		wp_enqueue_style( 'olympus-yz-headers', get_theme_file_uri( 'css/youzer/yz-headers.css' ), 'youzify-headers', $theme_version );
		array_push($enqueue_scripts_array, 'olympus-yz-headers');
	}

	if ( in_array( 'youzify-woocommerce', $enqueued_styles ) ) {
		wp_enqueue_style( 'olympus-yz-woocommerce', get_theme_file_uri( 'css/youzer/yz-woocommerce.css' ), 'youzify-woocommerce', $theme_version );
		array_push($enqueue_scripts_array, 'olympus-yz-woocommerce');
	}

	if ( in_array( 'youzify-social', $enqueued_styles ) ) {
		wp_enqueue_style( 'olympus-yz-social', get_theme_file_uri( 'css/youzer/yz-social.css' ), 'youzify-social', $theme_version );
		array_push($enqueue_scripts_array, 'olympus-yz-social');
	}

	if ( in_array( 'youzify-reviews', $enqueued_styles ) ) {
		wp_enqueue_style( 'olympus-yz-reviews', get_theme_file_uri( 'css/youzer/yz-reviews.css' ), 'youzify-reviews', $theme_version );
		array_push($enqueue_scripts_array, 'olympus-yz-reviews');
	}

	if ( in_array( 'youzify-mycred', $enqueued_styles ) ) {
		wp_enqueue_style( 'olympus-yz-mycred', get_theme_file_uri( 'css/youzer/yz-mycred.css' ), 'youzify-mycred', $theme_version );
		array_push($enqueue_scripts_array, 'olympus-yz-mycred');
	}

	if ( in_array( 'youzify-mycred', $enqueued_styles ) ) {
		wp_enqueue_style( 'olympus-yz-mycred', get_theme_file_uri( 'css/youzer/yz-mycred.css' ), 'youzify-mycred', $theme_version );
		array_push($enqueue_scripts_array, 'olympus-yz-mycred');
	}

	if ( in_array( 'youzify-bbpress', $enqueued_styles ) ) {
		wp_enqueue_style( 'olympus-yz-bbpress', get_theme_file_uri( 'css/youzer/yz-bbpress.css' ), 'youzify-bbpress', $theme_version );
		array_push($enqueue_scripts_array, 'olympus-yz-bbpress');
	}

	if ( in_array( 'youzify-groups', $enqueued_styles ) ) {
		wp_enqueue_style( 'olympus-yz-groups', get_theme_file_uri( 'css/youzer/yz-groups.css' ), 'youzify-groups', $theme_version );
		array_push($enqueue_scripts_array, 'olympus-yz-groups');
	}

	if ( in_array( 'youzify-directories', $enqueued_styles ) ) {
		wp_enqueue_style( 'olympus-yz-directories', get_theme_file_uri( 'css/youzer/yz-directories.css' ), 'youzify-directories', $theme_version );
		array_push($enqueue_scripts_array, 'olympus-yz-directories');
	}

	if ( in_array( 'youzify-account', $enqueued_styles ) ) {
		wp_enqueue_style( 'olympus-yz-account', get_theme_file_uri( 'css/youzer/yz-account-style.css' ), 'youzify-account-css', $theme_version );
		array_push($enqueue_scripts_array, 'olympus-yz-account');
	}

	if ( in_array( 'logy-style', $enqueued_styles ) ) {
		wp_enqueue_style( 'olympus-logy-style', get_theme_file_uri( 'css/youzer/logy.css' ), 'logy-style', $theme_version );
		array_push($enqueue_scripts_array, 'olympus-logy-style');
	}

	/* Disable unused font from Youzer */
	wp_dequeue_style( 'youzify-opensans' );
	wp_dequeue_style( 'youzify-roboto' );
	wp_dequeue_style( 'youzify-lato' );
    wp_deregister_style('youzify-roboto');
    wp_deregister_style('youzify-lato');

	/* Minify css from Youzer */
	if(function_exists('fw_get_db_customizer_option')){
		$minify_theme_css = fw_get_db_customizer_option( 'minify-theme-css' );
		if($minify_theme_css == 'enable'){
			olympus_minify_css($enqueue_scripts_array, '/minify-youzer.css');
			wp_enqueue_style( 'olympus-youzer-minify', trailingslashit( wp_upload_dir()['baseurl'] ) . 'olympus-minify/minify-youzer.css' );
		}
	}
}

function _action_olympus_yz_icons() {
	$theme_version = olympus_get_theme_version();
	wp_enqueue_style( 'olympus-youzer-icons-customization', get_theme_file_uri( 'css/youzer/yz-icons-customization.css' ), array(
		'youzify',
		'youzify-icons'
	), $theme_version );
}



/**
 * User Balance WP Widget
 */

function crum_mycred_user_balance_wp_widget() {
	$regWdgt = 'register_' . 'widget';
	$regWdgt( 'Youzify_Mycred_Balance_Widget' );
}

add_action( 'widgets_init', 'crum_mycred_user_balance_wp_widget' );


/** *
 * Change Some default options value
 */

/*add_filter( 'youzer_edit_options', '_filter_olympus_yz_edit_options', 10, 2 );*/

function _filter_olympus_yz_edit_options( $option_value, $option_id ) {

	switch ( $option_id ) {
		case 'yz_enable_settings_copyright':
			$option_value = 'off';
			break;
	}

	return $option_value;
}

function _filter_olympus_youzify_parent_directory(){
	return get_template_directory();
}
add_filter('youzify_get_theme_template_path', '_filter_olympus_youzify_parent_directory');



function _filter_olympus_yz_default_options( $options ) {
	return olympus_array_merge( $options, array(
		'yz_enable_settings_copyright'    => 'off',
		'yz_display_scrolltotop'          => 'off',
		'yz_plugin_content_width'         => '1300',
		'yz_plugin_background'            => array( 'color' => '' ),
		'yz_profile_scheme'               => 'yz-darkorange-scheme',
		'yz_panel_scheme'                 => 'uk-orange-scheme',
		'yz_enable_profile_custom_scheme' => 'on',
		'yz_buttons_border_style'         => 'radius',
		'yz_tabs_list_icons_style'        => 'youzify-tabs-list-gray',
		'yz_profile_custom_scheme_color'  => array( 'color' => '#ff5e3a' ),
	) );
}

//add_filter( 'yz_default_options', '_filter_olympus_yz_default_options' );

// Register popup activation
add_action( 'init', 'olympus_update_youzify_popup_option' );
function olympus_update_youzify_popup_option(){
	$olympus = Olympus_Options::get_instance();
	$sign_form_popup = $olympus->get_option( 'sign-form-popup', array( 'sign-form-picker' => 'native' ), $olympus::SOURCE_CUSTOMIZER );
	if ( olympus_akg( 'sign-form-picker', $sign_form_popup ) === 'youzer' && function_exists( 'youzify_update_option' ) ) {
		youzify_update_option('youzify_enable_login_popup', 'on');
	}
}

remove_action( 'admin_notices', 'youzify_offer_banner', 10 );

/*Remove Youzify Advertizing on theme admin*/
add_action( 'admin_init', 'olympus_remove_youzify_banners' );
function olympus_remove_youzify_banners() {
	remove_action( 'admin_notices', 'youzify_offer_banner' );
	if (function_exists( 'youzify_update_option' )){
		youzify_update_option( 'youzify-change-log-notice-'.YOUZIFY_VERSION, 1 );
		youzify_update_option( 'youzify_hide_affiliate_banner', 1 );
	}
}

/**
 * Show All Site Members Count.
 */
if( ! function_exists('youzer_show_all_site_members_count')){
	function youzer_show_all_site_members_count() {
		return bp_get_total_site_member_count();
	}
}

add_filter( 'bp_get_total_member_count', 'youzer_show_all_site_members_count' );