<?php
if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$activity_pages = ( function_exists('bp_core_get_directory_page_ids') ) ? bp_core_get_directory_page_ids() : array();
$activity_pages_array = array();
if(!empty($activity_pages)){
    foreach($activity_pages as $activity_pages_val){
        $activity_pages_array[$activity_pages_val] = get_the_title($activity_pages_val);
    }
}
$forum_pages_array = array();
if(function_exists('bbp_get_root_slug')){
    $forum_pages_array[bbp_get_root_slug()] = esc_html__( 'Forum', 'olympus' );
}
if(function_exists('bbp_get_topic_archive_slug')){
    $forum_pages_array[bbp_get_topic_archive_slug()] = esc_html__( 'Topic', 'olympus' );
}

$args_post_types = array(
    'public'   => true,
    '_builtin' => false,
);
$all_custom_post_types_arr = array('post' => esc_html__( 'Posts', 'olympus' ));
$all_custom_post_types = get_post_types($args_post_types, 'objects');
if( !empty($all_custom_post_types) ){
    foreach( $all_custom_post_types as $all_custom_post_type ){
        if( $all_custom_post_type->name != 'forum' && $all_custom_post_type->name != 'topic' )
        $all_custom_post_types_arr[$all_custom_post_type->name] = $all_custom_post_type->label;
    }
}

$all_pages_arr = array();
$all_pages_obj = get_pages();
if( !empty($all_pages_obj) ){
    foreach ( $all_pages_obj as $page_k => $page_v ) {
        if( $page_v->post_type == 'page' ){
            $all_pages_arr[$page_v->ID] = $page_v->post_title;
        }
    }
}

$options = array(
    'content-restriction' => array(
        'title'   => esc_html__( 'Content restriction', 'olympus' ),
        'options' => array(
            'all_pages'     => array(
                'title'   => esc_html__( 'All pages', 'olympus' ),
                'options' => array(
                    'show-pages-not-login' => array(
                        'type'    => 'multi-picker',
                        'label'   => false,
                        'desc'    => false,
                        'picker'  => array(
                            'enable' => array(
                                'label'        => esc_html__( 'Show for logged in users only', 'olympus' ),
                                'type'         => 'switch',
                                'left-choice'  => array(
                                    'value' => 'no',
                                    'label' => esc_html__( 'No', 'olympus' )
                                ),
                                'right-choice' => array(
                                    'value' => 'yes',
                                    'label' => esc_html__( 'Yes', 'olympus' )
                                ),
                                'value' => 'no',
                            ),
                        ),
                        'choices' => array(
                            'yes' => array(
                                'page_redirect' => array(
                                    'type' => 'multi-select',
                                    'label' => esc_html__( 'Redirect non-logged users to the page', 'olympus' ),
                                    'choices' => $all_pages_arr,
                                    'limit' => 1,
                                ),
                                'excude_pages' => array(
                                    'type' => 'multi-select',
                                    'label' => esc_html__( 'Exclude pages', 'olympus' ),
                                    'choices' => $all_pages_arr,
                                    'limit' => 100,
                                )
                            )
                        )
                    )
                )
            ),
            'post_types' => array(
                'title'   => esc_html__( 'Post types', 'olympus' ),
                'options' => array(
                    'show-post-types-not-login' => array(
                        'type'    => 'multi-picker',
                        'label'   => false,
                        'desc'    => false,
                        'picker'  => array(
                            'enable' => array(
                                'label'        => esc_html__( 'Show for logged in users only', 'olympus' ),
                                'type'         => 'switch',
                                'left-choice'  => array(
                                    'value' => 'no',
                                    'label' => esc_html__( 'No', 'olympus' )
                                ),
                                'right-choice' => array(
                                    'value' => 'yes',
                                    'label' => esc_html__( 'Yes', 'olympus' )
                                ),
                                'value' => 'no',
                            ),
                        ),
                        'choices' => array(
                            'yes' => array(
                                'page_redirect' => array(
                                    'type' => 'multi-select',
                                    'label' => esc_html__( 'Redirect non-logged users to the page', 'olympus' ),
                                    'choices' => $all_pages_arr,
                                    'limit' => 1,
                                ),
                                'excude_post_types' => array(
                                    'type' => 'multi-select',
                                    'label' => esc_html__( 'Exclude post types', 'olympus' ),
                                    'choices' => $all_custom_post_types_arr,
                                    'limit' => 100,
                                )
                            )
                        )
                    )
                )
            ),
            'activity_pages'     => array(
                'title'   => esc_html__( 'Activity pages', 'olympus' ),
                'options' => array(
                    'show-activity-pages-not-login' => array(
                        'type'    => 'multi-picker',
                        'label'   => false,
                        'desc'    => false,
                        'picker'  => array(
                            'enable' => array(
                                'label'        => esc_html__( 'Show for logged in users only', 'olympus' ),
                                'type'         => 'switch',
                                'left-choice'  => array(
                                    'value' => 'no',
                                    'label' => esc_html__( 'No', 'olympus' )
                                ),
                                'right-choice' => array(
                                    'value' => 'yes',
                                    'label' => esc_html__( 'Yes', 'olympus' )
                                ),
                                'value' => 'no',
                            ),
                        ),
                        'choices' => array(
                            'yes' => array(
                                'page_redirect' => array(
                                    'type' => 'multi-select',
                                    'label' => esc_html__( 'Redirect non-logged users to the page', 'olympus' ),
                                    'choices' => $all_pages_arr,
                                    'limit' => 1,
                                ),
                                'excude_pages' => array(
                                    'type' => 'multi-select',
                                    'label' => esc_html__( 'Exclude activity pages', 'olympus' ),
                                    'choices' => $activity_pages_array,
                                    'limit' => 50,
                                ),
                                'excude_forum_pages' => array(
                                    'type' => 'multi-select',
                                    'label' => esc_html__( 'Exclude forum pages', 'olympus' ),
                                    'choices' => $forum_pages_array,
                                    'limit' => 50,
                                )
                            )
                        )
                    )
                )
            )    
        )
    )
);