<?php
/**
 * Single Product title
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/title.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woothemes.com/document/template-structure/
 * @author     WooThemes
 * @package    WooCommerce/Templates
 * @version    1.6.4
 */

defined( 'ABSPATH' ) || exit;

global $product;
$review_count = $product->get_review_count();
$is_ajax      = 'XMLHttpRequest' == ( $_SERVER['HTTP_X_REQUESTED_WITH'] ?? '' );
?>
<?php if ( wc_review_ratings_enabled() ) { ?>
<header class="entry-header">
	<?php

	if ( $is_ajax ) {
		the_title( '<h4 class="product_title entry-title product-name"><a href="' . esc_url( get_permalink() ) . '">', '</a></h4>' );
	} else {
		if ( dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_shop_product_nav' ) ) ) {
			?>
			<div class="flex">
			<?php
			the_title( '<h4 class="product_title entry-title product-name">', '</h4>' );
			dima_product_next_prev_nav();
			?>
		   </div>
			<?php
		} else {
			the_title( '<h4 class="product_title entry-title product-name">', '</h4>' );
		}
	}

	?>
	<span class="dima-divider line-start line-hr small-line"></span>
	<?php
	if ( ! dima_woocommerce_version_check( '3.0.0' ) ) {
		$rating = $product->get_rating_html();
	} else {
		$rating = wc_get_rating_html( $product->get_average_rating() );
	}
	if ( ! empty( $rating ) ) {
		echo '<div class="star-rating-container aggregate">' . $rating . '</div>';
	} else {
		?>
		<div class="star-rating" title="<?php echo sprintf( esc_html__( 'Rated %d out of 5', 'woocommerce' ), $rating ); ?>"></div>
		<?php
	}
	?>
</header>
<?php } else { ?>
	<header class="entry-header">
	<?php

	if ( $is_ajax ) {
		the_title( '<h4 class="product_title entry-title product-name"><a href="' . esc_url( get_permalink() ) . '">', '</a></h4>' );
	} else {
		if ( dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_shop_product_nav' ) ) ) {
			?>
			<div class="flex">
			<?php
			the_title( '<h4 class="product_title entry-title product-name">', '</h4>' );
			dima_product_next_prev_nav();
			?>
		   </div>
			<?php
		} else {
			the_title( '<h4 class="product_title entry-title product-name">', '</h4>' );
		}
	}

	?>
	<span class="dima-divider line-start line-hr small-line"></span>

</header>

	<?php } ?>
