<?php
/**
 * Single Product tabs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/tabs.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.8.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Filter tabs and allow third parties to add their own.
 *
 * Each tab is an array containing title, callback and priority.
 *
 * @see woocommerce_default_product_tabs()
 */
$product_tabs = apply_filters( 'woocommerce_product_tabs', array() );
if ( ! empty( $product_tabs ) ) :
	$tab_num = count( $product_tabs );
	?>

	<?php if ( dima_helper::dima_get_option( 'dima_shop_product_tap_display' ) == '1' ) : ?>

	<div class="ok-md-12 woocommerce-tabs dima-tabs tabs_style_1 tabs_on_top dima-tab-style columns-<?php echo esc_attr( $tab_num ); ?>-tab">
		<ul class="dima-tab-nav top" id="dima-tab-nav">

			<?php
			$first  = true;
			$active = 'active';
			foreach ( $product_tabs as $key => $tab ) :
				if ( $first ) {
					$first = false;
				} else {
					$active = '';
				}
				?>
				<li class="<?php echo esc_attr( $key ); ?>_tab tab <?php esc_attr_e( $active ); ?>">
					<a href="#tab-<?php echo esc_attr( $key ); ?>" data-toggle="tab"><?php echo apply_filters( 'woocommerce_product_' . esc_attr( $key ) . '_tab_title', esc_html( $tab['title'] ), $key ); ?></a>
				</li>
			<?php endforeach; ?>
			<?php do_action( 'woocommerce_product_after_tabs' ); ?>
		</ul>
		<div class="dima-tab-content">
			<?php
			$first  = true;
			$active = ' active';
			foreach ( $product_tabs as $key => $tab ) :
				if ( $first ) {
					$first = false;
				} else {
					$active = '';
				}
				?>
				<div class="tab-pane clearfix dima-tab_content fade in dima-<?php echo esc_attr( $key ); ?> <?php esc_attr_e( $active ); ?>" id="tab-<?php echo esc_attr( $key ); ?>">
					<?php call_user_func( $tab['callback'], $key, $tab ); ?>
				</div>
			<?php endforeach; ?>

		</div>
	</div>
		<?php
endif;
endif;
