<?php
/**
 * Single Product Sale Flash
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/sale-flash.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woothemes.com/document/template-structure/
 * @author        WooThemes
 * @package    WooCommerce/Templates
 * @version     1.6.4
 */

defined( 'ABSPATH' ) || exit;

global $post, $product;
$out_of_stock = get_post_meta( $post->ID, '_stock_status', true ) == 'outofstock';

?>
<?php if ( $product->is_on_sale() ) {
	echo apply_filters( 'woocommerce_sale_flash', '<span class="onsale"><span>' . esc_html__( 'Sale!', 'woocommerce' ) . '</span></span>', $post, $product );

} elseif ( $out_of_stock ) {
	echo apply_filters( 'woocommerce_sale_flash', '<span class="out_of_stock_flash"><span>' . esc_html__( 'Out of stock', 'woocommerce' ) . '</span></span>', $post, $product );
}

