<?php
/**
 * /**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.1
 */

defined( 'ABSPATH' ) || exit;

// Fallback to WC.2x Versions.
if ( ! dima_woocommerce_version_check( '3.0.0' ) ) {
	wc_get_template( 'woocommerce/single-product/w2-product-image.php' );

	return;
}

global $product, $woocommerce;

$columns        = apply_filters( 'dima_filter_woocommerce_product_thumbnails_columns', 5 );
$attachment_ids = dima_woocommerce_version_check( '3.0.0' ) ? $product->get_gallery_image_ids() : $product->get_gallery_attachment_ids();
$thumb_count    = count( $attachment_ids ) + 1;

wp_enqueue_script( 'slick.min' );

$animation             = dima_helper::dima_get_option( 'dima_shop_slide_animation' );
$animation             = ( $animation == 'fade' );
$js_data               = array(
	'slidesToShow'   => 1,
	'slidesToScroll' => 1,
	'fade'           => $animation,
	'asNavFor'       => '.slider-nav',
	'dots'           => false,
	'autoplay'       => false,
	'arrows'         => true,
	'infinite'       => false,
	'draggable'      => true,
	'adaptiveHeight' => false,
	'mobileFirst'    => true,
	'pauseOnHover'   => false,
	'speed'          => '300',
	'autoplaySpeed'  => '3000',
	'rtl'            => is_rtl(),
);
$product_gallery_style = dima_helper::dima_get_option( 'dima_product_gallery_style' );// classic

if ( DIMA_NOUR_ASSISTANT_IS_ACTIVE && $product_gallery_style === 'classic' ) {
	$data = dima_creat_data_attributes( 'slick_slider', $js_data );
} else {
	$data = '';
}

$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
$post_thumbnail_id = $product->get_image_id();
$wrapper_classes   = apply_filters(
	'woocommerce_single_product_image_gallery_classes',
	array(
		'woocommerce-product-gallery',
		'woocommerce-product-gallery--' . ( $product->get_image_id() ? 'with-images' : 'without-images' ),
		'woocommerce-product-gallery--columns-' . absint( $columns ),
		'images',
	)
);
$full_size_image   = wp_get_attachment_image_src( $post_thumbnail_id, 'full' );
$slider_classes    = array( 'slider-for', 'product-gallery-slider' );

$zoom_icon = '';
if ( current_theme_supports( 'wc-product-gallery-zoom' ) && $product_gallery_style === 'classic' ) {
	$zoom_icon        = '<a href="#" class="flex items-center flex-row dima-gallery__trigger woocommerce-product-gallery__trigger">' . dima_get_svg_icon( 'ic_fullscreen' ) . '</a>';
	$slider_classes[] = 'dima-zoom-active';
}


?>
<div class="product-main ok-row">
<div class="ok-md-5 ok-xsd-12">
	<div class="slick-slider <?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?>"
		 data-columns="<?php echo esc_attr( $columns ); ?>" style="opacity: 0; transition: opacity .25s ease-in-out;">
		<div class="relative">
		<figure class="woocommerce-product-gallery__wrapper <?php echo implode( ' ', $slider_classes ); ?>" <?php echo ( $data ); ?>>
			<?php
			if ( $product->get_image_id() ) {
				$html = dima_wc_get_gallery_image_html( $post_thumbnail_id, true );
			} else {
				$html  = '<div class="woocommerce-product-gallery__image--placeholder">';
				$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'woocommerce' ) );
				$html .= '</div>';
			}

			// Call Featured image.
			echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id ); // phpcs:disable WordPress.XSS.EscapeOutput.OutputNotEscaped

			// call sliders.
			do_action( 'woocommerce_product_thumbnails' );
			?>
		</figure>
		<?php echo $zoom_icon; ?>
		</div>
		<?php
		// Call small images.
		if ( $product_gallery_style === 'classic' ) {
			wc_get_template( 'woocommerce/single-product/product-gallery-thumbnails.php' );
		}

		?>
	</div>
</div>
