<?php
defined( 'ABSPATH' ) || exit;
global $post, $product, $woocommerce;

$attachment_ids  = $product->get_gallery_image_ids();
$columns         = apply_filters( 'dima_filter_woocommerce_product_thumbnails_columns', 5 );
$gallery_class   = array( 'product-thumbnails', 'thumbnails' );
$gallery_class[] = 'slider-nav';

$js_data = array(
	'slidesToShow'   => $columns,
	'slidesToScroll' => 1,
	'asNavFor'       => '.slider-for',
	'dots'           => false,
	'centerMode'     => false,
	'focusOnSelect'  => true,
	'speed'          => '500',
	'autoplaySpeed'  => '3000',
	'rtl'            => is_rtl(),
	'infinite'       => false,
);
if ( DIMA_NOUR_ASSISTANT_IS_ACTIVE ) {
	$data = dima_creat_data_attributes( 'slick_slider_nav', $js_data );
} else {
	$data = '';
}

$image_size = 'shop_thumbnail';

if ( $attachment_ids && $product->get_image_id() ) {
	?>
	<div class="<?php echo implode( ' ', $gallery_class ); ?>" <?php echo( $data ); ?> >

	<?php
	if ( has_post_thumbnail() ) :
		?>
		<div class="slick-item is-nav-selected first">
			<a>
			<?php
					$image_id  = get_post_thumbnail_id( $post->ID );
					$image     = wp_get_attachment_image_src( $image_id, apply_filters( 'woocommerce_gallery_thumbnail_size', $image_size ) );
					$image_alt = get_post_meta( $image_id, '_wp_attachment_image_alt', true );
					$image     = '<img src="' . $image[0] . '" alt="' . $image_alt . '" width="' . $image[1] . '" height="' . $image[2] . '" class="attachment-woocommerce_thumbnail" />';
					echo $image;
			?>
			</a>
		</div>
		<?php
	endif;

	foreach ( $attachment_ids as $attachment_id ) {
		$classes       = array( '' );
		$image_class   = esc_attr( implode( ' ', $classes ) );
		$image         = wp_get_attachment_image_src( $attachment_id, apply_filters( 'woocommerce_gallery_thumbnail_size', $image_size ) );
		$image_alt     = get_post_meta( $attachment_id, '_wp_attachment_image_alt', true );
		$image         = '<img src="' . $image[0] . '" alt="' . $image_alt . '" width="' . $image[1] . '" height="' . $image[2] . '"  class="attachment-woocommerce_thumbnail" />';
		$image_caption = wp_get_attachment_caption( $attachment_id );
		echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', sprintf( '<div class="slick-item"><a class="%s" title="%s" >%s</a></div>', $image_class, $image_caption, $image ), $attachment_id, $post->ID, $image_class );
	}
	?>
	</div>
	<?php
} ?>
