<?php

defined( 'ABSPATH' ) || exit;

?>
<?php
global $product;
$product_view = 'products-grids';
$review_count = $product->get_review_count();
?>

<?php
if ( isset( $_SERVER['QUERY_STRING'] ) ) {
	parse_str( $_SERVER['QUERY_STRING'], $params );
	if ( isset( $params['product_view'] ) ) {
		$product_view = $params['product_view'];
	}
}

?>

<header class="entry-header">
	<div class="product-content">
		<a href="<?php the_permalink(); ?>">
			<h5 class="product-name"><?php the_title(); ?></h5>
			<span class="dima-divider line-start line-hr small-line"></span>
		</a>
		<?php

		if ( ! dima_woocommerce_version_check( '3.0.0' ) ) {
			$rating = $product->get_rating_html();
		} else {
			$rating = wc_get_rating_html( $product->get_average_rating() );
		}
		if ( ! empty( $rating ) ) {
			echo '<div class="star-rating-container aggregate">' . $rating . '</div>';
		} else {
			?>
			<div class="star-rating"
				 title="<?php echo sprintf( esc_html__( 'Rated %d out of 5', 'woocommerce' ), $rating ); ?>"></div>
			<?php
		}
		if ( $review_count == 0 ) {
			echo '<span class="review-link">(<span class="count">' . $review_count . ' </span>' . esc_html__( 'Customer reviews', 'woocommerce' ) . ')</span>';
		} else {
			echo '<span class="review-link">(<span class="count">' . $review_count . ' </span>' . esc_html__( 'Customers reviews', 'woocommerce' ) . ')</span>';
		}
		?>
	</div>
</header>
