<?php
/**
 * Pagination - Show numbered pagination for catalog pages
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/pagination.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woothemes.com/document/template-structure/
 * @author        WooThemes
 * @package    WooCommerce/Templates
 * @version     3.3.1
 */

defined( 'ABSPATH' ) || exit;
if ( ! dima_woocommerce_version_check( '3.3.0' ) ) {
	global $wp_query;
	$total = $wp_query->max_num_pages;
	if ( $total <= 1 ) {
		return;
	}
} else {
	$total   = isset( $total ) ? $total : wc_get_loop_prop( 'total_pages' );
	$current = isset( $current ) ? $current : wc_get_loop_prop( 'current_page' );
	$base    = isset( $base ) ? $base : esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) );
	$format  = isset( $format ) ? $format : '';

	if ( $total <= 1 ) {
		return;
	}
}


?>
<nav class="woocommerce-pagination">
	<div class="ok-md-12">
		<div class="dima-pagination text-center">
			<?php
			if ( ! is_rtl() ) {
				$start_arrow = dima_get_svg_icon( 'ic_keyboard_arrow_left' );
				$end_arrow   = dima_get_svg_icon( 'ic_keyboard_arrow_right' );
			} else {
				$start_arrow = dima_get_svg_icon( 'ic_keyboard_arrow_right' );
				$end_arrow   = dima_get_svg_icon( 'ic_keyboard_arrow_left' );
			}

			echo paginate_links(
				apply_filters(
					'woocommerce_pagination_args',
					array(
						'base'      => esc_url( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) ),
						'format'    => '',
						'current'   => max( 1, get_query_var( 'paged' ) ),
						'total'     => $total,
						'prev_text' => '<span>' . esc_html__( 'Prev', 'woocommerce' ) . '</span>' . $start_arrow,
						'next_text' => '<span>' . esc_html__( 'Next', 'woocommerce' ) . '</span>' . $end_arrow,
						'type'      => 'list',
						'end_size'  => 3,
						'mid_size'  => 3,
					)
				)
			);
			?>
		</div><!--  end pagination container -->
	</div><!-- end large-12 -->
</nav>
<!-- end PAGINATION -->
