<?php
/**
 * Product Loop Start
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/loop-start.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woothemes.com/document/template-structure/
 * @author     WooThemes
 * @package    WooCommerce/Templates
 * @version    3.3.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $woocommerce_loop;
$classes      = $arry = array();
$product_view = dima_get_product_view();


if ( $product_view == 'grids' ) {
	$product_view = 'grid';
}
$classes[] = 'products';
$classes[] = $product_view == 'grid' ? 'products-grids' : 'products-list';
$columns   = dima_helper::dima_get_option( 'dima_shop_columns' );

// Reset according to sidebar or full-width pages.
if ( empty( $woocommerce_loop['columns'] ) ) {
	if ( is_shop() || is_product_category() || is_product_tag() || is_tax() ) {

		if ( is_shop() ) {
			$woocommerce_loop['columns'] = $columns;
		}
		if ( is_product_category() || is_product_tag() || is_tax() ) {
			$woocommerce_loop['columns'] = $columns;
		}
	}
}

$classes[] = 'dcl-m-' . $woocommerce_loop['columns'];
$classes   = join( ' ', $classes );

$animation_data  = '';
$animation_data .= 'data-animate=transition.slideUpIn';
$animation_data .= ' data-delay=30';
$animation_data .= ' data-offset=98%';
$animation_data .= ' data-dima-animate-item=.product';
$animation_data .= ' data-duration=750';
wp_enqueue_script( 'isotope.pkgd' );
?>
<div id="dima-isotope-container" class="<?php echo esc_attr( $classes ); ?>" <?php echo esc_attr( $animation_data ); ?>>
	<div class="dima-blocks dima-justify-start flex-wrap flex">
