<?php
/**
 * The template for displaying product category thumbnails within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product_cat.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<article <?php wc_product_cat_class( 'article-separation dima-product', $category ); ?>>
	<div class="effect-julia">
	<?php
	/**
	 * woocommerce_before_subcategory hook.add_theme_support( 'woocommerce'
	 *
	 * @hooked woocommerce_template_loop_category_link_open - 10
	 */
	do_action( 'woocommerce_before_subcategory', $category );
	/**
	 * woocommerce before subcategory title hook.
	 *
	 * @hooked woocommerce subcategory thumbnail - 10
	 */
	do_action( 'woocommerce_before_subcategory_title', $category );
	?>
	<header class="entry-header text-center">
		<div class="product-content dark-bg">
			<a href="<?php echo esc_url( get_category_link( $category->term_id ) ); ?>">
				<h5 class="product-name"><?php esc_attr_e( $category->name ); ?></h5>
				<span class="dima-divider line-center line-hr small-line"></span>
				<span class="count">
					<?php
					if ( $category->count > 0 ) {
						echo apply_filters( 'woocommerce_subcategory_count_html', $category->count . ' ' . ( $category->count > 1 ? __( 'Products', 'woocommerce' ) : __( 'Product', 'woocommerce' ) ), $category );
					}
					?>
				</span>
			</a>
		</div>
	</header>
	<?php

	/**
	 * woocommerce_after_subcategory_title hook.
	 */
	do_action( 'woocommerce_after_subcategory_title', $category );

	/**
	 * woocommerce_after_subcategory hook.
	 *
	 * @hooked woocommerce_template_loop_category_link_close - 10
	 */
	do_action( 'woocommerce_after_subcategory', $category );
	?>
	</div>
</article>
