<?php
/**
 * Checkout Form
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

wc_print_notices();

do_action( 'woocommerce_before_checkout_form', $checkout );

// If checkout registration is disabled and not logged in, the user cannot checkout
if ( ! $checkout->enable_signup && ! $checkout->enable_guest_checkout && ! is_user_logged_in() ) {
	echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', esc_html__( 'You must be logged in to checkout.', 'woocommerce' ) ) );
	return;
}

?>

<form name="checkout" method="post" class="checkout woocommerce-checkout"
      action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">
    <div class="ok-row">
        <div class="ok-md-6 ok-xsd-12">
			<?php if ( sizeof( $checkout->checkout_fields ) > 0 ) : ?>
				<?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>
                <div class="col2-set" id="customer_details">
                    <div class="col-1 dima-billing">
						<?php do_action( 'woocommerce_checkout_billing' ); ?>
                    </div>
                    <div class="dima-clear"></div>
                    <div class="col-2 dima-billing">
						<?php do_action( 'woocommerce_checkout_shipping' ); ?>
                    </div>
                </div>
				<?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>
			<?php endif; ?>
        </div>
        <div class="ok-md-6 ok-xsd-12">
            <div id="order_review" class="woocommerce-checkout-review-order box order-products dima-box">
                <h4 class="box-titel" id="order_review_heading"><?php esc_html_e( 'Your order', 'woocommerce' ); ?></h4>
				<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>
				<?php do_action( 'woocommerce_checkout_order_review' ); ?>
            </div>
        </div>
		<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>
    </div>
</form>

<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>
