<?php
/**
 * Empty cart page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-empty.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.0
 */

defined( 'ABSPATH' ) || exit;

?>
<p class="text-center">
	<?php echo dima_get_svg_icon( 'ic_stroke-shopping-cart' ); ?>
</p>
<h4 class="cart-empty text-center">
	<?php
	esc_attr_e( 'Your cart is currently empty.', 'woocommerce' );
	?>
</h4>
<p class="cart-empty text-center">
	<?php
	esc_attr_e( 'You may check out all the available products and buy some in the ', 'noor' );
	if ( wc_get_page_id( 'shop' ) > 0 ) {
		?>
		<a href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
			<?php esc_attr_e( 'Shop', 'noor' ); ?>
		</a>
		<?php
	} else {
		_e( 'Shop', 'noor' );
	}
	?>
</p>
<?php

$form = '<form class="dima-search-center woocommerce-product-search" role="search" method="get" id="searchform-5" action="' . esc_url( home_url( '/' ) ) . '">
			<input type="text" value="' . get_search_query() . '" name="s" placeholder="' . esc_html__( 'Search for products', 'noor' ) . '" />
			<input type="hidden" name="post_type" value="product" />
		</form>';

echo( $form );

?>
