<?php
/**
 * The template for displaying search form results pages
 *
 * @package noor
 * @author  PixelDima (https://pixeldima.com/)
 * @license Themeforest http://themeforest.net/licenses/regular_extended
 */

$search_default_type = dima_helper::dima_get_option( 'dima_search_default_type' );
$default_type        = '';
$get                 = isset( $_GET['s'] ) ? $_GET['s'] : '';
$_post_type          = isset( $_GET['post_type'] ) ? $_GET['post_type'] : '';
if ( '' !== $_post_type ) {
	$search_default_type = $_post_type;
}

if ( 'all' !== $search_default_type && ! empty( $search_default_type ) ) {
	$default_type = '<input type="hidden" name="post_type" value="' . $search_default_type . '">';
}
?>
<form method="get" class="form-small form search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label for="s" class="hide"><?php esc_html_e( 'Search', 'noor' ); ?></label>
	<input type="text" class="search-query" aria-label="<?php esc_html_e( 'Search', 'noor' ); ?>" name="s" value="<?php esc_attr_e( $get ); ?>" placeholder="<?php esc_attr_e( 'Search', 'noor' ); ?>"/>
	<?php echo $default_type; ?>
</form>
