<?php
/**
 * Theme functions and definitions
 *
 * @package   Dima Framework
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
update_option( 'noor_license_key_status', 'valid');
update_option( 'noor_license_key', 'babiato' );
update_option( 'noor_wup_purchase_code', 'babiato' );

if ( ! defined( 'DIMA_VERSION' ) ) {
	define( 'DIMA_VERSION', '5.3.7' );
}

if ( ! defined( 'DIMA_THEME_OPTIONS' ) ) {
	define( 'DIMA_THEME_OPTIONS', apply_filters( 'dima_options_name', 'dima_theme_options' ) );
}
require_once wp_normalize_path( get_template_directory() . '/framework/dima-framework.php' );
require_once wp_normalize_path( get_template_directory() . '/framework/functions/helper/class-dima.php' );


/**
 * Instantiates the Dima class.
 * Make sure the class is properly set-up.
 * The Dima class is a singleton
 * so we can directly access the one true Dima object using this function.
 *
 * @return object Dima
 */
function Dima() {
	return Dima::get_instance();
}

// Require Files.
// With require_once you can override these files with child theme it uses.
// load_template() to include the files which uses require_once().
/* System Paths. */
$dima_admin_path = get_template_directory() . '/framework/functions/admin';
$dima_tmg_path   = get_template_directory() . '/framework/functions/admin/includes/tmg';

// TMG.
require_once $dima_tmg_path . '/class-tgm-plugin-activation.php';
require_once $dima_tmg_path . '/registration.php';
require_once $dima_tmg_path . '/updates.php';

require_once $dima_admin_path . '/includes/function-update.php';

require_once $dima_admin_path . '/includes/merlin/vendor/autoload.php';
require_once $dima_admin_path . '/includes/merlin/class-merlin.php';
// require ABSPATH . 'wp-content/MerlinWP/class-merlin.php';
require_once $dima_admin_path . '/includes/merlin-config.php';
require_once $dima_admin_path . '/includes/merlin-filters.php';


// Enqueue scripts and styles.
require_once 'framework/functions/scripts.php';
require_once 'framework/functions/styles.php';

// Helper.
require_once 'framework/functions/helper/filters.php';

require_once 'framework/functions/helper/dynamic-styles.php';
require_once 'framework/functions/helper/rich-snippets.php';
require_once 'framework/functions/helper/dima_media_support.php';
require_once 'framework/functions/helper/svg-icons.php';
require_once 'framework/functions/helper/open-graph.php';
require_once 'framework/functions/helper/advertisment.php';
require_once 'framework/functions/helper/classes.php';
require_once 'framework/functions/helper/pagination.php';


/**
 * Make sure language-all works correctly.
 *
 * @since 3.5
 */
function dima_set_language_is_all() {
	Dima::set_language_is_all( true );
}
add_action( 'dima_library_set_language_is_all', 'dima_set_language_is_all' );

/**
 * Make sure the dima_Multilingual class has been instantiated.
 */
if ( ! property_exists( $dima_library, 'multilingual' ) || ! $dima_library->multilingual ) {
	 $dima_library->multilingual = new Dima_Multilingual();
}


// Output.
require_once 'framework/functions/output/dima-class-breadcrumbs.php';
require_once 'framework/functions/output/featured.php';
require_once 'framework/functions/output/navbar.php';
require_once 'framework/functions/output/content-helper.php';

// Global Function.
require_once 'framework/functions/setup.php';
require_once 'framework/functions/__noor-data.php';

// specific functions.
require_once 'framework/functions/__noor-template.php';

// Admin.
require_once 'framework/functions/admin/gutenberg/setup.php';
require_once 'framework/functions/admin/meta/setup.php';
require_once 'framework/functions/admin/widgets.php';
require_once 'framework/functions/admin/customizer/setup.php';
require_once 'framework/functions/admin/pixeldima-setup.php';

if ( is_admin() && file_exists( $dima_admin_path . '/meta/inc/cmb2/init.php' ) ) {
	require_once 'framework/functions/admin/meta/inc/cmb2/init.php';
	require_once 'framework/functions/admin/meta/inc/cmb2-conditionals/cmb2-conditionals.php';
	require_once 'framework/functions/admin/meta/inc/cmb2-tabs/init.php';
	require_once 'framework/functions/admin/meta/inc/dima-meta-types/init.php';
	require_once 'framework/functions/admin/meta/inc/cmb2_rgba_picker/jw-cmb2-rgba-colorpicker.php';
}


/**
 * Instantiate Noor_fonts.
 * Only do this while in the dashboard, not needed on the frontend.
 */
if ( ! is_admin() ) {
	global $dima_webfonts;
	$dima_webfonts = new DIMA_Webfonts();
}

/**
 * Reset all Dima Caches.
 *
 * @since 3.5
 *
 * @param array $delete_cache An array of caches to delete.
 */
function dima_reset_all_caches( $delete_cache = array() ) {
	// Reset dima-caches.
	if ( ! class_exists( 'Dima_Cache' ) ) {
		require_once 'framework/functions/helper/class-dima-cache.php';
	}

	$dima_cache = new Dima_Cache();
	$dima_cache->reset_all_caches( $delete_cache );

	wp_cache_flush();
}


// Plugins Integrations.
require_once 'framework/functions/extensions/dima-mega-menu/dima-mega-menu.php';

if ( DIMA_WC_IS_ACTIVE ) {
	require_once 'framework/functions/extensions/woocommerce.php';
}
if ( DIMA_KB_IS_ACTIVE ) {
	require_once 'framework/functions/extensions/knowledge-base.php';
}
if ( DIMA_EDD_IS_ACTIVE ) {
	require_once 'framework/functions/extensions/edd.php';
}
if ( DIMA_AMP_IS_ACTIVE ) {
	 require_once 'framework/functions/extensions/amp/class-amp.php';
}
if ( DIMA_BBPRESS_IS_ACTIVE ) {
	require_once 'framework/functions/extensions/bbpress.php';
}
if ( DIMA_BUDDYPRESS_IS_ACTIVE ) {
	require_once 'framework/functions/extensions/buddypress.php';
}
if ( DIMA_REVOLUTION_SLIDER_IS_ACTIVE ) {
	require_once 'framework/functions/extensions/revolution-slider.php';
}
if ( DIMA_YITH_WISHLIST_IS_ACTIVE ) {
	require_once 'framework/functions/extensions/wc-yith-wishlist/yith-wishlist.php';
}

/**
 * Run this code only once
 */
function dima_db_opt_update() {
	if ( get_option( 'dima_db_opt_update_01' ) !== 'completed' ) {

		$fa = dima_helper::dima_am_i_true( get_option( 'dima_fontawesome_five' ) );
		if ( ! $fa ) {
			update_option( 'dima_fontawesome_five', '1' );
		}

		update_option( 'dima_db_opt_update_01', 'completed' );
	}

	/**
	 * Updates Global option values. by default theme_option is: dima_theme_options
	 * It triggered only once.
	 */
	if ( get_option( 'dima_db_add_dima_theme_options' ) !== 'completed' ) {
		// Get the default theme options.
		global $dima_customizer_data;

		$dima_option_group = DIMA_THEME_OPTIONS;
		/**
		 * Test if the theme options is exists or not.
		 */
		$_db_options      = false === get_option( $dima_option_group ) ? array() : delete_option( $dima_option_group );
		$all_options_name = array();
		$all_options_name = dima_customizer_options_list();
		$new_options      = array();

		/**
		 * Loop All theme options.
		 * -- Test if the option is exist or not.
		 * -- If the option not exist it will take the default option from $dima_customizer_data array.
		 * -- If it's exist update the theme option and delet the old option from the database.
		 */
		foreach ( $all_options_name as $option_name ) {
			$val = get_option( $option_name );
			if ( false !== $val ) {
				$new_options[ $option_name ] = $val;
				/* Clear the database from the old option */
				delete_option( $option_name );
			} else {
				$new_options[ $option_name ] = $dima_customizer_data[ $option_name ];
			}
		}

		/**
		 * Update the theme option, using the new options array saved on $new_options.
		 */
		add_option( $dima_option_group, $new_options );
		update_option( 'dima_db_add_dima_theme_options', 'completed' );
	}

	/**
	 * Fore Noor 4
	 */
	if ( get_option( 'dima_db_opt_update_42' ) !== 'completed' && get_option( 'dima_db_add_dima_theme_options' ) === 'completed' ) {

		$underline  = dima_helper::dima_get_option( 'dima_navbar_text_hover_color' );
		$menu_hover = dima_helper::dima_get_option( 'dima_menu_hover_text_color' );
		dima_helper::dima_update_option( 'dima_navbar_underline_hover_color', $underline );
		dima_helper::dima_update_option( 'dima_navbar_text_hover_color', $menu_hover );

		update_option( 'dima_db_opt_update_42', 'completed' );
	}

}
add_action( 'init', 'dima_db_opt_update' );
