<?php
/**
 * Views: index.php ( The main template file )
 * displays all of the <class="container">
 * 1 → Archive author & search: _archive-header
 * 2 → main template file: index.php
 * 3 → Sidebar
 *
 * @package Dima Framework
 * @subpackage root views
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */
?>

<?php get_header(); ?>

	<div class="container">
		<main class="page-section-content">
			<?php
			$_post_type = isset( $_GET['post_type'] ) ? $_GET['post_type'] : '';
			$get        = isset( $_GET['s'] ) ? $_GET['s'] : '';

			$search_portfolio_active = $search_blog_active = $search_edd_active = $search_all_active = false;
			$advanced_search         = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_search_advanced' ) );
			$search_activated_on     = dima_helper::dima_get_option( 'dima_search_activated_on' );

			$space = '';
			if ( strpos( $search_activated_on, 'blog' ) !== false ) {
				$search_blog_active = true;
				$space              = '<div class="clear-section"></div>';
			}
			if ( strpos( $search_activated_on, 'all' ) !== false ) {
				$search_all_active = true;
				$space             = '<div class="clear-section"></div>';
			}
			if ( strpos( $search_activated_on, 'edd' ) !== false ) {
				$search_edd_active = true;
				$space             = '<div class="clear-section"></div>';
			}
			if ( strpos( $search_activated_on, 'portfolio' ) !== false ) {
				$search_portfolio_active = true;
				$space                   = '<div class="clear-section"></div>';

			}
			?>

			<div class="<?php dima_main_content_class(); ?>" role="main">

				<?php
				do_action( 'dima_start_of_search_result' );
				?>

				<p><?php echo esc_html__( 'Not so happy with results? Search for a new keyword', 'noor' ); ?></p>

				<div class="dima-clear"></div>

				<?php get_search_form(); ?>
				<?php
				if ( $advanced_search ) {
					if ( $_post_type ) {
						$array_query = array(
							'post_type' => "{$_post_type}",
							's'         => "{$get}",
						);
						$the_query   = new WP_Query( $array_query );
						$count       = $the_query->found_posts;
					}
					$all_txt       = apply_filters( 'search_all_txt', esc_html__( 'All', 'noor' ) );
					$blog_txt      = apply_filters( 'search_blog_txt', esc_html__( 'Blog', 'noor' ) );
					$edd_txt       = apply_filters( 'search_products_txt', esc_html__( 'Products', 'noor' ) );
					$portfolio_txt = apply_filters( 'search_portfolio_txt', esc_html__( 'Portfolio', 'noor' ) );

					echo( $space );
					?>
				<div class="dima-tabs tabs_style_1 tabs_on_top">
					<ul class="dima-tab-nav top">
										<?php do_action( 'dima_action_before_search_tab' ); ?>
								<?php if ( DIMA_NOUR_ASSISTANT_IS_ACTIVE && $search_all_active ) { ?>
							<li class="tab <?php echo ( ! isset( $_GET['post_type'] ) ) ? 'active' : ''; ?>">
								<a href="?s=<?php echo $get; ?>"><?php esc_html_e( $all_txt ); ?></a>
							</li>
						<?php } ?>
								<?php if ( DIMA_NOUR_ASSISTANT_IS_ACTIVE && $search_blog_active ) { ?>
							<li class="tab <?php echo ( isset( $_GET['post_type'] ) && $_GET['post_type'] == 'post' ) ? 'active' : ''; ?>">
								<a href="?s=<?php echo $get; ?>&post_type=post"><?php esc_html_e( $blog_txt ); ?></a>
							</li>
						<?php } ?>
								<?php if ( DIMA_NOUR_ASSISTANT_IS_ACTIVE && $search_edd_active ) { ?>
							<li class="tab <?php echo ( isset( $_GET['post_type'] ) && $_GET['post_type'] == 'download' ) ? 'active' : ''; ?>">
								<a href="?s=<?php echo $get; ?>&post_type=download"><?php esc_html_e( $edd_txt ); ?></a>
							</li>
						<?php } ?>
								<?php if ( DIMA_NOUR_ASSISTANT_IS_ACTIVE && $search_portfolio_active ) { ?>
							<li class="tab <?php echo ( isset( $_GET['post_type'] ) && $_GET['post_type'] == 'dima-portfolio' ) ? 'active' : ''; ?>">
								<a href="?s=<?php echo $get; ?>&post_type=dima-portfolio"><?php esc_html_e( $portfolio_txt ); ?></a>
							</li>
						<?php } ?>
								<?php do_action( 'dima_action_after_search_tab' ); ?>
					</ul>
				</div>
					<?php
				} else {
					global $wp_query;
					$count = $wp_query->found_posts;
				}
				?>

				<?php
				if ( 0 !== $count ) {
					$result = $count . ' ' . esc_html__( 'search results for', 'noor' ) . ': ' . get_search_query();
				} else {
					$result = esc_html__( 'No results found', 'noor' );
				}
				?>
				<div class="clear-section"></div>
				<h5 class="dima-custom-heading dima-search-title"><?php echo( $result ); ?></h5>
				<div class="clear-section"></div>

				<?php

				if ( $advanced_search ) {
					// The main template file.
					switch ( $_post_type ) {
						case 'post':
							if ( DIMA_NOUR_ASSISTANT_IS_ACTIVE ) {
								do_action( 'dima_action_get_blog_shortcode_search' );
							}
							break;
						case 'download':
							if ( DIMA_EDD_IS_ACTIVE && DIMA_NOUR_ASSISTANT_IS_ACTIVE ) {
								do_action( 'dima_action_get_edd_shortcode_search' );
							}
							break;
						case 'dima-portfolio':
							if ( DIMA_NOUR_ASSISTANT_IS_ACTIVE ) {
								do_action( 'dima_action_get_portfolio_shortcode_search' );
							}
							break;
						default:
							dima_get_blog_shortcode_theme( true );
							break;
					}
				} else {
					dima_get_blog_shortcode_theme( true );
				}
				do_action( 'dima_end_of_search_result' );
				?>

			</div>
			<?php get_sidebar(); ?>
		</main>
	</div>
<?php
get_footer();
