<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Displays:
 *          1 → shortcode above sidebar.
 *          2 → page content & comments.
 *          3 → Sidebar | Note: Sidebar will hide if layout is full-width.
 *          4 → Footer.
 *
 * @package Dima Framework
 * @subpackage root views
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

// Based on options selected in metabox.
$section_layout = dima_get_section_layout_meta();
$content_layout = dima_get_content_layout();
// If fullWidth do not show sidebar.
if ( 'full-width' === $section_layout ) {
	get_header();
	dima_helper::dima_display_shortcode_above_sidebar();
	dima_helper::dima_get_view( 'partials/contents', 'page-content' );
	get_footer();
} elseif ( 'no-sidebar' === $content_layout ) {
	get_header();
	?>
	<div class="container">
		<div class="page-section-content">
			<?php dima_helper::dima_display_shortcode_above_sidebar(); ?>
			<?php dima_helper::dima_get_view( 'partials/contents', 'page-content' ); ?>
		</div>
	</div>
	<?php
	get_footer();
} else {
	get_header();
	?>
	<div class="container">
		<div class="page-section-content">
			<?php dima_helper::dima_display_shortcode_above_sidebar(); ?>
			<?php dima_helper::dima_get_view( 'partials/contents', 'page-content' ); ?>
			<?php get_sidebar(); ?>
		</div>
	</div>
	<?php
	get_footer();
}
