<?php
/**
 * Views: index.php ( The main template file )
 * displays all of the <class="container">
 * 1 → Archive author & search: _archive-header
 * 2 → main template file: index.php
 * 3 → Sidebar
 *
 * @package Dima Framework
 * @subpackage root views
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */
?>

<?php get_header(); ?>

<div class="container">
	<main class="page-section-content">
		<div class="<?php dima_main_content_class(); ?>" role="main">
			<?php
			// The archive template is used when visitors.
			// → author.
			dima_helper::dima_get_view( 'partials/contents', '_archive-header' );

			if ( is_home() ) {
				dima_get_blog_shortcode_theme();
			} elseif ( is_archive() ) {
				if ( ! isset( $post->post_type ) ) {
					dima_helper::dima_get_view( 'partials/contents', 'content-none' );
				} else {
					if ( 'dima-portfolio' === $post->post_type && DIMA_NOUR_ASSISTANT_IS_ACTIVE ) {
						$column          = dima_helper::dima_get_option( 'dima_projects_related_columns' );
						$portfolio_style = 'grid';
						$type            = 'portfolio';
						$no_margin       = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_portfolio_page_margin' ) );
						$filters         = dima_helper::dima_get_option( 'dima_portfolio_page_filters' );
						$img_hover       = dima_helper::dima_get_option( 'dima_projects_related_img_hover' );
						$elm_hover       = dima_helper::dima_get_option( 'dima_projects_related_elm_hover' );
						$count           = dima_helper::dima_get_option( 'dima_portfolio_page_count' );
						$paging          = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_portfolio_page_is_pagination' ) );

						echo do_shortcode(
							'[portfolio img_hover="' . esc_attr( $img_hover ) . '"
								elm_hover="' . esc_attr( $elm_hover ) . '"
								filters="' . esc_attr( $filters ) . '"
								count="' . esc_attr( $count ) . '"
								paging="' . esc_attr( $paging ) . '"
								portfolio_style="' . esc_attr( $portfolio_style ) . '"
								type="' . esc_attr( $type ) . '"
								column="' . esc_attr( $column ) . '"
								no_margin="' . esc_attr( $no_margin ) . '"]'
						);
					} elseif ( 'download' === $post->post_type && DIMA_NOUR_ASSISTANT_IS_ACTIVE ) {
						echo do_shortcode(
							'[dima_edd edd_style="grid" words="0" paging="true" category="" ids="" post_class=""]'
						);
					} else {
						dima_get_blog_shortcode_theme();
					}
				}
			} elseif ( is_search() ) {
				dima_get_blog_shortcode_theme( true );
			}

			?>
		</div>
		<?php get_sidebar(); ?>
	</main>
</div>

<?php get_footer(); ?>
