<?php
/**
 * @package Dima Framework
 * @subpackage root views
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

$layout         = dima_get_content_layout();
$section_layout = dima_get_section_layout_meta();
if ( 'full-width' === $section_layout && $layout === 'no-sidebar' ) {
	get_header();
	?>
	<div class="<?php dima_main_content_class(); ?>" role="main">
		<?php woocommerce_content(); ?>
	</div>
	<?php
	get_sidebar();
	if ( is_product() ) {
		dima_post_navigation();
	}
	get_footer();
} else {
	get_header();
	?>
	<div class="container">
		<div class="page-section-content">
			<?php
			if ( is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy() && dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_shop_sort' ) ) ) {
				do_action( 'dima_shop_sort_header' );
			}
			?>
			<div class="<?php dima_main_content_class(); ?>" role="main">
				<?php woocommerce_content(); ?>
			</div>
			<?php get_sidebar(); ?>
		</div>
	</div>
	<?php
	if ( is_product() ) {
		dima_post_navigation();
	}
	get_footer();
}
