<?php
/**
 * @package Dima Framework
 * @subpackage views global
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

// Outputs the navbar.
$header_position  = dima_get_header_positioning();
$full_width_class = dima_helper::dima_get_header_content_wrapper( true );
$is_search_active = dima_helper::dima_am_i_true( dima_helper::dima_get_inherit_option( '_dima_meta_search_display', 'dima_header_search_enable' ) );
$menu_icon        = dima_helper::dima_get_option( 'dima_mobile_menu_icon', 'ic_menu' );
?>

<div class="<?php dima_navbar_class(); ?>">
	<?php do_action( 'dima_action_before_navbar' ); ?>
	<div class="<?php echo esc_attr( $full_width_class ); ?>">
		<div class="mobile-nav-head clearfix">
			<!-- Nav bar button -->
			<a class="dima-btn-nav dima-open-menu" href="#">
				<span class="menu_icon_item"><?php echo dima_get_svg_icon( $menu_icon ); ?></span>
				<span class="menu_icon_item sort_ic"><?php echo dima_get_svg_icon( 'ic_clear' ); ?></span>
			</a>
			<?php if ( $is_search_active ) { ?>
			<a class="dima-btn-nav search-btn" href="#">
				<span class="menu_icon_item"><?php echo dima_get_svg_icon( 'ic_search' ); ?></span>
			</a>
			<?php } ?>
			<!-- LOGO -->
			<div class="logo">
				<p class="site-title">
					<?php dima_helper::dima_get_view( 'partials/header', 'brand-mobile' ); ?>
				</p>
			</div>
		</div>
		<!-- Manue -->
		<?php dima_helper::dima_get_view( 'partials/header', 'nav', 'primary-mobile' ); ?>

	</div>
	<!-- container -->
	<?php do_action( 'dima_action_after_navbar' ); ?>
</div>
