<?php
/**
 * This is the template that displays all of the <head> section and everything up until <div id="all_content">
 *
 * @package Dima Framework
 * @subpackage global view
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

?>
	<!DOCTYPE html>
	<!--[if IE 9]>
	<html class="no-js ie9" <?php language_attributes(); ?>>
	<![endif]-->
	<!--[if gt IE 9]><!-->
<html class="no-js" <?php language_attributes(); ?>>
	<!--<![endif]-->

	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<!-- Always force latest IE rendering engine (even in intranet) & Chrome Frame -->
		<!--[if IE ]>
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<![endif]-->
		<link rel="profile" href="http://gmpg.org/xfn/11">
		<?php
		if ( 'local' !== dima_helper::dima_get_option( 'dima_gfonts_load_method' ) ) {
			?>
			<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
			<?php
		}
		?>

		<?php
		$theme_color = dima_helper::dima_get_option( 'dima_main_color' );
		$theme_color = ( $theme_color !== '' ) ? $theme_color : '#333333';
		if ( $theme_color !== '' ) {
			echo '<meta name="theme-color" content="' . esc_attr( $theme_color ) . '">';
		}

		if ( ! function_exists( 'dima_meta_site_icon' ) && ! dima_helper::dima_wp_version_check( '4.3' ) ) {
			dima_meta_site_icon();
		}
		dima_meta();
		?>
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
		<?php wp_head(); ?>
	</head>

<body <?php body_class(); ?>>
<?php do_action( 'dima_after_body_open_tag' ); ?>
	<?php
	dima_helper::dima_get_view( 'partials/header', 'search-burger' );
	if ( dima_get_site_layout() == 'framed' ) {
		dima_helper::dima_get_view( 'partials/header', 'content', 'dima-border' );
	}
	?>
	<div id="dima-wrapper" class="all_content">
<?php

// Call Loading screen if the user active it from the customizr.
if ( dima_helper::dima_am_i_true( dima_helper::dima_get_inherit_option( '_dima_meta_loading', 'dima_loading' ) ) ) {
	dima_helper::dima_get_view( 'partials/header', 'dima-loading' );
}
