<?php
/**
 * DESCRIPTION: Branding logo (Display logo if selected and the website name if not ).
 *
 * @package Dima Framework
 * @subpackage views global
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

$website_name        = get_bloginfo( 'name' );
$website_description = get_bloginfo( 'description' );

// Get logo & 2x and sticky logo & 2x depend on direction RTL or LTR.
if ( ! is_rtl() ) {
	$logo    = dima_helper::dima_get_inherit_option( '_dima_meta_header_logo', 'dima_header_logo' );
	$logo_x2 = dima_helper::dima_get_inherit_option( '_dima_meta_header_logo_retina', 'dima_header_logo_retina' );

	$logo_sticky    = dima_helper::dima_get_inherit_option( '_dima_meta_header_sticky_logo', 'dima_header_sticky_logo' );
	$logo_sticky_x2 = dima_helper::dima_get_inherit_option( '_dima_meta_header_sticky_logo_retina', 'dima_header_sticky_logo_retina' );
} else {
	$logo = dima_helper::dima_get_inherit_option( '_dima_meta_header_logo_rtl', 'dima_header_logo_rtl' );
	if ( empty( $logo ) ) {
		$logo = dima_helper::dima_get_inherit_option( '_dima_meta_header_logo', 'dima_header_logo' );
	}
	$logo_x2 = dima_helper::dima_get_inherit_option( '_dima_meta_header_logo_retina_rtl', 'dima_header_logo_retina_rtl' );
	if ( empty( $logo_x2 ) ) {
		$logo_x2 = dima_helper::dima_get_inherit_option( '_dima_meta_header_logo_retina', 'dima_header_logo_retina' );
	}
	$logo_sticky = dima_helper::dima_get_inherit_option( '_dima_meta_header_sticky_logo_rtl', 'dima_header_sticky_logo_rtl' );
	if ( empty( $logo_sticky ) ) {
		$logo_sticky = dima_helper::dima_get_inherit_option( '_dima_meta_header_sticky_logo', 'dima_header_sticky_logo' );
	}
	$logo_sticky_x2 = dima_helper::dima_get_inherit_option( '_dima_meta_header_sticky_logo_retina_rtl', 'dima_header_sticky_logo_retina_rtl' );
	if ( empty( $logo_sticky_x2 ) ) {
		$logo_sticky_x2 = dima_helper::dima_get_inherit_option( '_dima_meta_header_sticky_logo_retina', 'dima_header_sticky_logo_retina' );
	}
}
// Get logo & 2x and sticky logo & 2x depend on direction RTL or LTR.

$homeurl = apply_filters( 'dima_filters_logo_url', esc_url( home_url( '/' ) ) );
?>

<a class="dima-brand" href="<?php echo esc_url( $homeurl ); ?>" title="<?php echo esc_attr( $website_description ); ?>">
	<?php

	// No sticky logo our menu is not transparent.
	// if ( ! dima_is_transparent_navigation() || '' === $logo_sticky ) {

	if ( '' === $logo_sticky ) {
		?>
		<span class="no-sticky-logo">
			<?php $standard_logo = dima_helper::get_logo_image_srcset( $logo, $logo_x2 ); ?>
			<!-- standard logo -->
		<?php
		if ( null !== $standard_logo ) {
			?>
				<!-- standard logo -->
				<img src="<?php echo esc_url_raw( $standard_logo['url'] ); ?>" srcset="<?php echo esc_attr( $standard_logo['srcset'] ); ?>" width="<?php echo esc_attr( $standard_logo['width'] ); ?>" height="<?php echo esc_attr( $standard_logo['height'] ); ?>"<?php echo $standard_logo['style']; // phpcs:ignore WordPress.Security.EscapeOutput ?> alt="<?php echo esc_attr( $website_description ); ?>" data-retina_logo_url="<?php echo esc_url_raw( $standard_logo['is_retina'] ); ?>" class="standard-logo" />
				<?php
		} else {
			echo esc_attr( $website_name );
		}
		?>
		</span>
		<?php
	} else {
		?>
		<span class="no-fixed-logo">
		<?php $standard_logo = dima_helper::get_logo_image_srcset( $logo, $logo_x2 ); ?>
			<!-- standard logo -->
		<?php
		if ( $standard_logo != null ) {
			?>
				<!-- standard logo -->
				<img src="<?php echo esc_url_raw( $standard_logo['url'] ); ?>" srcset="<?php echo esc_attr( $standard_logo['srcset'] ); ?>" width="<?php echo esc_attr( $standard_logo['width'] ); ?>" height="<?php echo esc_attr( $standard_logo['height'] ); ?>"<?php echo $standard_logo['style']; // phpcs:ignore WordPress.Security.EscapeOutput ?> alt="<?php echo esc_attr( $website_description ); ?>" data-retina_logo_url="<?php echo esc_url_raw( $standard_logo['is_retina'] ); ?>" class="standard-logo" />
				<?php
		} else {
			echo esc_attr( $website_name );
		}
		?>
		</span>
		<span class="fixed-logo">
			<?php $sticky_logo = dima_helper::get_logo_image_srcset( $logo_sticky, $logo_sticky_x2 ); ?>
			<!-- standard logo -->
			<img src="<?php echo esc_url_raw( $sticky_logo['url'] ); ?>" srcset="<?php echo esc_attr( $sticky_logo['srcset'] ); ?>" width="<?php echo esc_attr( $sticky_logo['width'] ); ?>" height="<?php echo esc_attr( $sticky_logo['height'] ); ?>"<?php echo $sticky_logo['style']; // phpcs:ignore WordPress.Security.EscapeOutput ?> alt="<?php echo esc_attr( $website_description ); ?>" data-retina_logo_url="<?php echo esc_url_raw( $sticky_logo['is_retina'] ); ?>" class="standard-logo" />
		</span>
	<?php } ?>
</a>
