<?php
/**
 * DESCRIPTION: Branding logo (Display logo if selected and the website name if not ).
 *
 * @package Dima Framework
 * @subpackage views global
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

$website_name        = get_bloginfo( 'name' );
$website_description = get_bloginfo( 'description' );
$logo_2x_info        = $logo_info = $logo_mobile_2x  = '';

$logo           = dima_helper::dima_get_inherit_option( '_dima_meta_header_logo', 'dima_header_logo' );
$logo_2x        = dima_helper::dima_get_inherit_option( '_dima_meta_header_logo_retina', 'dima_header_logo_retina' );
$logo_mobile    = dima_helper::dima_get_inherit_option( '_dima_meta_header_mobile_logo', 'dima_header_mobile_logo' );
$logo_mobile_2x = dima_helper::dima_get_inherit_option( '_dima_meta_header_mobile_logo_retina', 'dima_header_mobile_logo_retina' );

$rtl_logo = dima_helper::dima_get_inherit_option( '_dima_meta_header_logo_rtl', 'dima_header_logo_rtl' );
if ( is_rtl() && '' !== $rtl_logo ) {
	$logo           = dima_helper::dima_get_inherit_option( '_dima_meta_header_logo_rtl', 'dima_header_logo_rtl' );
	$logo_2x        = dima_helper::dima_get_inherit_option( '_dima_meta_header_logo_retina_rtl', 'dima_header_logo_retina_rtl' );
	$logo_mobile    = dima_helper::dima_get_inherit_option( '_dima_meta_header_mobile_logo_rtl', 'dima_header_mobile_logo_rtl' );
	$logo_mobile_2x = dima_helper::dima_get_inherit_option( '_dima_meta_header_mobile_logo_retina_rtl', 'dima_header_mobile_logo_retina_rtl' );
}

if ( '' !== $logo_mobile ) {
	$logo = $logo_mobile;
}
if ( '' !== $logo_mobile_2x ) {
	$logo_2x = $logo_mobile_2x;
}
if ( '' !== $logo_mobile && '' === $logo_mobile_2x ) {
	$logo_2x = $logo;
}


$homeurl = apply_filters( 'dima_filters_logo_url', esc_url( home_url( '/' ) ) );

?>

<a class="dima-brand" href="<?php echo esc_url( $homeurl ); ?>" title="<?php echo esc_attr( $website_description ); ?>">
	<?php $standard_logo = dima_helper::get_logo_image_srcset( $logo, $logo_2x ); ?>
	<?php
	if ( null !== $standard_logo ) {
		?>
			<!-- standard logo -->
			<img src="<?php echo esc_url_raw( $standard_logo['url'] ); ?>" srcset="<?php echo esc_attr( $standard_logo['srcset'] ); ?>" width="<?php echo esc_attr( $standard_logo['width'] ); ?>" height="<?php echo esc_attr( $standard_logo['height'] ); ?>"<?php echo $standard_logo['style']; // phpcs:ignore WordPress.Security.EscapeOutput ?> alt="<?php echo esc_attr( $website_description ); ?>" data-retina_logo_url="<?php echo esc_url_raw( $standard_logo['is_retina'] ); ?>" class="mobile-logo" />
			<?php
	} else {
		echo esc_attr( $website_name );
	}
	?>
</a>
