<?php
/**
 * The template for copyright in footer.
 *
 * @package Dima Framework
 * @subpackage views global
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

$footer_full       = dima_helper::dima_am_i_true( dima_helper::dima_get_inherit_option( '_dima_meta_footer_full_width', 'dima_footer_full_width' ) );
$footer_full       = ( $footer_full ) ? 'full-width-footer' : 'container';
$dima_menu_display = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_footer_menu_display' ) );
$dima_copyright    = dima_helper::dima_get_option( 'dima_footer_content_text' );
$dima_class        = 'float-start';
$footer_is_big     = dima_helper::dima_am_i_true( dima_helper::dima_get_inherit_option( '_dima_meta_footer_big', 'dima_footer_big' ) );
$is_center         = dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_footer_bottom_center' ) );
$allowed_tags      = array(
	'strong' => array(),
	'br'     => array(),
	'em'     => array(),
	'p'      => array( 'a' => true ),
	'a'      => array(
		'href'   => true,
		'target' => true,
		'title'  => true,
	),
);
$dima_class        = 'text-start';
if ( $dima_menu_display ) {
	$dima_class = 'float-start';
} elseif ( $is_center ) {
	$dima_class = 'float-center';
}
?>
<?php
$small_footer = $second_footer_on_off = dima_helper::dima_am_i_true( dima_helper::dima_get_inherit_option( '_dima_meta_small_footer_on_off', 'dima_footer_bottom' ) );

if ( $small_footer ) {
	?>
	<div class="<?php dima_footer_class(); ?>">
		<?php

		if ( ! $footer_is_big && is_single() ) {
			?>
			<div class="dima-spacer-module" data-units="px" data-all_size="30" data-xld_resolution="1600"
				 data-xld_size="30" data-ld_resolution="1400" data-ld_size="30" data-md_resolution="1170"
				 data-md_size="30" data-sd_resolution="969" data-sd_size="30" data-xsd_resolution="480"
				 data-xsd_size="30" style="height: 30px;">
			</div>
			<?php
		}
		?>
		<div class="<?php echo sanitize_html_class( $footer_full ); ?>">

			<?php if ( dima_helper::dima_am_i_true( dima_helper::dima_get_option( 'dima_footer_content_display' ) ) ) : ?>
				<div class="copyright <?php echo esc_attr( $dima_class ); ?>">
					<?php
					echo wp_kses( $dima_copyright, $allowed_tags );
					?>
				</div>
			<?php endif; ?>

			<?php
			if ( dima_helper::dima_am_i_true( $dima_menu_display ) ) :
				dima_helper::dima_get_view( 'partials/footer', 'nav', 'footer' );
			endif;
			?>

		</div>
	</div>
<?php } ?>
