<?php
/**
 * @package Dima Framework
 * @subpackage root views
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

if ( is_singular() && ! is_page() ) {
	$args = dima_helper::get_featured_args();
} else {
	$args = dima_helper::get_featured_args( $this );
}

?>
<article <?php post_class( $args['post_class'] ); ?> >
	<?php if ( is_sticky() && ( $args['blog_type'] == 'standard' || ! DIMA_NOUR_ASSISTANT_IS_ACTIVE ) ) { ?>
		<div class="post-icon on_the_front">
			<ul class="icons-media">
				<li class="dima_go_sticky">
					<?php echo dima_helper::dima_get_sticky(); ?>
				</li>
			</ul>
		</div>
		<?php
	}

	if ( $args['post_title_above'] && ! ( is_singular() && is_single() ) ) {
		dima_helper::dima_get_view( 'partials/contents', '_content', 'post-header' );
	} elseif ( is_singular() && is_single() ) {
		dima_helper::dima_get_view( 'partials/contents', '_content', 'post-header' );
	}
	if ( ( $args['blog_type'] != 'masonry' && $args['blog_type'] != 'slide' && $args['blog_type'] != 'grid' ) || ( is_singular() && ! is_page() ) ) {
		dima_get_entry_meta( $args );
	}

	if ( $args['show_image'] ) {
		dima_featured_image(
			array(
				'post_type' => $args['blog_type'],
				'img_hover' => $args['img_hover'],
				'elm_hover' => $args['elm_hover'],
			)
		);
	}

	if ( ! $args['post_title_above'] && ! ( is_singular() && is_single() ) ) {
		dima_helper::dima_get_view( 'partials/contents', '_content', 'post-header' );
		?>
		<hr class="entry-title-hr">
		<?php
	}

	if ( ( $args['blog_type'] == 'masonry' || $args['blog_type'] == 'slide' || $args['blog_type'] == 'grid' ) && ( ! is_singular() || is_page() ) ) {
		dima_get_entry_meta( $args );
	}

	?>

	<div class="<?php dima_pots_content_class(); ?>">
		<?php dima_get_post_content( $args['is_full_post_content_blog'], $args['words'] ); ?>
		<?php dima_helper::dima_get_view( 'partials/contents', '_content', 'post-footer' ); ?>
	</div>
</article>
