<?php
/**
 * @package Dima Framework
 * @subpackage root views
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */
if ( is_singular() && ! is_page() ) {
	$args = dima_helper::get_featured_args();
} else {
	$args = dima_helper::get_featured_args( $this );
}

$section_layout = dima_get_section_layout_meta();
$pagination     = dima_helper::dima_am_i_true( dima_helper::dima_get_inherit_option( '', 'dima_edd_details_pagination' ) );
if ( $section_layout != 'full-width' ) {
	?>

	<?php get_header(); ?>

	<div class="page-section-content">
		<div class="container">
			<div class="<?php dima_main_content_class(); ?>" role="main">
			<?php
			if ( have_posts() ) :
				dima_featured_image(
					array(
						'post_type' => $args['blog_type'],
						'img_hover' => $args['img_hover'],
						'elm_hover' => $args['elm_hover'],
					)
				);
				the_post();
				dima_helper::dima_get_view( 'edd', '_content', 'single-edd' );
			endif;
			?>
			</div>
			<?php get_sidebar(); ?>
		</div>
	</div>
	<?php
	if ( is_single() && $pagination ) :
		dima_post_navigation();
	endif;
	get_footer();
} else {
	get_header();
	?>
	<?php
	if ( have_posts() ) :
		the_post();
		dima_helper::dima_get_view( 'edd', '_content', 'single-edd' );
	endif;
	if ( is_single() && $pagination ) :
		dima_post_navigation();
	endif;
	get_footer();
}
