<?php
/**
 * @package Dima Framework
 * @subpackage root views
 * @version   1.0.0
 * @since     1.0.0
 * @author    PixelDima <info@pixeldima.com>
 */

if ( is_singular() && ! is_page() ) {
	$args = dima_helper::get_featured_args();
} else {
	$args = dima_helper::get_featured_args( $this );
}

$elm_hover = dima_helper::dima_get_option( 'dima_shop_elm_hover' );

$classes   = array();
$classes[] = 'dima-shadow has-hover';
if ( $elm_hover == 'inside' ) {
	$classes[] = 'dima_go_inside';
}
$id       = get_the_ID();
$download = new EDD_Download( $id );
if ( empty( $download->ID ) ) {
	return false;
}

?>

<article id="edd_download_<?php the_ID(); ?>" <?php post_class( $args['post_class'] ); ?>>
	<div <?php echo 'class="' . join( ' ', $classes ) . '"'; ?>>
		<?php
		global $edd_download_shortcode_item_atts, $edd_download_shortcode_item_i;
		$download_id = get_the_ID();
		do_action( 'edd_download_before' );

		if ( 'false' !== $edd_download_shortcode_item_atts['thumbnails'] ) :
			dima_edd_product_thumbnails();
			do_action( 'edd_download_after_thumbnail' );
		endif;
		?>
		<header class="entry-header">
			<div class="dima-edd-content">
				<div class="dima-edd-top-meta">
					<a class="dima-edd-title" href="<?php the_permalink(); ?>">
						<h6 class="dima-edd-name edd_download_title"><?php the_title(); ?></h6>
						<span class="dima-divider line-start line-hr small-line"></span>
					</a>

					<?php if ( ! edd_has_variable_prices( $download_id ) ) { ?>
						<div>
							<div class="download-meta-price-details" itemprop="price">
								<?php
								if ( $download->is_free() ) {
									?>
									<span class="edd_price" id="edd_price_8"><?php esc_attr_e( 'Free', 'noor' ); ?></span>
									<?php
								} else {
									edd_price( $download_id );
								}
								?>
							</div>
						</div>
					<?php } elseif ( edd_has_variable_prices( $download_id ) ) { ?>
						<?php $item_props = edd_add_schema_microdata() ? ' itemprop="offers" itemscope itemtype="http://schema.org/Offer"' : ''; ?>
						<div<?php echo $item_props; ?>>
							<div class="download-meta-price-details" itemprop="price">
								<!-- Get the price range -->
								<?php echo edd_price_range( $download_id ); ?>
							</div>
						</div>
					<?php }; ?>
				</div>

				<?php do_action( 'edd_download_after_price' ); ?>
				<?php
				if ( dima_helper::dima_am_i_true( $args['words'] ) ) {?>

					<div itemprop="description" class="entry-excerpt">
						<?php
						the_excerpt();
						?>
					</div>

				<?php } ?>

				<?php if ( ! in_array( 'hide_author', get_post_class( $args['post_class'] ) ) ) { ?>
					<div class="dima-edd-meta">
						<span class="img-circle dima-edd-avatar float-start">
							<?php echo get_avatar( get_the_author_meta( 'email' ), '30' ); ?>
						</span>
						<span class="dima-edd-author"><?php _e( 'By', 'noor' ); ?>&nbsp;<?php the_author(); ?></span>
					</div>
				<?php } ?>
			</div>
		</header>
		<?php
		do_action( 'edd_download_after_title' );
		do_action( 'edd_download_after' );
		?>
	</div>
</article>
