<?php
/**
 * A single download inside of the [downloads] shortcode.
 *
 * @since 2.8.0
 *
 * @package EDD
 * @category Template
 * @author Easy Digital Downloads
 * @version 1.0.0
 */

global $edd_download_shortcode_item_atts, $edd_download_shortcode_item_i;

if ( is_singular() && ! is_page() ) {
	$args = dima_helper::get_featured_args();
} else {
	$args = dima_helper::get_featured_args( $this );
}

$content_layout = dima_get_content_layout();
$section_layout = dima_get_section_layout_meta();

?>

	<span class="hide"> <?php echo strip_tags( the_title( '', '', false ) ); ?> </span>
	<div class="<?php echo esc_attr( apply_filters( 'edd_download_class', 'edd_download', get_the_ID(), $edd_download_shortcode_item_atts, $edd_download_shortcode_item_i ) ); ?>"
		 id="edd_download_<?php the_ID(); ?>">

		<div class="<?php echo esc_attr( apply_filters( 'edd_download_inner_class', 'edd_download_inner', get_the_ID(), $edd_download_shortcode_item_atts, $edd_download_shortcode_item_i ) ); ?>">
			<?php
			do_action( 'edd_download_before' );
			?>
			<div class="<?php dima_pots_content_class(); ?>">
				<?php
				if ( ( $content_layout == 'no-sidebar' || $content_layout == 'mini' ) && $section_layout != 'full-width' ) {
					dima_get_post_content( $args['is_full_post_content_blog'], $args['words'] );
					do_action( 'edd_download_after_content' );
				} else {
					?>
					<div class="edd_download_full_content">
						<?php
						the_content();
						?>
					</div>
					<?php
					do_action( 'edd_download_after_content' );
				}
				if ( $section_layout != 'full-width' && dima_helper::dima_am_i_true( dima_helper::dima_get_meta( '_dima_download_shear_icon' ) ) ) {
					dima_helper::dima_get_view( 'portfolio', 'portfolio-footer' );
				}

				?>
			</div>
			<?php
			do_action( 'edd_download_after' );
			do_action( 'edd_after_download_content' );
			do_action( 'dima_end_of_edd' );
			?>
		</div>
	</div>
